/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class CachingDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 3258415049197565235L;
    public static final String FORMAT_FULL_GENERIC = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FORMAT_CMIS_SQL = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String[] LENIENT_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH", "yyyy-MM-dd'T'", "yyyy-MMM-dd'T'HH:mm:ss.SSS", "yyyy-MMM-dd", "yyyy-MMM-dd'T'HH:mm:ss.SSSZ", "yyyy-MMM-dd'T'HH:mm:ss", "yyyy-MMM-dd'T'HH:mm", "yyyy-MMM-dd'T'HH", "yyyy-MMM-dd'T'"};
    public static final String FORMAT_DATE_GENERIC = "yyyy-MM-dd";
    public static final String FORMAT_TIME_GENERIC = "HH:mm:ss";
    private static ThreadLocal<SimpleDateFormat> s_localDateFormat = new ThreadLocal();
    private static ThreadLocal<SimpleDateFormat> s_localDateOnlyFormat = new ThreadLocal();
    private static ThreadLocal<SimpleDateFormat> s_localTimeOnlyFormat = new ThreadLocal();
    private static ThreadLocal<SimpleDateFormat> s_localCmisSqlDatetime = new ThreadLocal();
    private static ThreadLocal<SimpleDateFormat[]> s_lenientParsers = new ThreadLocal();
    private transient Map<String, Date> cacheDates = new WeakHashMap<String, Date>(89);

    private CachingDateFormat(String format) {
        super(format);
    }

    public String toString() {
        return this.toPattern();
    }

    public static SimpleDateFormat getDateFormat(int length, Locale locale, boolean lenient) {
        SimpleDateFormat dateFormat = (SimpleDateFormat)CachingDateFormat.getDateInstance(length, locale);
        String pattern = dateFormat.toPattern();
        return CachingDateFormat.getDateFormat(pattern, lenient);
    }

    public static SimpleDateFormat getDateTimeFormat(int dateLength, int timeLength, Locale locale, boolean lenient) {
        SimpleDateFormat dateFormat = (SimpleDateFormat)CachingDateFormat.getDateTimeInstance(dateLength, timeLength, locale);
        String pattern = dateFormat.toPattern();
        return CachingDateFormat.getDateFormat(pattern, lenient);
    }

    public static SimpleDateFormat getDateFormat(String pattern, boolean lenient) {
        CachingDateFormat dateFormat = new CachingDateFormat(pattern);
        dateFormat.setLenient(lenient);
        return dateFormat;
    }

    public static SimpleDateFormat getDateFormat() {
        if (s_localDateFormat.get() != null) {
            return s_localDateFormat.get();
        }
        CachingDateFormat formatter = new CachingDateFormat(FORMAT_FULL_GENERIC);
        formatter.setLenient(false);
        s_localDateFormat.set(formatter);
        return s_localDateFormat.get();
    }

    public static SimpleDateFormat getCmisSqlDatetimeFormat() {
        if (s_localCmisSqlDatetime.get() != null) {
            return s_localCmisSqlDatetime.get();
        }
        CachingDateFormat formatter = new CachingDateFormat(FORMAT_CMIS_SQL);
        formatter.setLenient(false);
        s_localCmisSqlDatetime.set(formatter);
        return s_localCmisSqlDatetime.get();
    }

    public static SimpleDateFormat getDateOnlyFormat() {
        if (s_localDateOnlyFormat.get() != null) {
            return s_localDateOnlyFormat.get();
        }
        CachingDateFormat formatter = new CachingDateFormat(FORMAT_DATE_GENERIC);
        formatter.setLenient(false);
        s_localDateOnlyFormat.set(formatter);
        return s_localDateOnlyFormat.get();
    }

    public static SimpleDateFormat getTimeOnlyFormat() {
        if (s_localTimeOnlyFormat.get() != null) {
            return s_localTimeOnlyFormat.get();
        }
        CachingDateFormat formatter = new CachingDateFormat(FORMAT_TIME_GENERIC);
        formatter.setLenient(false);
        s_localTimeOnlyFormat.set(formatter);
        return s_localTimeOnlyFormat.get();
    }

    public Date parse(String text, ParsePosition pos) {
        Date cached = this.cacheDates.get(text);
        if (cached == null) {
            Date date = super.parse(text, pos);
            if (date != null && pos.getIndex() == text.length()) {
                this.cacheDates.put(text, date);
                Date clonedDate = (Date)date.clone();
                return clonedDate;
            }
            return date;
        }
        pos.setIndex(text.length());
        Date clonedDate = (Date)cached.clone();
        return clonedDate;
    }

    public static Date lenientParse(String text) throws ParseException {
        SimpleDateFormat[] formatters;
        for (SimpleDateFormat formatter : formatters = CachingDateFormat.getLenientFormatters()) {
            try {
                return formatter.parse(text);
            }
            catch (ParseException e) {
            }
        }
        throw new ParseException("Unknown date format", 0);
    }

    public static SimpleDateFormat[] getLenientFormatters() {
        if (s_lenientParsers.get() != null) {
            return s_lenientParsers.get();
        }
        int i = 0;
        SimpleDateFormat[] formatters = new SimpleDateFormat[LENIENT_FORMATS.length];
        for (String format : LENIENT_FORMATS) {
            CachingDateFormat formatter = new CachingDateFormat(format);
            formatter.setLenient(false);
            formatters[i++] = formatter;
        }
        s_lenientParsers.set(formatters);
        return s_lenientParsers.get();
    }
}

