/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.File;

public class JNDIPath {
    String mount_point_;
    String jndi_path_;
    String avm_path_;
    int avm_version_;

    public JNDIPath(String mount_point, String jndi_path) throws Exception {
        this.mount_point_ = mount_point;
        this.jndi_path_ = jndi_path;
        int repo_head = this.mount_point_.length();
        if (this.mount_point_.charAt(repo_head - 1) != File.separatorChar) {
            ++repo_head;
        }
        int repo_tail = this.jndi_path_.indexOf(File.separatorChar, repo_head);
        String repo_name = this.jndi_path_.substring(repo_head, repo_tail);
        int vers_head = repo_tail + "/VERSION/v".length();
        if (vers_head < 0) {
            throw new IllegalArgumentException("Bad version in JNDI path: " + this.jndi_path_);
        }
        int vers_tail = this.jndi_path_.indexOf(File.separatorChar, vers_head);
        if (vers_tail < 0) {
            throw new IllegalArgumentException("Bad version delimeter in JNDI path: " + this.jndi_path_);
        }
        try {
            String vers_string = this.jndi_path_.substring(vers_head, vers_tail);
            this.avm_version_ = Integer.parseInt(vers_string);
        }
        catch (Exception e) {
            this.avm_version_ = -1;
        }
        String repo_relpath = this.jndi_path_.substring(vers_tail + "/DATA".length(), this.jndi_path_.length());
        this.avm_path_ = repo_name + ":" + repo_relpath;
        if (File.separatorChar != '/') {
            this.avm_path_ = this.avm_path_.replace(File.separatorChar, '/');
        }
    }

    public String getFileDirMountPoint() {
        return this.mount_point_;
    }

    public String getJndiPath() {
        return this.jndi_path_;
    }

    public String getAvmPath() {
        return this.avm_path_;
    }

    public int getAvmVersion() {
        return this.avm_version_;
    }
}

