/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.resource;

import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class HierarchicalResourceLoader
extends DefaultResourceLoader
implements InitializingBean {
    public static final String DEFAULT_DIALECT_PLACEHOLDER = "#resource.dialect#";
    public static final String DEFAULT_DIALECT_REGEX = "\\#resource\\.dialect\\#";
    private String dialectBaseClass;
    private String dialectClass;

    public void setDialectBaseClass(String className) {
        this.dialectBaseClass = className;
    }

    public void setDialectClass(String className) {
        this.dialectClass = className;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, "dialectBaseClass", this.dialectBaseClass);
        PropertyCheck.mandatory((Object)this, "dialectClass", this.dialectClass);
    }

    public Resource getResource(String location) {
        String newLocation;
        Class<?> dialectClazz;
        Class<?> dialectBaseClazz;
        if (this.dialectClass == null || this.dialectBaseClass == null) {
            return super.getResource(location);
        }
        String dialectBaseClassStr = this.dialectBaseClass;
        if (!PropertyCheck.isValidPropertyString(this.dialectBaseClass)) {
            String prop = PropertyCheck.getPropertyName(this.dialectBaseClass);
            dialectBaseClassStr = System.getProperty(prop, this.dialectBaseClass);
        }
        String dialectClassStr = this.dialectClass;
        if (!PropertyCheck.isValidPropertyString(this.dialectClass)) {
            String prop = PropertyCheck.getPropertyName(this.dialectClass);
            dialectClassStr = System.getProperty(prop, this.dialectClass);
        }
        try {
            dialectBaseClazz = Class.forName(dialectBaseClassStr);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dialect base class not found: " + dialectBaseClassStr);
        }
        try {
            dialectClazz = Class.forName(dialectClassStr);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dialect class not found: " + dialectClassStr);
        }
        if (!Object.class.isAssignableFrom(dialectBaseClazz)) {
            throw new RuntimeException("Dialect base class must be derived from java.lang.Object: " + dialectBaseClazz.getName());
        }
        if (!Object.class.isAssignableFrom(dialectClazz)) {
            throw new RuntimeException("Dialect class must be derived from java.lang.Object: " + dialectClazz.getName());
        }
        if (!dialectBaseClazz.isAssignableFrom(dialectClazz)) {
            throw new RuntimeException("Non-existent HierarchicalResourceLoader hierarchy: " + dialectBaseClazz.getName() + " is not a superclass of " + dialectClazz);
        }
        Class<?> clazz = dialectClazz;
        Resource resource = null;
        while (!(resource != null || (resource = super.getResource(newLocation = location.replaceAll(DEFAULT_DIALECT_REGEX, clazz.getName()))) != null && resource.exists())) {
            resource = null;
            if (clazz.equals(dialectBaseClazz)) break;
            if ((clazz = clazz.getSuperclass()) != null) continue;
            throw new RuntimeException("Non-existent HierarchicalResourceLoaderBean hierarchy: " + dialectBaseClazz.getName() + " is not a superclass of " + dialectClazz);
        }
        return resource;
    }
}

