/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigProperties;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebFrameworkConfigElement
extends ConfigElementAdapter
implements WebFrameworkConfigProperties {
    private static final long serialVersionUID = 1L;
    public static final String MODE_DEVELOPMENT = "development";
    public static final String MODE_PREVIEW = "preview";
    public static final String MODE_PRODUCTION = "production";
    public static final String DEFAULT_WEBFRAMEWORK_USER_FACTORY_ID = "webframework.factory.user.default";
    public static final String DEFAULT_WEBFRAMEWORK_MODEL_OBJECT_SEARCH_PATH_ID = "webframework.modelobject.searchpath";
    public static final String DEFAULT_WEBFRAMEWORK_MODEL_OBJECT_STORE_ID = "webframework.model.store.classpath";
    public static final String CONFIG_ELEMENT_ID = "web-framework";
    protected HashMap<String, FormatDescriptor> formats = new HashMap();
    protected HashMap<String, ErrorHandlerDescriptor> errorHandlers = new HashMap();
    protected HashMap<String, SystemPageDescriptor> systemPages = new HashMap();
    protected HashMap<String, TagLibraryDescriptor> tagLibraries = new HashMap();
    protected HashMap<String, String> pageTypes = new HashMap();
    protected HashMap<String, TypeDescriptor> types = new HashMap();
    protected HashMap<String, ResourceLoaderDescriptor> resourceLoaders = new HashMap();
    protected HashMap<String, ResourceResolverDescriptor> resourceResolvers = new HashMap();
    protected HashMap<String, RuntimeConfigDescriptor> runtimeConfigs = new HashMap();
    protected boolean isTimerEnabled = false;
    protected String defaultLinkBuilderFactoryId = null;
    protected String defaultRequestContextFactoryId = null;
    protected String defaultUserFactoryId = null;
    protected String defaultFormatId = null;
    protected String defaultRegionChrome = null;
    protected String defaultComponentChrome = null;
    protected String defaultTheme = null;
    protected String defaultSiteConfiguration = null;
    protected String defaultPersisterId = null;
    protected PersisterConfigDescriptor persisterConfigDescriptor = null;
    protected String autowireModeId;
    protected String autowireRuntimeId;

    public WebFrameworkConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public ConfigElement combine(ConfigElement element) {
        WebFrameworkConfigElement configElement = (WebFrameworkConfigElement)element;
        WebFrameworkConfigElement combinedElement = new WebFrameworkConfigElement();
        combinedElement.formats.putAll(this.formats);
        combinedElement.errorHandlers.putAll(this.errorHandlers);
        combinedElement.systemPages.putAll(this.systemPages);
        combinedElement.tagLibraries.putAll(this.tagLibraries);
        combinedElement.types.putAll(this.types);
        combinedElement.pageTypes.putAll(this.pageTypes);
        combinedElement.resourceLoaders.putAll(this.resourceLoaders);
        combinedElement.resourceResolvers.putAll(this.resourceResolvers);
        combinedElement.runtimeConfigs.putAll(this.runtimeConfigs);
        combinedElement.formats.putAll(configElement.formats);
        combinedElement.errorHandlers.putAll(configElement.errorHandlers);
        combinedElement.systemPages.putAll(configElement.systemPages);
        combinedElement.tagLibraries.putAll(configElement.tagLibraries);
        combinedElement.types.putAll(configElement.types);
        combinedElement.pageTypes.putAll(configElement.pageTypes);
        combinedElement.resourceLoaders.putAll(configElement.resourceLoaders);
        combinedElement.resourceResolvers.putAll(configElement.resourceResolvers);
        combinedElement.runtimeConfigs.putAll(configElement.runtimeConfigs);
        combinedElement.isTimerEnabled = this.isTimerEnabled;
        if (configElement.isTimerEnabled) {
            combinedElement.isTimerEnabled = configElement.isTimerEnabled;
        }
        combinedElement.defaultLinkBuilderFactoryId = this.defaultLinkBuilderFactoryId;
        if (configElement.defaultLinkBuilderFactoryId != null) {
            combinedElement.defaultLinkBuilderFactoryId = configElement.defaultLinkBuilderFactoryId;
        }
        combinedElement.defaultRequestContextFactoryId = this.defaultRequestContextFactoryId;
        if (configElement.defaultRequestContextFactoryId != null) {
            combinedElement.defaultRequestContextFactoryId = configElement.defaultRequestContextFactoryId;
        }
        combinedElement.defaultUserFactoryId = this.defaultUserFactoryId;
        if (configElement.defaultUserFactoryId != null) {
            combinedElement.defaultUserFactoryId = configElement.defaultUserFactoryId;
        }
        combinedElement.defaultFormatId = this.defaultFormatId;
        if (configElement.defaultFormatId != null) {
            combinedElement.defaultFormatId = configElement.defaultFormatId;
        }
        combinedElement.defaultRegionChrome = this.defaultRegionChrome;
        if (configElement.defaultRegionChrome != null) {
            combinedElement.defaultRegionChrome = configElement.defaultRegionChrome;
        }
        combinedElement.defaultComponentChrome = this.defaultComponentChrome;
        if (configElement.defaultComponentChrome != null) {
            combinedElement.defaultComponentChrome = configElement.defaultComponentChrome;
        }
        combinedElement.defaultTheme = this.defaultTheme;
        if (configElement.defaultTheme != null) {
            combinedElement.defaultTheme = configElement.defaultTheme;
        }
        combinedElement.defaultSiteConfiguration = this.defaultSiteConfiguration;
        if (configElement.defaultSiteConfiguration != null) {
            combinedElement.defaultSiteConfiguration = configElement.defaultSiteConfiguration;
        }
        combinedElement.defaultPersisterId = this.defaultPersisterId;
        if (configElement.defaultPersisterId != null) {
            combinedElement.defaultPersisterId = configElement.defaultPersisterId;
        }
        for (TypeDescriptor type : combinedElement.getTypes()) {
            if (!type.useDefaultPerister()) continue;
            type.setPersisterId(combinedElement.defaultPersisterId);
        }
        combinedElement.autowireModeId = this.autowireModeId;
        if (configElement.autowireModeId != null) {
            combinedElement.autowireModeId = configElement.autowireModeId;
        }
        combinedElement.autowireRuntimeId = this.autowireRuntimeId;
        if (configElement.autowireRuntimeId != null) {
            combinedElement.autowireRuntimeId = configElement.autowireRuntimeId;
        }
        combinedElement.persisterConfigDescriptor = this.persisterConfigDescriptor;
        if (configElement.persisterConfigDescriptor != null) {
            combinedElement.persisterConfigDescriptor = configElement.persisterConfigDescriptor;
        }
        return combinedElement;
    }

    @Override
    public String[] getFormatIds() {
        return this.formats.keySet().toArray(new String[this.formats.size()]);
    }

    @Override
    public FormatDescriptor getFormatDescriptor(String id) {
        return this.formats.get(id);
    }

    @Override
    public String[] getErrorHandlerIds() {
        return this.errorHandlers.keySet().toArray(new String[this.errorHandlers.size()]);
    }

    @Override
    public ErrorHandlerDescriptor getErrorHandlerDescriptor(String id) {
        return this.errorHandlers.get(id);
    }

    @Override
    public String[] getSystemPageIds() {
        return this.systemPages.keySet().toArray(new String[this.systemPages.size()]);
    }

    @Override
    public SystemPageDescriptor getSystemPageDescriptor(String id) {
        return this.systemPages.get(id);
    }

    @Override
    public String[] getTagLibraryIds() {
        return this.tagLibraries.keySet().toArray(new String[this.tagLibraries.size()]);
    }

    @Override
    public TagLibraryDescriptor getTagLibraryDescriptor(String id) {
        return this.tagLibraries.get(id);
    }

    public Collection<TypeDescriptor> getTypes() {
        return this.types.values();
    }

    @Override
    public String[] getTypeIds() {
        return this.types.keySet().toArray(new String[this.types.size()]);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String id) {
        return this.types.get(id);
    }

    @Override
    public String[] getResourceLoaderIds() {
        return this.resourceLoaders.keySet().toArray(new String[this.resourceLoaders.size()]);
    }

    @Override
    public ResourceLoaderDescriptor getResourceLoaderDescriptor(String id) {
        return this.resourceLoaders.get(id);
    }

    @Override
    public String[] getResourceResolverIds() {
        return this.resourceResolvers.keySet().toArray(new String[this.resourceResolvers.size()]);
    }

    @Override
    public ResourceResolverDescriptor getResourceResolverDescriptor(String id) {
        return this.resourceResolvers.get(id);
    }

    @Override
    public boolean isTimerEnabled() {
        return this.isTimerEnabled;
    }

    @Override
    public String getDefaultRegionChrome() {
        return this.defaultRegionChrome;
    }

    @Override
    public String getDefaultComponentChrome() {
        return this.defaultComponentChrome;
    }

    @Override
    public String[] getDefaultPageTypeIds() {
        return this.pageTypes.keySet().toArray(new String[this.pageTypes.size()]);
    }

    @Override
    public String getDefaultPageTypeInstanceId(String id) {
        return this.pageTypes.get(id);
    }

    @Override
    public String getDefaultThemeId() {
        if (this.defaultTheme == null) {
            return "default";
        }
        return this.defaultTheme;
    }

    @Override
    public String getDefaultSiteConfigurationId() {
        if (this.defaultSiteConfiguration == null) {
            return "default.site.configuration";
        }
        return this.defaultSiteConfiguration;
    }

    @Override
    public String getDefaultFormatId() {
        if (this.defaultFormatId == null) {
            return "default";
        }
        return this.defaultFormatId;
    }

    @Override
    public String getDefaultUserFactoryId() {
        if (this.defaultUserFactoryId == null) {
            return DEFAULT_WEBFRAMEWORK_USER_FACTORY_ID;
        }
        return this.defaultUserFactoryId;
    }

    @Override
    public String getDefaultPersisterId() {
        return this.defaultPersisterId;
    }

    @Override
    public boolean isAutowireModeDevelopment() {
        return MODE_DEVELOPMENT.equals(this.autowireModeId);
    }

    @Override
    public boolean isAutowireModeProduction() {
        return MODE_PRODUCTION.equals(this.autowireModeId);
    }

    @Override
    public boolean isAutowireModePreview() {
        return MODE_PREVIEW.equals(this.autowireModeId);
    }

    @Override
    public String getAutowireModeId() {
        return this.autowireModeId;
    }

    @Override
    public String getAutowireRuntimeId() {
        return this.autowireRuntimeId;
    }

    @Override
    public boolean isPreviewEnabled() {
        return this.isAutowireModePreview();
    }

    @Override
    public RuntimeConfigDescriptor getRuntimeConfigDescriptor(String id) {
        return this.runtimeConfigs.get(id);
    }

    @Override
    public PersisterConfigDescriptor getPersisterConfigDescriptor() {
        return this.persisterConfigDescriptor;
    }

    protected static WebFrameworkConfigElement newInstance(Element elem) {
        Element persisterConfigElement;
        String _isTimerEnabled;
        Element debugElement;
        WebFrameworkConfigElement configElement = new WebFrameworkConfigElement();
        List formats = elem.elements("format");
        for (Element el : formats) {
            FormatDescriptor descriptor = new FormatDescriptor(el);
            configElement.formats.put(descriptor.getId(), descriptor);
        }
        List errorHandlers = elem.elements("error-handler");
        for (Element el : errorHandlers) {
            ErrorHandlerDescriptor descriptor = new ErrorHandlerDescriptor(el);
            configElement.errorHandlers.put(descriptor.getId(), descriptor);
        }
        List systemPages = elem.elements("system-page");
        for (Element el : systemPages) {
            SystemPageDescriptor descriptor = new SystemPageDescriptor(el);
            configElement.systemPages.put(descriptor.getId(), descriptor);
        }
        List tagLibraries = elem.elements("tag-library");
        for (Element el : tagLibraries) {
            TagLibraryDescriptor descriptor = new TagLibraryDescriptor(el);
            configElement.tagLibraries.put(descriptor.getId(), descriptor);
        }
        Element defaults = elem.element("defaults");
        if (defaults != null) {
            String _defaultPersisterId;
            String _theme;
            String _componentChrome;
            String _regionChrome;
            String _format;
            String _userFactoryId;
            String _linkBuilderFactoryId;
            String _requestContextFactoryId = defaults.elementTextTrim("request-context-factory");
            if (_requestContextFactoryId != null) {
                configElement.defaultRequestContextFactoryId = _requestContextFactoryId;
            }
            if ((_linkBuilderFactoryId = defaults.elementTextTrim("link-builder-factory")) != null) {
                configElement.defaultLinkBuilderFactoryId = _linkBuilderFactoryId;
            }
            if ((_userFactoryId = defaults.elementTextTrim("user-factory")) != null) {
                configElement.defaultUserFactoryId = _userFactoryId;
            }
            if ((_format = defaults.elementTextTrim("format")) != null) {
                configElement.defaultFormatId = _format;
            }
            if ((_regionChrome = defaults.elementTextTrim("region-chrome")) != null) {
                configElement.defaultRegionChrome = _regionChrome;
            }
            if ((_componentChrome = defaults.elementTextTrim("component-chrome")) != null) {
                configElement.defaultComponentChrome = _componentChrome;
            }
            if ((_theme = defaults.elementTextTrim("theme")) != null && _theme.length() != 0) {
                configElement.defaultTheme = _theme;
            }
            List pageTypes = defaults.elements("page-type");
            for (Element pageType : pageTypes) {
                String pageTypeId = pageType.elementTextTrim("id");
                String pageTypeInstanceId = pageType.elementTextTrim("page-instance-id");
                configElement.pageTypes.put(pageTypeId, pageTypeInstanceId);
            }
            String _siteConfiguration = defaults.elementTextTrim("site-configuration");
            if (_siteConfiguration != null) {
                configElement.defaultSiteConfiguration = _siteConfiguration;
            }
            if ((_defaultPersisterId = defaults.elementText("persister")) != null) {
                configElement.defaultPersisterId = _defaultPersisterId;
            }
        }
        if ((debugElement = elem.element("debug")) != null && (_isTimerEnabled = debugElement.elementTextTrim("timer")) != null) {
            configElement.isTimerEnabled = Boolean.parseBoolean(_isTimerEnabled);
        }
        List objectTypes = elem.elements("object-type");
        for (Element el : objectTypes) {
            TypeDescriptor descriptor = new TypeDescriptor(el);
            if (descriptor.useDefaultPerister() && configElement.getDefaultPersisterId() != null) {
                descriptor.setPersisterId(configElement.getDefaultPersisterId());
            }
            configElement.types.put(descriptor.getId(), descriptor);
        }
        List loaders = elem.elements("resource-loader");
        for (Element el : loaders) {
            ResourceLoaderDescriptor descriptor = new ResourceLoaderDescriptor(el);
            configElement.resourceLoaders.put(descriptor.getId(), descriptor);
        }
        List resolvers = elem.elements("resource-resolver");
        for (Element el : resolvers) {
            ResourceResolverDescriptor descriptor = new ResourceResolverDescriptor(el);
            configElement.resourceResolvers.put(descriptor.getId(), descriptor);
        }
        List runtimeConfigElements = elem.elements("runtime-config");
        for (Element el : runtimeConfigElements) {
            RuntimeConfigDescriptor descriptor = new RuntimeConfigDescriptor(el);
            configElement.runtimeConfigs.put(descriptor.getId(), descriptor);
        }
        Element autowireConfigElement = elem.element("autowire");
        if (autowireConfigElement != null) {
            String _autowireRuntimeId;
            String _autowireModeId = autowireConfigElement.elementTextTrim("mode");
            if (_autowireModeId != null) {
                configElement.autowireModeId = _autowireModeId;
            }
            if ((_autowireRuntimeId = autowireConfigElement.elementTextTrim("runtime")) != null) {
                configElement.autowireRuntimeId = _autowireRuntimeId;
            }
        }
        if ((persisterConfigElement = elem.element("persisters")) != null) {
            configElement.persisterConfigDescriptor = new PersisterConfigDescriptor(persisterConfigElement);
        }
        return configElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuntimeConfigDescriptor
    extends Descriptor {
        private static final String ENDPOINT_ID = "endpoint";
        private static final String STORE_ID = "store";
        private static final String WEBAPP_ID = "webapp";
        private List<String> persisterIds = new ArrayList<String>(4);

        RuntimeConfigDescriptor(Element el) {
            super(el);
            Element persistersElement = el.element("persisters");
            if (persistersElement != null) {
                List persisterElements = persistersElement.elements("persister");
                for (Element persisterElement : persisterElements) {
                    String value = persisterElement.getTextTrim();
                    this.persisterIds.add(value);
                }
            }
        }

        public String getEndpointId() {
            return this.getStringProperty(ENDPOINT_ID);
        }

        public String getStoreId() {
            return this.getStringProperty(STORE_ID);
        }

        public String getWebappId() {
            return this.getStringProperty(WEBAPP_ID);
        }

        public List<String> getPersisterIds() {
            return this.persisterIds;
        }
    }

    public static class ResourceResolverDescriptor
    extends Descriptor {
        private static final String TYPE = "type";
        private static final String ENDPOINT = "endpoint";

        ResourceResolverDescriptor(Element el) {
            super(el);
        }

        public String getType() {
            return this.getStringProperty(TYPE);
        }

        public String getEndpoint() {
            return this.getStringProperty(ENDPOINT);
        }
    }

    public static class ResourceLoaderDescriptor
    extends Descriptor {
        private static final String ENDPOINT = "endpoint";
        private static final String TYPE = "type";

        ResourceLoaderDescriptor(Element el) {
            super(el);
        }

        public String getType() {
            return this.getStringProperty(TYPE);
        }

        public String getEndpoint() {
            return this.getStringProperty(ENDPOINT);
        }
    }

    public static class PersisterConfigDescriptor
    extends Descriptor {
        private static final String CACHE_ENABLED = "cache-enabled";
        private static final String CACHE_CHECK_DELAY = "cache-check-delay";

        PersisterConfigDescriptor(Element el) {
            super(el);
        }

        public Boolean getCacheEnabled() {
            Boolean enabled = null;
            String value = this.getStringProperty(CACHE_ENABLED);
            if (value != null && value.length() != 0) {
                enabled = Boolean.parseBoolean(value);
            }
            return enabled;
        }

        public Integer getCacheCheckDelay() {
            Integer value = null;
            String v = this.getStringProperty(CACHE_CHECK_DELAY);
            if (v != null && v.length() != 0) {
                value = Integer.valueOf(v);
            }
            return value;
        }

        public void setCacheEnabled(boolean cacheEnabled) {
            this.propertiesMap.put(CACHE_ENABLED, Boolean.toString(cacheEnabled));
        }

        public void setCacheCheckDelay(int cacheCheckDelay) {
            this.propertiesMap.put(CACHE_CHECK_DELAY, Integer.toString(cacheCheckDelay));
        }
    }

    public static class TypeDescriptor
    extends Descriptor {
        private static final String CLAZZ = "class";
        private static final String NAMESPACE = "namespace";
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";
        private static final String VERSION = "version";
        private static final String PERSISTER_ID = "persister-id";
        private boolean _useDefaultPersister = this.getPersisterId() == null;

        TypeDescriptor(Element el) {
            super(el);
        }

        public String getImplementationClass() {
            return this.getStringProperty(CLAZZ);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }

        public String getNamespace() {
            return this.getStringProperty(NAMESPACE);
        }

        public String getVersion() {
            return this.getStringProperty(VERSION);
        }

        public String getPersisterId() {
            return this.getStringProperty(PERSISTER_ID);
        }

        public void setPersisterId(String persisterId) {
            this.propertiesMap.put(PERSISTER_ID, persisterId);
        }

        public boolean useDefaultPerister() {
            return this._useDefaultPersister;
        }
    }

    public static class TagLibraryDescriptor
    extends Descriptor {
        private static final String NAMESPACE = "namespace";
        private static final String URI = "uri";

        TagLibraryDescriptor(Element el) {
            super(el);
        }

        public String getUri() {
            return this.getStringProperty(URI);
        }

        public String getNamespace() {
            return this.getStringProperty(NAMESPACE);
        }
    }

    public static class SystemPageDescriptor
    extends Descriptor {
        private static final String PROCESSOR_ID = "processor-id";
        private static final String JSP_PATH = "jsp-path";

        SystemPageDescriptor(Element el) {
            super(el);
        }

        public String getJspPath() {
            return this.getStringProperty(JSP_PATH);
        }

        public String getProcessorId() {
            return this.getStringProperty(PROCESSOR_ID);
        }
    }

    public static class ErrorHandlerDescriptor
    extends Descriptor {
        private static final String PROCESSOR_ID = "processor-id";
        private static final String JSP_PATH = "jsp-path";

        ErrorHandlerDescriptor(Element el) {
            super(el);
        }

        public String getJspPath() {
            return this.getStringProperty(JSP_PATH);
        }

        public String getProcessorId() {
            return this.getStringProperty(PROCESSOR_ID);
        }
    }

    public static class FormatDescriptor
    extends Descriptor {
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";

        FormatDescriptor(Element el) {
            super(el);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Descriptor {
        private static final String ID = "id";
        HashMap<String, String> propertiesMap;
        HashMap<String, String> attributesMap;

        Descriptor(Element el) {
            List elements = el.elements();
            for (Element element : elements) {
                this.put(element);
            }
            for (int i = 0; i < el.attributeCount(); ++i) {
                Attribute attribute;
                String value;
                if (this.attributesMap == null) {
                    this.attributesMap = new HashMap();
                }
                if ((value = (attribute = el.attribute(i)).getValue()) == null) continue;
                this.attributesMap.put(attribute.getName(), value);
            }
        }

        public void put(Element el) {
            if (this.propertiesMap == null) {
                this.propertiesMap = new HashMap();
            }
            String key = el.getName();
            String value = el.getTextTrim();
            if (value != null) {
                this.propertiesMap.put(key, value);
            }
        }

        public Object get(String key) {
            if (this.propertiesMap == null) {
                this.propertiesMap = new HashMap();
            }
            return this.propertiesMap.get(key);
        }

        public String getId() {
            return (String)this.get(ID);
        }

        public Object getProperty(String key) {
            return this.get(key);
        }

        public String getStringProperty(String key) {
            return (String)this.get(key);
        }

        public Map<String, String> map() {
            return this.propertiesMap;
        }

        public Object getAttribute(String key) {
            return this.attributesMap.get(key);
        }

        public String getStringAttribute(String key) {
            return (String)this.getAttribute(key);
        }

        public Map<String, String> attributes() {
            return this.attributesMap;
        }
    }
}

