/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.util.ArrayList;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkViewResolver;
import org.springframework.extensions.surf.mvc.ComponentView;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.uri.UriTemplateListIndex;
import org.springframework.extensions.webscripts.UriTemplate;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class ComponentViewResolver
extends AbstractWebFrameworkViewResolver {
    private static final String URI_PREFIX_COMPONENT_SHORT = "c/";
    private static final String URI_PREFIX_COMPONENT_FULL = "component/";

    public ComponentViewResolver() {
        ArrayList<UriTemplate> uriTemplates = new ArrayList<UriTemplate>();
        uriTemplates.add(new UriTemplate("/regionId/{regionId}"));
        uriTemplates.add(new UriTemplate("/scope/{scopeId}/regionId/{regionId}/sourceId/{sourceId}"));
        uriTemplates.add(new UriTemplate("/mode/{mode}/focus/{focus}/scope/{scopeId}/regionId/{regionId}/sourceId/{sourceId}"));
        uriTemplates.add(new UriTemplate("/focus/{focus}/scope/{scopeId}/regionId/{regionId}/sourceId/{sourceId}"));
        uriTemplates.add(new UriTemplate("/mode/{mode}/scope/{scopeId}/regionId/{regionId}/sourceId/{sourceId}"));
        this.setUriTemplateIndex(new UriTemplateListIndex(uriTemplates));
        this.addPrefix(URI_PREFIX_COMPONENT_SHORT);
        this.addPrefix(URI_PREFIX_COMPONENT_FULL);
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        ComponentView view = null;
        String uri = this.processView(viewName);
        if (uri != null) {
            view = new ComponentView(this.getWebframeworkConfigElement(), this.getModelObjectService(), this.getWebFrameworkResourceService(), this.getWebFrameworkRenderService(), this.getTemplatesContainer());
            view.setUrl(uri);
            view.setUriTokens(ThreadLocalRequestContext.getRequestContext().getUriTokens());
        }
        return view;
    }
}

