/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.mvc.UrlViewController;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;
import org.springframework.web.servlet.ModelAndView;

public class FeedController
extends UrlViewController {
    private static final String ENDPOINT_ALFRESCO_FEED = "alfresco-feed";
    protected ConnectorService connectorService;

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) {
        String authorization = req.getHeader("Authorization");
        if (authorization == null || authorization.length() == 0) {
            res.setStatus(401, "Requested endpoint requires authentication.");
            res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
            return null;
        }
        String[] authParts = authorization.split(" ");
        if (!authParts[0].equalsIgnoreCase("basic")) {
            throw new WebScriptsPlatformException("Authorization '" + authParts[0] + "' not supported.");
        }
        String[] values = new String(Base64.decode((String)authParts[1])).split(":");
        if (values.length == 2) {
            try {
                CredentialsImpl credentials = new CredentialsImpl(ENDPOINT_ALFRESCO_FEED);
                String username = values[0];
                credentials.setProperty("cleartextUsername", (Object)username);
                credentials.setProperty("cleartextPassword", (Object)values[1]);
                String guest = "guest";
                int suffix = username.indexOf(64);
                if (suffix != -1 && username.indexOf(46, suffix) == -1) {
                    guest = guest + username.substring(suffix);
                }
                CredentialVault vault = this.connectorService.getCredentialVault(req.getSession(), guest);
                vault.store((Credentials)credentials);
                req.getSession().setAttribute("_alf_USER_ID", (Object)guest);
                RequestContext context = ThreadLocalRequestContext.getRequestContext();
                context.getAttributes().put("alfUserEndpoint", (Serializable)((Object)ENDPOINT_ALFRESCO_FEED));
                res.setHeader("Cache-Control", "max-age=600, must-revalidate");
            }
            catch (Exception err) {
                throw new WebScriptsPlatformException("Failed to provision connector.", (Throwable)err);
            }
        } else {
            throw new WebScriptsPlatformException("Authorization request did not provide user/pass.");
        }
        return super.handleRequestInternal(req, res);
    }
}

