/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.ThreadLocalPreviewContext;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkInterceptor;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;

public class PreviewContextInterceptor
extends AbstractWebFrameworkInterceptor {
    private static Log logger = LogFactory.getLog(PreviewContextInterceptor.class);

    public void preHandle(WebRequest webRequest) throws Exception {
        if (this.getWebFrameworkConfiguration().isPreviewEnabled()) {
            WebFrameworkConfigElement.RuntimeConfigDescriptor runtimeConfigDescriptor;
            String runtimeId;
            String storeId = null;
            String webappId = null;
            HttpSession session = ServletUtil.getSession(false);
            if (session != null) {
                storeId = (String)session.getAttribute("alfStoreId");
                webappId = (String)session.getAttribute("alfWebappId");
            }
            if (storeId == null && (runtimeId = this.getWebFrameworkConfiguration().getAutowireRuntimeId()) != null && (runtimeConfigDescriptor = this.getWebFrameworkConfiguration().getRuntimeConfigDescriptor(runtimeId)) != null && (storeId = runtimeConfigDescriptor.getStoreId()) != null && storeId.length() > 0 && (webappId = runtimeConfigDescriptor.getWebappId()) != null && webappId.length() == 0) {
                webappId = null;
            }
            if (storeId != null) {
                ThreadLocalPreviewContext sandboxContext = new ThreadLocalPreviewContext(storeId, webappId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Context[" + session.getId() + "] storeId = " + sandboxContext.getPreviewContext().getStoreId()));
                    logger.debug((Object)("Context[" + session.getId() + "] webappId = " + sandboxContext.getPreviewContext().getWebappId()));
                }
            }
        }
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
        ThreadLocalPreviewContext sandboxContext;
        if (this.getWebFrameworkConfiguration().isPreviewEnabled() && (sandboxContext = ThreadLocalPreviewContext.getPreviewContext()) != null) {
            sandboxContext.release();
        }
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
    }
}

