/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.Theme;

public class ThemeImpl
extends AbstractModelObject
implements Theme {
    private static final long serialVersionUID = -5592730666596308335L;
    private static final String _PAGE_TYPES_ELEMENT = "page-types";
    private static final String _PAGE_TYPE_ELEMENT = "page-type";
    private static final String _ID_ELEMENT = "id";
    private static final String _PAGE_INSTANCE_ID_ELEMENT = "page-instance-id";
    private static final String _PAGE_ID_ELEMENT = "page-id";
    private static final String _DEFAULTS_ELEMENT = "defaults";
    private static final String _COMPONENT_ELEMENT = "component";
    private static final String _REGION_ID_ELEMENT = "region-id";
    private static final String _COMPONENT_ID_ELEMENT = "component-id";

    public ThemeImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
    }

    public String getTypeId() {
        return "theme";
    }

    public String getPageId(String pageTypeId) {
        String mappedPageId = null;
        Element pageTypesEl = this.document.getRootElement().element(_PAGE_TYPES_ELEMENT);
        if (pageTypesEl != null) {
            List pageTypes = pageTypesEl.elements(_PAGE_TYPE_ELEMENT);
            for (int i = 0; i < pageTypes.size(); ++i) {
                Element pageType = (Element)pageTypes.get(i);
                String id = pageType.elementText(_ID_ELEMENT);
                if (id == null || !id.equals(pageTypeId) || (mappedPageId = pageType.elementText(_PAGE_INSTANCE_ID_ELEMENT)) != null) continue;
                mappedPageId = pageType.elementText(_PAGE_ID_ELEMENT);
            }
        }
        return mappedPageId;
    }

    public void setDefaultPageId(String pageTypeId, String pageId) {
        Element pageTypesEl = this.document.getRootElement().element(_PAGE_TYPES_ELEMENT);
        if (pageTypesEl == null) {
            pageTypesEl = this.document.getRootElement().addElement(_PAGE_TYPES_ELEMENT);
        }
        Element theElement = null;
        List pageTypes = pageTypesEl.elements(_PAGE_TYPE_ELEMENT);
        for (int i = 0; i < pageTypes.size(); ++i) {
            Element pageType = (Element)pageTypes.get(i);
            String id = pageType.elementText(_ID_ELEMENT);
            if (id == null || !id.equals(pageTypeId)) continue;
            theElement = pageType;
        }
        if (theElement != null) {
            theElement = pageTypesEl.addElement(_PAGE_TYPE_ELEMENT);
        }
        Element idElement = theElement.addElement(_ID_ELEMENT);
        idElement.setText(pageTypeId);
        Element pageInstanceIdElement = theElement.addElement(_PAGE_INSTANCE_ID_ELEMENT);
        pageInstanceIdElement.setText(pageId);
    }

    public String getDefaultComponentId(String regionId) {
        String componentId = null;
        Element defaults = this.document.getRootElement().element(_DEFAULTS_ELEMENT);
        if (defaults != null) {
            List components = defaults.elements(_COMPONENT_ELEMENT);
            for (int i = 0; i < components.size(); ++i) {
                Element component = (Element)components.get(i);
                String _regionId = component.elementText(_REGION_ID_ELEMENT);
                if (_regionId == null || !_regionId.equals(regionId)) continue;
                componentId = component.elementText(_COMPONENT_ID_ELEMENT);
            }
        }
        return componentId;
    }

    public void removeDefaultComponentId(String regionId) {
        Element defaults = this.document.getRootElement().element(_DEFAULTS_ELEMENT);
        if (defaults != null) {
            Element toRemove = null;
            List components = defaults.elements(_COMPONENT_ELEMENT);
            for (int i = 0; i < components.size(); ++i) {
                Element component = (Element)components.get(i);
                String _regionId = component.elementText(_REGION_ID_ELEMENT);
                if (_regionId == null || !_regionId.equals(regionId)) continue;
                toRemove = component;
            }
            defaults.remove(toRemove);
        }
    }

    public void setDefaultComponentId(String regionId, String componentId) {
        this.removeDefaultComponentId(regionId);
        Element defaults = this.document.getRootElement().element(_DEFAULTS_ELEMENT);
        if (defaults == null) {
            defaults = this.document.getRootElement().addElement(_DEFAULTS_ELEMENT);
        }
        if (defaults != null) {
            Element component = defaults.addElement(_COMPONENT_ELEMENT);
            component.addElement(_REGION_ID_ELEMENT, regionId);
            component.addElement(_COMPONENT_ID_ELEMENT, componentId);
        }
    }

    public Component getDefaultComponent(RequestContext context, String regionId) {
        Component component = null;
        String id = this.getDefaultComponentId(regionId);
        if (id != null) {
            component = context.getObjectService().getComponent(id);
        }
        return component;
    }
}

