/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.uri;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriUtils {
    private static Log logger = LogFactory.getLog(UriUtils.class);

    private UriUtils() {
    }

    public static String replaceUriTokens(String s, Map<String, String> tokens) {
        String result = s;
        int preIndex = 0;
        int delimIndex = s.indexOf(123);
        if (delimIndex != -1) {
            StringBuilder buf = new StringBuilder(s.length() + 16);
            do {
                buf.append(s.substring(preIndex, delimIndex));
                if (s.length() < delimIndex + 2) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Failed to replace context tokens - malformed input: " + s));
                    }
                    return s;
                }
                int endDelimIndex = s.indexOf(125, delimIndex + 2);
                if (endDelimIndex == -1) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Failed to replace context tokens - malformed input: " + s));
                    }
                    return s;
                }
                String token = s.substring(delimIndex + 1, endDelimIndex);
                String replacement = tokens.get(token);
                buf.append(replacement != null ? replacement : "");
                preIndex = endDelimIndex + 1;
                delimIndex = s.indexOf(123, preIndex);
                if (delimIndex != -1 || s.length() <= preIndex) continue;
                buf.append(s.substring(preIndex));
            } while (delimIndex != -1);
            result = buf.toString();
        }
        return result;
    }
}

