/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.webscripts.AbstractStore;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileSystemStore
extends AbstractStore
implements ServletContextAware {
    private static Log logger = LogFactory.getLog(LocalFileSystemStore.class);
    private String root;
    private String path;
    private File rootDir;
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected File getRootDir() {
        if (this.rootDir == null) {
            this.rootDir = new File(this.getBasePath());
        }
        return this.rootDir;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void init() {
        if (this.path == null) {
            this.path = "";
        }
    }

    public boolean isSecure() {
        return false;
    }

    public boolean exists() {
        if (this.getRootDir() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Root directory for Store does not exist");
            }
            return false;
        }
        return this.getRootDir().exists();
    }

    public boolean hasDocument(String documentPath) {
        File file = new File(this.toAbsolutePath(documentPath));
        return file != null && file.exists() && file.isFile();
    }

    public long lastModified(String documentPath) throws IOException {
        File file = new File(this.toAbsolutePath(documentPath));
        if (file == null) {
            throw new IOException("Unable to locate file to check modification time: " + documentPath);
        }
        return file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(String documentPath, String content) throws IOException {
        File file = new File(this.toAbsolutePath(documentPath));
        if (file == null) {
            throw new IOException("Unable to locate file for update: " + documentPath);
        }
        FileWriter fw = new FileWriter(file);
        try {
            fw.write(content);
        }
        finally {
            fw.close();
        }
    }

    public boolean removeDocument(String documentPath) throws IOException {
        File file = new File(this.toAbsolutePath(documentPath));
        if (file == null) {
            throw new IOException("Update to remove document failed, file not found: " + documentPath);
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDocument(String documentPath, String content) throws IOException {
        if (this.hasDocument(documentPath)) {
            throw new IOException("Unable to create document, already exists: " + documentPath);
        }
        File file = new File(this.toAbsolutePath(documentPath));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileWriter fw = new FileWriter(file);
        try {
            fw.write(content);
        }
        finally {
            fw.close();
        }
    }

    public InputStream getDocument(String documentPath) throws IOException {
        File file = new File(this.toAbsolutePath(documentPath));
        if (file == null) {
            throw new IOException("Unable to get input stream from document: " + documentPath);
        }
        return new FileInputStream(file);
    }

    public String[] getAllDocumentPaths() {
        ArrayList<String> list = new ArrayList<String>(256);
        this.gatherAbsolutePaths(this.getRootDir().getAbsolutePath(), list);
        String[] array = list.toArray(new String[list.size()]);
        String absRootPath = this.getRootDir().getAbsolutePath() + File.separatorChar;
        int absRootPathLen = absRootPath.length();
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].substring(absRootPathLen);
            array[i] = array[i].replace("\\", "/");
        }
        return array;
    }

    public String[] getDocumentPaths(String path, boolean includedSubPaths, String documentPattern) {
        String regexPattern = documentPattern.replaceAll("\\*", ".*");
        if (!regexPattern.startsWith(".*")) {
            regexPattern = ".*" + regexPattern;
        }
        return this.getDocumentPathsByRegEx(path, regexPattern, includedSubPaths);
    }

    protected String[] getDocumentPathsByRegEx(String path, String regexPattern, boolean traverseChildren) {
        PatternFileFilter filter = new PatternFileFilter(regexPattern);
        String absParentPath = this.toAbsolutePath(path);
        int absParentPathLen = absParentPath.length() - 1;
        File f = new File(absParentPath);
        List<File> fileList = this.listPath(f, filter, traverseChildren);
        String[] paths = new String[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            String thePath = fileList.get(i).getPath();
            paths[i] = thePath.substring(absParentPathLen);
            paths[i] = paths[i].replace("\\", "/");
        }
        return paths;
    }

    public String[] getDescriptionDocumentPaths() {
        return this.getDocumentPathsByRegEx("/", ".*\\.desc\\.xml", true);
    }

    public String[] getScriptDocumentPaths(WebScript script) {
        String scriptPaths = script.getDescription().getId() + ".*";
        return this.getDocumentPathsByRegEx("/", scriptPaths, false);
    }

    public ScriptLoader getScriptLoader() {
        return new LocalFileSystemStoreScriptLoader();
    }

    public TemplateLoader getTemplateLoader() {
        return new LocalFileSystemStoreTemplateLoader();
    }

    public String getBasePath() {
        String fullPath = this.path;
        if (this.root != null) {
            if (!this.root.endsWith("/")) {
                this.root = this.root + "/";
            }
            fullPath = this.root.startsWith(".") ? this.getRealPath(this.root.substring(1)) + this.path : this.root + this.path;
        }
        return fullPath;
    }

    public String getRealPath(String path) {
        String realPath = this.servletContext.getRealPath(path);
        if (realPath != null && realPath.endsWith(File.separator)) {
            realPath = realPath.substring(0, realPath.length() - 1);
        }
        realPath = realPath.replace("/", File.separator);
        realPath = realPath.replace("\\", File.separator);
        return realPath;
    }

    protected String toAbsolutePath(String documentPath) {
        return this.getRootDir().getAbsolutePath() + File.separatorChar + documentPath;
    }

    protected void gatherAbsolutePaths(String absPath, List<String> list) {
        File file = new File(absPath);
        if (file.exists()) {
            if (file.isFile()) {
                list.add(absPath);
            } else if (file.isDirectory()) {
                String[] childDocumentPaths = file.list();
                for (int i = 0; i < childDocumentPaths.length; ++i) {
                    String childAbsPath = absPath + File.separatorChar + childDocumentPaths[i];
                    this.gatherAbsolutePaths(childAbsPath, list);
                }
            }
        }
    }

    private List<File> listPath(File path, FileFilter filter, boolean listChildren) {
        ArrayList<File> results = new ArrayList<File>();
        this.listPath(path, filter, results, listChildren);
        return results;
    }

    private void listPath(File path, FileFilter filter, List<File> results, boolean listChildren) {
        int i;
        Object[] files = path.listFiles(filter);
        if (files.length > 0) {
            Arrays.sort(files);
            for (i = 0; i < files.length; ++i) {
                results.add((File)files[i]);
            }
        }
        if (listChildren) {
            files = path.listFiles();
            for (i = 0; i < files.length; ++i) {
                if (!((File)files[i]).isDirectory()) continue;
                this.listPath((File)files[i], filter, results, listChildren);
            }
        }
    }

    public String toString() {
        return "localfilesystem:" + this.getBasePath();
    }

    private class PatternFileFilter
    implements FileFilter {
        Pattern pattern;

        public PatternFileFilter(String pat) {
            this.pattern = Pattern.compile(pat);
        }

        public boolean accept(File pathname) {
            boolean accept = false;
            if (pathname.isDirectory()) {
                accept = false;
            } else {
                String path = null;
                try {
                    path = pathname.toURL().toExternalForm();
                    if (path.endsWith("\\") || path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    accept = this.pattern.matcher(path).matches();
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
            }
            return accept;
        }
    }

    private class LocalFileSystemStoreScriptContent
    implements ScriptContent {
        private String scriptPath;

        private LocalFileSystemStoreScriptContent(String path) {
            this.scriptPath = path;
        }

        public String getPath() {
            return LocalFileSystemStore.this.getBasePath() + '/' + this.scriptPath;
        }

        public String getPathDescription() {
            return LocalFileSystemStore.this.getBasePath() + '/' + this.scriptPath;
        }

        public InputStream getInputStream() {
            FileInputStream is = null;
            try {
                File f = new File(LocalFileSystemStore.this.toAbsolutePath(this.scriptPath));
                if (f.exists()) {
                    is = new FileInputStream(f);
                }
            }
            catch (IOException e) {
                throw new PlatformRuntimeException("Unable to load script: " + this.scriptPath, (Throwable)e);
            }
            return is;
        }

        public Reader getReader() {
            FileReader reader = null;
            try {
                File f = new File(LocalFileSystemStore.this.toAbsolutePath(this.scriptPath));
                if (f.exists()) {
                    reader = new FileReader(f);
                }
            }
            catch (IOException e) {
                throw new PlatformRuntimeException("Unable to load script: " + this.scriptPath, (Throwable)e);
            }
            return reader;
        }

        public boolean isSecure() {
            return false;
        }

        public boolean isCachable() {
            return false;
        }
    }

    private class LocalFileSystemStoreTemplateSource {
        private String templatePath;

        private LocalFileSystemStoreTemplateSource(String path) {
            this.templatePath = path;
        }

        private long lastModified() {
            try {
                return LocalFileSystemStore.this.lastModified(this.templatePath);
            }
            catch (IOException e) {
                return -1L;
            }
        }

        private Reader getReader(String encoding) throws IOException {
            FileReader reader = null;
            File f = new File(LocalFileSystemStore.this.toAbsolutePath(this.templatePath));
            if (f.exists()) {
                reader = new FileReader(f);
            }
            return reader;
        }
    }

    private class LocalFileSystemStoreTemplateLoader
    implements TemplateLoader {
        private LocalFileSystemStoreTemplateLoader() {
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }

        public Object findTemplateSource(String name) throws IOException {
            LocalFileSystemStoreTemplateSource source = null;
            if (LocalFileSystemStore.this.hasDocument(name)) {
                source = new LocalFileSystemStoreTemplateSource(name);
            }
            return source;
        }

        public long getLastModified(Object templateSource) {
            return ((LocalFileSystemStoreTemplateSource)templateSource).lastModified();
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            return ((LocalFileSystemStoreTemplateSource)templateSource).getReader(encoding);
        }
    }

    protected class LocalFileSystemStoreScriptLoader
    implements ScriptLoader {
        protected LocalFileSystemStoreScriptLoader() {
        }

        public ScriptContent getScript(String path) {
            LocalFileSystemStoreScriptContent sc = null;
            if (LocalFileSystemStore.this.hasDocument(path)) {
                sc = new LocalFileSystemStoreScriptContent(path);
            }
            return sc;
        }
    }
}

