/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.fsr;

import java.io.File;
import org.alfresco.deployment.impl.fsr.FileSystemReceiverService;
import org.alfresco.deployment.impl.server.DeploymentCommandQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemReceiverServiceImpl
implements FileSystemReceiverService {
    private boolean errorOnOverwrite = false;
    private String fLogDirectory;
    private String fDataDirectory;
    private DeploymentCommandQueue commandQueue;
    private static Log logger = LogFactory.getLog(FileSystemReceiverServiceImpl.class);

    public void setLogDirectory(String logDirectory) {
        this.fLogDirectory = logDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.fDataDirectory = dataDirectory;
    }

    public void init() {
        File data;
        if (this.fLogDirectory == null) {
            throw new RuntimeException("mandatory parameter logDirectory is null");
        }
        if (this.fDataDirectory == null) {
            throw new RuntimeException("mandatory parameter dataDirectory is null");
        }
        File log = new File(this.fLogDirectory);
        if (!log.exists()) {
            logger.info((Object)("creating log data directory:" + log.toString()));
            log.mkdirs();
        }
        if (!(data = new File(this.fDataDirectory)).exists()) {
            logger.info((Object)("creating data directory:" + data.toString()));
            data.mkdirs();
        }
    }

    public String getLogDirectory() {
        return this.fLogDirectory;
    }

    public String getDataDirectory() {
        return this.fDataDirectory;
    }

    public void setErrorOnOverwrite(boolean errorOnOverwrite) {
        this.errorOnOverwrite = errorOnOverwrite;
    }

    public boolean isErrorOnOverwrite() {
        return this.errorOnOverwrite;
    }

    public void queueCommand(Runnable command) {
        this.commandQueue.queueCommand(command);
    }

    public Runnable pollCommand() {
        return this.commandQueue.pollCommand();
    }

    public void setCommandQueue(DeploymentCommandQueue commandQueue) {
        this.commandQueue = commandQueue;
    }

    public DeploymentCommandQueue getCommandQueue() {
        return this.commandQueue;
    }
}

