/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.util;

import java.io.File;

public class Path {
    private String[] fComponents;

    public Path(String path) {
        path = path.replaceAll("^(/|\\\\)+", "").replaceAll("(/|\\\\)+$", "");
        this.fComponents = path.split("(/|\\\\)+");
        if (this.fComponents.length == 1 && this.fComponents[0].equals("")) {
            this.fComponents = new String[0];
        }
    }

    public Path(String[] components) {
        this.fComponents = components;
    }

    public int size() {
        return this.fComponents.length;
    }

    public String get(int index) {
        return this.fComponents[index];
    }

    public Path getParent() {
        if (this.fComponents.length == 0) {
            return null;
        }
        String[] result = new String[this.fComponents.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.fComponents[i];
        }
        return new Path(result);
    }

    public String getBaseName() {
        return this.fComponents[this.fComponents.length - 1];
    }

    public Path extend(String name) {
        String[] result = new String[this.fComponents.length + 1];
        for (int i = 0; i < this.fComponents.length; ++i) {
            result[i] = this.fComponents[i];
        }
        result[this.fComponents.length] = name;
        return new Path(result);
    }

    public String toString() {
        if (this.fComponents.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.fComponents.length - 1; ++i) {
            builder.append(this.fComponents[i]);
            builder.append(File.separatorChar);
        }
        builder.append(this.fComponents[this.fComponents.length - 1]);
        return builder.toString();
    }
}

