/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.util.HashMap;
import java.util.List;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.config.DatasetSource;

public class DatasetFilter {
    private DatasetSource parentDatasetSource = null;
    private String name = null;
    private Type type = null;
    private String matchPattern = null;
    private String matchPatternTarget = null;
    private boolean applyToCollectionDatasets = false;
    private boolean applyToAtomicDatasets = true;
    private boolean rejectMatchingDatasets = false;
    private boolean isValid = true;
    private StringBuffer log = new StringBuffer();

    public DatasetFilter(DatasetSource parentDsSource, String name, Type type, String matchPattern) {
        if (type == null) {
            this.isValid = false;
            this.log.append(" ** DatasetFilter (1): invalid type for datasetFilter (" + name + ")");
        }
        this.parentDatasetSource = parentDsSource;
        this.name = name;
        this.type = type;
        this.matchPattern = matchPattern;
    }

    public DatasetFilter(DatasetSource parentDsSource, String name, Type type, String matchPattern, boolean applyToCollectionDatasets, boolean applyToAtomicDatasets, boolean rejectMatchingDatasets) {
        this(parentDsSource, name, type, matchPattern);
        this.applyToCollectionDatasets = applyToCollectionDatasets;
        this.applyToAtomicDatasets = applyToAtomicDatasets;
        this.rejectMatchingDatasets = rejectMatchingDatasets;
    }

    public DatasetSource getParentDatasetSource() {
        return this.parentDatasetSource;
    }

    public void setParentDatasetSource(DatasetSource parentDatasetSource) {
        this.parentDatasetSource = parentDatasetSource;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        if (this.getType() == null) {
            this.isValid = false;
            this.log.append(" ** DatasetFilter (2): null value for type is not valid.");
        }
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public void setMatchPattern(String newMatchPattern) {
        this.matchPattern = newMatchPattern;
    }

    public String getMatchPatternTarget() {
        return this.matchPatternTarget;
    }

    public void setMatchPatternTarget(String matchPatternTarget) {
        this.matchPatternTarget = matchPatternTarget;
    }

    public boolean isApplyToCollectionDatasets() {
        return this.applyToCollectionDatasets;
    }

    public void setApplyToCollectionDatasets(boolean applyToCollectionDatasets) {
        this.applyToCollectionDatasets = applyToCollectionDatasets;
    }

    public boolean isApplyToAtomicDatasets() {
        return this.applyToAtomicDatasets;
    }

    public void setApplyToAtomicDatasets(boolean applyToAtomicDatasets) {
        this.applyToAtomicDatasets = applyToAtomicDatasets;
    }

    public boolean isRejectMatchingDatasets() {
        return this.rejectMatchingDatasets;
    }

    public boolean isAcceptMatchingDatasets() {
        return !this.rejectMatchingDatasets;
    }

    public void setRejectMatchingDatasets(boolean rejectMatchingDatasets) {
        this.rejectMatchingDatasets = rejectMatchingDatasets;
    }

    boolean validate(StringBuilder out) {
        this.isValid = true;
        if (this.log.length() > 0) {
            out.append(this.log);
        }
        if (this.getName() == null) {
            this.isValid = false;
            out.append(" ** DatasetFilter (3): null value for name is not valid.");
        }
        if (this.getType() == null) {
            this.isValid = false;
            out.append(" ** DatasetFilter (4): null value for type is not valid (set with bad string?).");
        }
        if (this.type == Type.REGULAR_EXPRESSION && this.matchPattern == null) {
            this.isValid = false;
            out.append(" ** DatasetFilter (5): null value for matchPattern not valid when type is 'RegExp'.");
        }
        if (this.type != Type.REGULAR_EXPRESSION && this.type != null && this.matchPattern != null) {
            this.isValid = false;
            out.append(" ** DatasetFilter (6): matchPattern value (" + this.matchPattern + ") must be null if type is not 'RegExp'.");
        }
        return this.isValid;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("DatasetFilter[name:<" + this.getName() + "> type:<" + this.getType() + "> matchPattern:<" + this.getMatchPattern() + ">");
        return tmp.toString();
    }

    public boolean reject(InvDataset dataset) {
        if (this.isAcceptMatchingDatasets()) {
            throw new IllegalStateException("Accept filter <" + this.getName() + "> does not allow call to reject().");
        }
        return this.match(dataset);
    }

    public boolean accept(InvDataset dataset) {
        if (this.isRejectMatchingDatasets()) {
            throw new IllegalStateException("Reject filter <" + this.getName() + "> does not allow call to accept().");
        }
        return this.match(dataset);
    }

    protected boolean appliesToDataset(InvDataset dataset) {
        if (this.getParentDatasetSource().isCollection(dataset) && !this.applyToCollectionDatasets) {
            return false;
        }
        return this.getParentDatasetSource().isCollection(dataset) || this.applyToAtomicDatasets;
    }

    private boolean match(InvDataset dataset) {
        if (this.getParentDatasetSource().isCollection(dataset) && !this.applyToCollectionDatasets) {
            return false;
        }
        if (!this.getParentDatasetSource().isCollection(dataset) && !this.applyToAtomicDatasets) {
            return false;
        }
        if (this.matchPatternTarget == null) {
            if (this.getParentDatasetSource().isCollection(dataset)) {
                this.setMatchPatternTarget("name");
            } else {
                this.setMatchPatternTarget("urlPath");
            }
        }
        if (this.type == Type.REGULAR_EXPRESSION) {
            RE regExp = null;
            try {
                regExp = new RE((Object)this.matchPattern);
            }
            catch (REException e) {
                System.err.println("Error: exception on reg exp");
                System.err.println(e.getMessage());
                e.printStackTrace();
                return false;
            }
            REMatch regExpMatch = null;
            if (this.getMatchPatternTarget().equals("name")) {
                regExpMatch = regExp.getMatch((Object)dataset.getName());
            } else if (this.getMatchPatternTarget().equals("urlPath")) {
                regExpMatch = regExp.getMatch((Object)((InvDatasetImpl)dataset).getUrlPath());
            } else {
                return false;
            }
            return regExpMatch != null;
        }
        System.err.println("WARNING -- DatasetFilter.accept(): unsupported type <" + this.type.toString() + ">.");
        return false;
    }

    public static boolean acceptDatasetByFilterGroup(List filters, InvDataset dataset, boolean isCollectionDataset) {
        if (filters == null) {
            throw new NullPointerException("Given null list of filters.");
        }
        if (dataset == null) {
            throw new NullPointerException("Given null dataset.");
        }
        if (filters.isEmpty()) {
            return true;
        }
        boolean accept = false;
        boolean anyApplyToAtomic = false;
        boolean anyApplyToCollection = false;
        for (DatasetFilter curFilter : filters) {
            anyApplyToAtomic |= curFilter.isApplyToAtomicDatasets();
            anyApplyToCollection |= curFilter.isApplyToCollectionDatasets();
            if (curFilter.isAcceptMatchingDatasets()) {
                if (!curFilter.accept(dataset)) continue;
                accept = true;
                continue;
            }
            if (!curFilter.reject(dataset)) continue;
            return false;
        }
        if (accept) {
            return true;
        }
        return isCollectionDataset ? !anyApplyToCollection : !anyApplyToAtomic;
    }

    public static class Type {
        private static HashMap hash = new HashMap(20);
        public static final Type REGULAR_EXPRESSION = new Type("RegExp");
        private String name;

        private Type(String name) {
            this.name = name;
            hash.put(name, this);
        }

        public static Type getType(String name) {
            if (name == null) {
                return null;
            }
            return (Type)hash.get(name);
        }

        public String toString() {
            return this.name;
        }
    }
}

