/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.Misc;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateAxis1D
extends CoordinateAxis {
    private static Logger log = LoggerFactory.getLogger(CoordinateAxis1D.class);
    private boolean isRegular = false;
    private double start;
    private double increment;
    private boolean isLayer = false;
    private boolean wasCalc = false;
    private boolean isAscending;
    private boolean wasRead = false;
    private String[] names = null;
    private double[] midpoint;
    private double[] edge;
    private double[] bound1;
    private double[] bound2;

    public CoordinateAxis1D(NetcdfDataset ncd, VariableDS vds) {
        super(ncd, vds);
        this.setIsLayer();
    }

    CoordinateAxis1D(NetcdfDataset ncd, CoordinateAxis1D org) {
        super(ncd, org);
        this.orgName = org.orgName;
        this.cache = new Variable.Cache();
        this.setIsLayer();
    }

    public CoordinateAxis1D(NetcdfDataset ds, Group group, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, shortName, dataType, dims, units, desc);
        this.setIsLayer();
    }

    public CoordinateAxis1D section(Range r) throws InvalidRangeException {
        Section section = new Section().appendRange(r);
        return (CoordinateAxis1D)this.section(section);
    }

    @Override
    protected Variable copy() {
        return new CoordinateAxis1D(this.ncd, this);
    }

    @Override
    public CoordinateAxis copyNoCache() {
        CoordinateAxis1D axis = new CoordinateAxis1D(this.ncd, this.getParentGroup(), this.getShortName(), this.getDataType(), this.getDimensionsString(), this.getUnitsString(), this.getDescription());
        axis.cache = new Variable.Cache();
        return axis;
    }

    public String getCoordName(int index) {
        if (!this.wasRead) {
            this.doRead();
        }
        if (this.isNumeric()) {
            return Format.d(this.getCoordValue(index), 5, 8);
        }
        return this.names[index];
    }

    public double getCoordValue(int index) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return this.midpoint[index];
    }

    @Override
    public double getMinValue() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return Math.min(this.midpoint[0], this.midpoint[(int)this.getSize() - 1]);
    }

    @Override
    public double getMaxValue() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return Math.max(this.midpoint[0], this.midpoint[(int)this.getSize() - 1]);
    }

    public double getCoordEdge(int index) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordEdge() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return this.edge[index];
    }

    public double[] getCoordValues() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValues() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return (double[])this.midpoint.clone();
    }

    public double[] getCoordEdges() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordEdges() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return (double[])this.edge.clone();
    }

    public double[] getBound1() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getBound1() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return (double[])this.bound1.clone();
    }

    public double[] getBound2() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getBound2() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return (double[])this.bound2.clone();
    }

    public double[] getCoordEdges(int i) {
        if (!this.wasRead) {
            this.doRead();
        }
        double[] e = new double[2];
        if (this.isContiguous()) {
            e[0] = this.getCoordEdge(i);
            e[1] = this.getCoordEdge(i + 1);
        } else {
            e[0] = this.bound1[i];
            e[1] = this.bound2[i];
        }
        return e;
    }

    public int findCoordElement(double coordVal) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis.findCoordElement() on non-numeric");
        }
        if (this.isRegular()) {
            return this.findCoordElementRegular(coordVal, false);
        }
        if (this.isContiguous()) {
            return this.findCoordElementIrregular(coordVal, false);
        }
        return this.findCoordElement(coordVal, -1);
    }

    public int findCoordElement(double coordVal, int lastIndex) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis.findCoordElement() on non-numeric");
        }
        if (this.axisType == AxisType.Lon) {
            int x = 0;
            while ((long)x < this.getSize()) {
                if (this.betweenLon(coordVal, this.getCoordEdge(x), this.getCoordEdge(x + 1))) {
                    return x;
                }
                ++x;
            }
            return -1;
        }
        if (lastIndex < 0) {
            lastIndex = (int)this.getSize() / 2;
        }
        if (this.isAscending) {
            if (coordVal < this.getCoordEdge(0) || coordVal > this.getCoordEdge((int)this.getSize())) {
                return -1;
            }
            while (coordVal < this.getCoordEdge(lastIndex)) {
                --lastIndex;
            }
            while (coordVal > this.getCoordEdge(lastIndex + 1)) {
                ++lastIndex;
            }
            return lastIndex;
        }
        if (coordVal > this.getCoordEdge(0) || coordVal < this.getCoordEdge((int)this.getSize())) {
            return -1;
        }
        while (coordVal > this.getCoordEdge(lastIndex)) {
            --lastIndex;
        }
        while (coordVal < this.getCoordEdge(lastIndex + 1)) {
            ++lastIndex;
        }
        return lastIndex;
    }

    private boolean betweenLon(double lon, double lonBeg, double lonEnd) {
        while (lon < lonBeg) {
            lon += 360.0;
        }
        return lon >= lonBeg && lon <= lonEnd;
    }

    public int findCoordElementBounded(double coordVal) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis.findCoordElement() on non-numeric");
        }
        if (this.isRegular()) {
            return this.findCoordElementRegular(coordVal, true);
        }
        if (this.isContiguous()) {
            return this.findCoordElementIrregular(coordVal, true);
        }
        return this.findCoordElementBounded(coordVal, -1);
    }

    private int findCoordElementBounded(double pos, int lastIndex) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis.findCoordElement() on non-numeric");
        }
        if (this.axisType == AxisType.Lon) {
            int x = 0;
            while ((long)x < this.getSize()) {
                if (this.betweenLon(pos, this.getCoordEdge(x), this.getCoordEdge(x + 1))) {
                    return x;
                }
                ++x;
            }
            return pos <= this.getCoordEdge(0) ? 0 : (int)this.getSize() - 1;
        }
        if (lastIndex < 0) {
            lastIndex = (int)this.getSize() / 2;
        }
        int n = (int)this.getSize();
        if (this.isAscending) {
            if (pos < this.getCoordEdge(0)) {
                return 0;
            }
            if (pos > this.getCoordEdge(n)) {
                return n - 1;
            }
            while (pos < this.getCoordEdge(lastIndex)) {
                --lastIndex;
            }
            while (pos > this.getCoordEdge(lastIndex + 1)) {
                ++lastIndex;
            }
            return lastIndex;
        }
        if (pos > this.getCoordEdge(0)) {
            return 0;
        }
        if (pos < this.getCoordEdge(n)) {
            return n - 1;
        }
        while (pos > this.getCoordEdge(lastIndex)) {
            --lastIndex;
        }
        while (pos < this.getCoordEdge(lastIndex + 1)) {
            ++lastIndex;
        }
        return lastIndex;
    }

    private int findCoordElementRegular(double coordValue, boolean bounded) {
        int n = (int)this.getSize();
        if (this.axisType == AxisType.Lon) {
            double maxValue = this.start + this.increment * (double)n;
            if (this.betweenLon(coordValue, this.start, maxValue)) {
                double distance = LatLonPointImpl.getClockwiseDistanceTo(this.start, coordValue);
                double exactNumSteps = distance / this.increment;
                return (int)Math.round(exactNumSteps) % (int)this.getSize();
            }
            if (coordValue < this.start) {
                return bounded ? 0 : -1;
            }
            return bounded ? n - 1 : -1;
        }
        double distance = coordValue - this.start;
        double exactNumSteps = distance / this.increment;
        int index = (int)Math.round(exactNumSteps);
        if (index < 0) {
            return bounded ? 0 : -1;
        }
        if (index >= n) {
            return bounded ? n - 1 : -1;
        }
        return index;
    }

    private int findCoordElementIrregular(double target, boolean bounded) {
        if (!this.wasRead) {
            this.doRead();
        }
        int n = (int)this.getSize();
        int low = 0;
        int high = n;
        if (this.axisType == AxisType.Lon) {
            if (target < this.edge[low]) {
                if ((target += 360.0) > this.edge[high]) {
                    return bounded ? 0 : -1;
                }
            } else if (target > this.edge[high] && (target -= 360.0) < this.edge[low]) {
                return bounded ? n - 1 : -1;
            }
        }
        if (this.isAscending) {
            if (target < this.edge[low]) {
                return bounded ? 0 : -1;
            }
            if (target > this.edge[high]) {
                return bounded ? n - 1 : -1;
            }
            int mid = low;
            while (high > low + 1) {
                mid = (low + high) / 2;
                double midVal = this.edge[mid];
                if (midVal == target) {
                    return mid;
                }
                if (midVal < target) {
                    low = mid;
                    continue;
                }
                high = mid;
            }
            return low;
        }
        if (target > this.edge[low]) {
            return bounded ? 0 : -1;
        }
        if (target < this.edge[high]) {
            return bounded ? n - 1 : -1;
        }
        int mid = low;
        while (high > low + 1) {
            mid = (low + high) / 2;
            double midVal = this.edge[mid];
            if (midVal == target) {
                return mid;
            }
            if (midVal < target) {
                high = mid;
                continue;
            }
            low = mid;
        }
        return high - 1;
    }

    public double getStart() {
        this.calcIsRegular();
        return this.start;
    }

    public double getIncrement() {
        this.calcIsRegular();
        return this.increment;
    }

    public boolean isLayer() {
        return this.isLayer;
    }

    public void setLayer(boolean isLayer) {
        this.isLayer = isLayer;
    }

    private void setIsLayer() {
        Attribute att = this.findAttribute("_CoordinateZisLayer");
        if (att != null && att.getStringValue().equalsIgnoreCase("true")) {
            this.isLayer = true;
        }
    }

    public boolean isRegular() {
        this.calcIsRegular();
        return this.isRegular;
    }

    private void calcIsRegular() {
        if (this.wasCalc) {
            return;
        }
        if (!this.wasRead) {
            this.doRead();
        }
        if (!this.isNumeric()) {
            this.isRegular = false;
        } else if (this.getSize() < 2L) {
            this.isRegular = true;
        } else {
            this.start = this.getCoordValue(0);
            int n = (int)this.getSize();
            this.increment = (this.getCoordValue(n - 1) - this.getCoordValue(0)) / (double)(n - 1);
            this.isRegular = true;
            int i = 1;
            while ((long)i < this.getSize()) {
                if (!Misc.closeEnough(this.getCoordValue(i) - this.getCoordValue(i - 1), this.increment, 0.005)) {
                    this.isRegular = false;
                    break;
                }
                ++i;
            }
        }
        this.wasCalc = true;
    }

    private void doRead() {
        if (this.isNumeric()) {
            this.readValues();
            this.wasRead = true;
            this.isAscending = this.getSize() < 2L ? true : this.getCoordValue(0) < this.getCoordValue(1);
        } else if (this.getDataType() == DataType.STRING) {
            this.readStringValues();
            this.wasRead = true;
        } else {
            this.readCharValues();
            this.wasRead = true;
        }
    }

    private void readStringValues() {
        Array data;
        int count = 0;
        try {
            data = this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading string coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        this.names = new String[(int)data.getSize()];
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            this.names[count++] = (String)ii.getObjectNext();
        }
    }

    private void readCharValues() {
        ArrayChar data;
        int count = 0;
        try {
            data = (ArrayChar)this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading char coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        ArrayChar.StringIterator iter = data.getStringIterator();
        this.names = new String[iter.getNumElems()];
        while (iter.hasNext()) {
            this.names[count++] = iter.next();
        }
    }

    private void readValues() {
        Array data;
        this.midpoint = new double[(int)this.getSize()];
        int count = 0;
        try {
            this.setUseNaNs(false);
            data = this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        IndexIterator iter = data.getIndexIterator();
        while (iter.hasNext()) {
            this.midpoint[count++] = iter.getDoubleNext();
        }
        if (!this.makeBoundsFromAux()) {
            this.makeEdges();
            this.makeBoundsFromEdges();
        }
    }

    private boolean makeBoundsFromAux() {
        int i;
        boolean firstLower;
        Array data;
        Attribute boundsAtt = this.findAttributeIgnoreCase("bounds");
        if (null == boundsAtt || !boundsAtt.isString()) {
            return false;
        }
        String boundsVarName = boundsAtt.getStringValue();
        VariableDS boundsVar = (VariableDS)this.ncd.findVariable(boundsVarName);
        if (null == boundsVar) {
            return false;
        }
        if (2 != boundsVar.getRank()) {
            return false;
        }
        if (this.getDimension(0) != boundsVar.getDimension(0)) {
            return false;
        }
        if (2 != boundsVar.getDimension(1).getLength()) {
            return false;
        }
        try {
            boundsVar.setUseNaNs(false);
            data = boundsVar.read();
        }
        catch (IOException e) {
            log.warn("CoordinateAxis1D.hasBounds read failed ", (Throwable)e);
            return false;
        }
        int n = this.shape[0];
        double[] value1 = new double[n];
        double[] value2 = new double[n];
        Index ima = data.getIndex();
        for (int i2 = 0; i2 < n; ++i2) {
            ima.set0(i2);
            value1[i2] = data.getDouble(ima.set1(0));
            value2[i2] = data.getDouble(ima.set1(1));
        }
        boolean goesUp = n < 2 || value1[1] > value1[0];
        boolean bl = firstLower = value1[0] < value2[0];
        if (goesUp != firstLower) {
            double[] temp = value1;
            value1 = value2;
            value2 = temp;
        }
        boolean contig = true;
        for (i = 0; i < n - 1; ++i) {
            if (Misc.closeEnough(value1[i + 1], value2[i])) continue;
            contig = false;
        }
        if (contig) {
            this.edge = new double[n + 1];
            this.edge[0] = value1[0];
            for (i = 1; i < n + 1; ++i) {
                this.edge[i] = value2[i - 1];
            }
        } else {
            this.edge = new double[n + 1];
            this.edge[0] = value1[0];
            for (i = 1; i < n; ++i) {
                this.edge[i] = (value1[i] + value2[i - 1]) / 2.0;
            }
            this.edge[n] = value2[n - 1];
            this.setContiguous(false);
        }
        this.bound1 = value1;
        this.bound2 = value2;
        return true;
    }

    private void makeEdges() {
        int size = (int)this.getSize();
        this.edge = new double[size + 1];
        if (size < 1) {
            return;
        }
        for (int i = 1; i < size; ++i) {
            this.edge[i] = (this.midpoint[i - 1] + this.midpoint[i]) / 2.0;
        }
        this.edge[0] = this.midpoint[0] - (this.edge[1] - this.midpoint[0]);
        this.edge[size] = this.midpoint[size - 1] + (this.midpoint[size - 1] - this.edge[size - 1]);
    }

    private void makeMidpoints() {
        int size = (int)this.getSize();
        this.midpoint = new double[size];
        for (int i = 0; i < size; ++i) {
            this.midpoint[i] = (this.edge[i] + this.edge[i + 1]) / 2.0;
        }
    }

    private void makeBoundsFromEdges() {
        int size = (int)this.getSize();
        if (size == 0) {
            return;
        }
        this.bound1 = new double[size];
        this.bound2 = new double[size];
        for (int i = 0; i < size; ++i) {
            this.bound1[i] = this.edge[i];
            this.bound2[i] = this.edge[i + 1];
        }
        if (this.bound1[0] > this.bound2[0]) {
            double[] temp = this.bound1;
            this.bound1 = this.bound2;
            this.bound2 = temp;
        }
    }

    public List<NamedObject> getNames() {
        int n = (int)this.getSize();
        ArrayList<NamedObject> names = new ArrayList<NamedObject>(n);
        for (int i = 0; i < n; ++i) {
            names.add(new NamedAnything(this.getCoordName(i), this.getUnitsString()));
        }
        return names;
    }

    protected static class NamedAnything
    implements NamedObject {
        private String name;
        private String desc;

        NamedAnything(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return this.name;
        }
    }
}

