/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.TrajectoryFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class StandardTrajectoryCollectionImpl
extends OneNestedPointCollectionImpl
implements TrajectoryFeatureCollection {
    private DateUnit timeUnit;
    private NestedTable ft;
    private TrajIterator localIterator = null;

    protected StandardTrajectoryCollectionImpl(String name) {
        super(name, FeatureType.TRAJECTORY);
    }

    StandardTrajectoryCollectionImpl(NestedTable ft, DateUnit timeUnit) {
        super(ft.getName(), FeatureType.TRAJECTORY);
        this.ft = ft;
        this.timeUnit = timeUnit;
    }

    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new TrajIterator(this.ft.getFeatureDataIterator(bufferSize));
    }

    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    public TrajectoryFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return new StandardTrajectoryCollectionSubset(this, boundingBox);
    }

    public TrajectoryFeature next() throws IOException {
        return this.localIterator.next();
    }

    public void resetIteration() throws IOException {
        this.localIterator = (TrajIterator)this.getPointFeatureCollectionIterator(-1);
    }

    private class StandardTrajectoryCollectionSubset
    extends StandardTrajectoryCollectionImpl {
        TrajectoryFeatureCollection from;
        LatLonRect boundingBox;

        StandardTrajectoryCollectionSubset(TrajectoryFeatureCollection from, LatLonRect boundingBox) {
            super(from.getName() + "-subset");
            this.from = from;
            this.boundingBox = boundingBox;
        }

        public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(bufferSize), new Filter());
        }

        private class Filter
        implements PointFeatureCollectionIterator.Filter {
            private Filter() {
            }

            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                ProfileFeature profileFeature = (ProfileFeature)pointFeatureCollection;
                return StandardTrajectoryCollectionSubset.this.boundingBox.contains(profileFeature.getLatLon());
            }
        }
    }

    private class StandardTrajectoryFeature
    extends TrajectoryFeatureImpl {
        StructureData trajData;
        int recno;

        StandardTrajectoryFeature(StructureData trajData, int recno) {
            super(StandardTrajectoryCollectionImpl.this.ft.getFeatureName(trajData), -1);
            this.trajData = trajData;
            this.recno = recno;
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursor = new Cursor(StandardTrajectoryCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[1] = this.recno;
            cursor.tableData[1] = this.trajData;
            cursor.parentIndex = 1;
            StructureDataIterator siter = StandardTrajectoryCollectionImpl.this.ft.getFeatureObsDataIterator(cursor, bufferSize);
            return new StandardPointFeatureIterator(StandardTrajectoryCollectionImpl.this.ft, StandardTrajectoryCollectionImpl.this.timeUnit, siter, cursor, false);
        }
    }

    private class TrajIterator
    implements PointFeatureCollectionIterator {
        StructureDataIterator structIter;
        int count = 0;

        TrajIterator(StructureDataIterator structIter) throws IOException {
            this.structIter = structIter;
        }

        public boolean hasNext() throws IOException {
            return this.structIter.hasNext();
        }

        public TrajectoryFeature next() throws IOException {
            return new StandardTrajectoryFeature(this.structIter.next(), this.count++);
        }

        public void setBufferSize(int bytes) {
        }
    }
}

