/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayLong;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.bufr.BitCounterCompressed;
import ucar.nc2.iosp.bufr.BitCounterUncompressed;
import ucar.nc2.iosp.bufr.BitReader;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.ConstructNC;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufrIosp
extends AbstractIOServiceProvider {
    private static Logger log = LoggerFactory.getLogger(BufrIosp.class);
    static final String obsRecord = "obsRecord";
    static final String obsIndex = "obsRecordIndex";
    private static boolean debugSize = false;
    private static boolean debugOpen = false;
    private Formatter parseInfo;
    private ConstructNC construct;
    private Message protoMessage;
    private List<Message> msgs = new ArrayList<Message>();
    private int[] obsStart;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugOpen = debugFlag.isSet("Bufr/open");
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return MessageScanner.isValidFile(raf);
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        long start = System.nanoTime();
        if (debugOpen) {
            this.parseInfo = new Formatter();
            this.parseInfo.format("\nOpen %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        }
        this.raf = raf;
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            if (this.protoMessage == null) {
                this.protoMessage = m;
                this.protoMessage.getRootDataDescriptor();
                if (!this.protoMessage.isTablesComplete()) {
                    throw new IllegalStateException("BUFR file has incomplete tables");
                }
            } else if (!this.protoMessage.equals(m)) {
                log.warn("File " + ncfile.getLocation() + " has different BUFR message types msgno=" + count + "; skipping");
                continue;
            }
            this.msgs.add(m);
            ++count;
        }
        this.obsStart = new int[this.msgs.size()];
        int mi = 0;
        int countObs = 0;
        for (Message m : this.msgs) {
            this.obsStart[mi++] = countObs;
            countObs += m.getNumberDatasets();
        }
        if (debugOpen) {
            long took = (System.nanoTime() - start) / 1000000L;
            double rate = took > 0L ? (double)count / (double)took : 0.0;
            this.parseInfo.format("nmsgs= %d nobs = %d took %d msecs rate = %f msgs/msec\n", count, scan.getTotalObs(), took, rate);
        }
        this.construct = new ConstructNC(this.protoMessage, countObs, ncfile);
        ncfile.finish();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Structure s = (Structure)v2;
        if (v2.getName().equals(obsIndex)) {
            return this.readIndex(s, section);
        }
        StructureMembers members = s.makeStructureMembers();
        ArrayStructureBB.setOffsets(members);
        ArrayStructureBB abb = new ArrayStructureBB(members, section.getShape());
        ByteBuffer bb = abb.getByteBuffer();
        bb.order(ByteOrder.BIG_ENDIAN);
        MsgFinder msgf = new MsgFinder();
        Message current = null;
        List<MemberDD> m2dd = null;
        Range range = section.getRange(0);
        for (int obsIndex = range.first(); obsIndex <= range.last(); obsIndex += range.stride()) {
            Message msg = msgf.find(obsIndex);
            if (msg == null) {
                log.error("MsgFinder failed on index " + obsIndex);
                throw new IllegalStateException("MsgFinder failed on index " + obsIndex);
            }
            if (msg != current) {
                DataDescriptor.transferInfo(this.protoMessage.getRootDataDescriptor().getSubKeys(), msg.getRootDataDescriptor().getSubKeys());
                m2dd = this.associateMessage2Members(msg.getRootDataDescriptor().getSubKeys(), members);
                current = msg;
            }
            this.readOneObs(msg, msgf.obsOffsetInMessage(obsIndex), abb, bb, m2dd);
        }
        return abb;
    }

    List<MemberDD> associateMessage2Members(List<DataDescriptor> dkeys, StructureMembers members) throws IOException {
        ArrayList<MemberDD> result = new ArrayList<MemberDD>(members.getMembers().size());
        int bitOffset = 0;
        for (DataDescriptor dkey : dkeys) {
            StructureMembers.Member m = members.findMember(dkey.name);
            if (m != null) {
                MemberDD mdd = new MemberDD(m, dkey, bitOffset);
                result.add(mdd);
                if (dkey.getSubKeys() != null) {
                    mdd.nested = this.associateMessage2Members(dkey.getSubKeys(), m.getStructureMembers());
                }
            }
            bitOffset += dkey.getBitWidth();
        }
        return result;
    }

    private void readOneObs(Message m, int obsOffsetInMessage, ArrayStructureBB abb, ByteBuffer bb, List<MemberDD> m2dd) throws IOException {
        BitCounterCompressed[] bitCounter;
        if (this.construct.hasTime) {
            bb.putInt(0);
        }
        BitReader reader = new BitReader(this.raf, m.dataSection.getDataPos() + 4L);
        if (m.dds.isCompressed()) {
            bitCounter = m.getCounterFlds();
            this.readDataCompressed(reader, m.getRootDataDescriptor(), obsOffsetInMessage, bitCounter, bb);
        } else {
            bitCounter = m.getBitCounterUncompressed(obsOffsetInMessage);
            this.readDataUncompressed(reader, (BitCounterUncompressed)bitCounter, 0, m2dd, abb, bb);
        }
        if (this.construct.hasTime) {
            double val = this.construct.makeObsTimeValue(abb);
            bb.putInt(0, (int)val);
        }
    }

    private void readDataUncompressed(BitReader reader, BitCounterUncompressed bitCounter, int row, List<MemberDD> m2dd, ArrayStructureBB abb, ByteBuffer bb) throws IOException {
        for (MemberDD mdd : m2dd) {
            DataDescriptor dkey = mdd.dd;
            reader.setBitOffset(bitCounter.getStartBit(row) + mdd.bitOffset);
            if (dkey.replication == 0) {
                BitCounterUncompressed[] bitCounterNestedArray = bitCounter.getNested(dkey);
                if (bitCounterNestedArray == null) {
                    throw new IllegalStateException("No nested BitCounterUncompressed for " + dkey.name);
                }
                if (row >= bitCounterNestedArray.length) {
                    throw new IllegalStateException("No BitCounterUncompressed for " + dkey.name + " row= " + row);
                }
                BitCounterUncompressed bcn = bitCounterNestedArray[row];
                ArraySequence seq = this.makeArraySequence(reader, bcn, mdd);
                int index = abb.addObjectToHeap(seq);
                bb.putInt(index);
                continue;
            }
            if (dkey.type == 3) {
                BitCounterUncompressed[] bitCounterNested = bitCounter.getNested(dkey);
                if (bitCounterNested == null) {
                    throw new IllegalStateException("No nested BitCounterUncompressed for " + dkey.name);
                }
                for (int i = 0; i < dkey.replication; ++i) {
                    this.readDataUncompressed(reader, bitCounterNested[row], i, mdd.nested, abb, bb);
                }
                continue;
            }
            if (dkey.type == 1) {
                for (int i = 0; i < dkey.getByteWidthCDM(); ++i) {
                    bb.put((byte)reader.bits2UInt(8));
                }
                continue;
            }
            int result = reader.bits2UInt(dkey.bitWidth);
            if (dkey.getByteWidthCDM() == 1) {
                bb.put((byte)result);
                continue;
            }
            if (dkey.getByteWidthCDM() == 2) {
                int b1 = result & 0xFF;
                int b2 = (result & 0xFF00) >> 8;
                bb.put((byte)b2);
                bb.put((byte)b1);
                continue;
            }
            int b1 = result & 0xFF;
            int b2 = (result & 0xFF00) >> 8;
            int b3 = (result & 0xFF0000) >> 16;
            int b4 = (result & 0xFF000000) >> 24;
            bb.put((byte)b4);
            bb.put((byte)b3);
            bb.put((byte)b2);
            bb.put((byte)b1);
        }
    }

    private void readDataCompressed(BitReader reader, DataDescriptor parent, int msgOffset, BitCounterCompressed[] counters, ByteBuffer bb) throws IOException {
        for (int fldidx = 0; fldidx < parent.getSubKeys().size(); ++fldidx) {
            int b2;
            int b1;
            int missingVal;
            DataDescriptor dkey = parent.getSubKeys().get(fldidx);
            if (!dkey.isOkForVariable()) continue;
            BitCounterCompressed counter = counters[fldidx];
            if (dkey.replication == 0) continue;
            if (dkey.type == 3) {
                for (int i = 0; i < dkey.replication; ++i) {
                    BitCounterCompressed[] nested = counter.getNestedCounters(i);
                    this.readDataCompressed(reader, dkey, msgOffset, nested, bb);
                }
                continue;
            }
            reader.setBitOffset(counter.getStartingBitPos());
            if (dkey.type == 1) {
                int i;
                int n = dkey.bitWidth / 8;
                byte[] minValue = new byte[n];
                for (int i2 = 0; i2 < n; ++i2) {
                    minValue[i2] = (byte)reader.bits2UInt(8);
                }
                int dataWidth = reader.bits2UInt(6);
                if (dataWidth == 0) {
                    for (int i3 = 0; i3 < n; ++i3) {
                        bb.put(minValue[i3]);
                    }
                    continue;
                }
                reader.setBitOffset(counter.getBitPos(msgOffset));
                int nt = Math.min(n, dataWidth);
                for (i = 0; i < nt; ++i) {
                    int cval = reader.bits2UInt(8);
                    if (cval < 32 || cval > 126) {
                        cval = 0;
                    }
                    bb.put((byte)cval);
                }
                for (i = nt; i < n; ++i) {
                    bb.put((byte)0);
                }
                continue;
            }
            int value = reader.bits2UInt(dkey.bitWidth);
            int dataWidth = reader.bits2UInt(6);
            if (dataWidth > 0) {
                reader.setBitOffset(counter.getBitPos(msgOffset));
                int cv = reader.bits2UInt(dataWidth);
                value = cv == BufrNumbers.missing_value[dataWidth] ? BufrNumbers.missing_value[dkey.bitWidth] : (value += cv);
            }
            if (dataWidth > dkey.bitWidth && (value & (missingVal = BufrNumbers.missing_value[dkey.bitWidth])) != value) {
                value = missingVal;
            }
            if (dkey.getByteWidthCDM() == 1) {
                bb.put((byte)value);
                continue;
            }
            if (dkey.getByteWidthCDM() == 2) {
                b1 = value & 0xFF;
                b2 = (value & 0xFF00) >> 8;
                bb.put((byte)b2);
                bb.put((byte)b1);
                continue;
            }
            b1 = value & 0xFF;
            b2 = (value & 0xFF00) >> 8;
            int b3 = (value & 0xFF0000) >> 16;
            int b4 = (value & 0xFF000000) >> 24;
            bb.put((byte)b4);
            bb.put((byte)b3);
            bb.put((byte)b2);
            bb.put((byte)b1);
        }
    }

    private Array readIndex(Structure s, Section section) {
        int[] shape = section.getShape();
        StructureMembers members = s.makeStructureMembers();
        ArrayStructureMA ama = new ArrayStructureMA(members, shape);
        ArrayLong.D1 timeArray = new ArrayLong.D1(shape[0]);
        ArrayObject.D1 nameArray = new ArrayObject.D1(String.class, shape[0]);
        for (StructureMembers.Member m : members.getMembers()) {
            if (m.getName().equals("time")) {
                m.setDataArray(timeArray);
                continue;
            }
            m.setDataArray(nameArray);
        }
        return ama;
    }

    private ArraySequence makeArraySequence(BitReader reader, BitCounterUncompressed bitCounterNested, MemberDD mdd) throws IOException {
        DataDescriptor seqdd = mdd.dd;
        Sequence s = (Sequence)seqdd.refersTo;
        assert (s != null);
        int count = bitCounterNested.getNumberRows();
        int[] shape = new int[]{count};
        int offset = 0;
        StructureMembers members = s.makeStructureMembers();
        for (StructureMembers.Member m : members.getMembers()) {
            m.setDataParam(offset);
            Variable mv = s.findVariable(m.getName());
            if (mv == null) {
                System.out.println("HEY");
            }
            DataDescriptor dk = (DataDescriptor)mv.getSPobject();
            if (dk.replication == 0) {
                offset += 4;
                continue;
            }
            offset += dk.getByteWidthCDM();
        }
        ArrayStructureBB abb = new ArrayStructureBB(members, shape);
        ByteBuffer bb = abb.getByteBuffer();
        bb.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < count; ++i) {
            this.readDataUncompressed(reader, bitCounterNested, i, mdd.nested, abb, bb);
        }
        return new ArraySequence(members, new SequenceIterator(count, abb), count);
    }

    private Structure find(List<Variable> vars) {
        for (Variable v : vars) {
            Structure s;
            if (v instanceof Sequence) {
                return (Structure)v;
            }
            if (!(v instanceof Structure) || (s = this.find(((Structure)v).getVariables())) == null) continue;
            return s;
        }
        return null;
    }

    @Override
    public String getDetailInfo() {
        Formatter ff = new Formatter();
        try {
            this.protoMessage.dump(ff);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.parseInfo != null) {
            ff.format("%s", this.parseInfo.toString());
        }
        return ff.toString();
    }

    private class SequenceIterator
    implements StructureDataIterator {
        int count;
        ArrayStructure abb;
        StructureDataIterator siter;

        SequenceIterator(int count, ArrayStructure abb) {
            this.count = count;
            this.abb = abb;
        }

        public boolean hasNext() throws IOException {
            if (this.siter == null) {
                this.siter = this.abb.getStructureDataIterator();
            }
            return this.siter.hasNext();
        }

        public StructureData next() throws IOException {
            return this.siter.next();
        }

        public void setBufferSize(int bytes) {
            this.siter.setBufferSize(bytes);
        }

        public StructureDataIterator reset() {
            this.siter = null;
            return this;
        }
    }

    private class MemberDD {
        StructureMembers.Member m;
        DataDescriptor dd;
        int bitOffset;
        List<MemberDD> nested;

        MemberDD(StructureMembers.Member m, DataDescriptor dd, int bitOffset) {
            this.m = m;
            this.dd = dd;
            this.bitOffset = bitOffset;
        }
    }

    private class MsgFinder {
        int msgIndex = 0;

        private MsgFinder() {
        }

        Message find(int index) {
            while (this.msgIndex < BufrIosp.this.msgs.size()) {
                Message m = (Message)BufrIosp.this.msgs.get(this.msgIndex);
                if (BufrIosp.this.obsStart[this.msgIndex] <= index && index < BufrIosp.this.obsStart[this.msgIndex] + m.getNumberDatasets()) {
                    return m;
                }
                ++this.msgIndex;
            }
            return null;
        }

        int obsOffsetInMessage(int index) {
            return index - BufrIosp.this.obsStart[this.msgIndex];
        }
    }
}

