/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.TableA;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.unidata.util.StringUtil;

public class BufrTables {
    private static Logger log = LoggerFactory.getLogger(BufrTables.class);
    private static final Pattern category = Pattern.compile("^\\s*(\\w+)\\s+(.*)");
    private static final Pattern threeInts = Pattern.compile("^\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)");
    private static final Pattern negOne = Pattern.compile("^\\s*-1");
    private static final boolean debugTable = false;
    private static Map<String, TableA> tablesA = new ConcurrentHashMap<String, TableA>();
    private static Map<String, TableB> tablesB = new ConcurrentHashMap<String, TableB>();
    private static Map<String, TableD> tablesD = new ConcurrentHashMap<String, TableD>();
    static final String RESOURCE_PATH = "/resources/bufrTables/";

    private static InputStream open(String location) throws IOException {
        InputStream ios = null;
        String tmp = "/resources/bufrTables/tables/" + location;
        ios = BufrTables.class.getResourceAsStream(tmp);
        if (ios != null) {
            return ios;
        }
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return ios;
    }

    public static TableA getTableA(String tablename) throws IOException {
        TableA a = tablesA.get(tablename);
        if (a == null) {
            a = BufrTables.readTableA(tablename);
            tablesA.put(tablename, a);
        }
        return a;
    }

    public static boolean hasTableB(String tablename) {
        return tablesB.get(tablename) != null;
    }

    public static TableB getTableB(String tablename) throws IOException {
        TableB b = tablesB.get(tablename);
        if (b == null) {
            b = BufrTables.readTableB(tablename);
            tablesB.put(tablename, b);
        }
        return b;
    }

    public static TableD getTableD(String tablename) throws IOException {
        TableD d = tablesD.get(tablename);
        if (d == null) {
            d = BufrTables.readTableD(tablename);
            tablesD.put(tablename, d);
        }
        return d;
    }

    static void addTableB(String tablename, TableB b) {
        tablesB.put(tablename, b);
    }

    static void addTableD(String tablename, TableD d) {
        tablesD.put(tablename, d);
    }

    private static TableA readTableA(String tablename) throws IOException {
        String line;
        InputStream ios = BufrTables.open(tablename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        HashMap<Short, String> categories = new HashMap<Short, String>();
        while ((line = dataIS.readLine()) != null) {
            Matcher m;
            if (line.startsWith("#") || line.length() == 0 || !(m = category.matcher(line)).find() || m.group(2).equals("RESERVED") || m.group(2).equals("FOR EXPERIMENTAL USE")) continue;
            String cat = m.group(2).trim();
            categories.put(Short.valueOf(m.group(1)), cat);
        }
        dataIS.close();
        return new TableA(tablename, tablename, categories);
    }

    public static TableB readTableB(String tablename) throws IOException {
        String line;
        InputStream ios = BufrTables.open(tablename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        TableB b = new TableB(tablename, tablename);
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.length() == 0) continue;
            try {
                String[] split = line.split("; ");
                short x = Short.parseShort(split[1].trim());
                short y = Short.parseShort(split[2].trim());
                int scale = Integer.parseInt(split[3].trim());
                int refVal = Integer.parseInt(split[4].trim());
                int width = Integer.parseInt(split[5].trim());
                b.addDescriptor(x, y, scale, refVal, width, split[7].trim(), split[6].trim());
            }
            catch (Exception e) {
                log.error("Bad table " + tablename + " entry=<" + line + ">", (Throwable)e);
            }
        }
        dataIS.close();
        return b;
    }

    public static TableD readTableD(String tablename) throws IOException {
        String line;
        InputStream ios = BufrTables.open(tablename);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        int count = 0;
        TableD d = new TableD(tablename, tablename);
        while ((line = dataIS.readLine()) != null) {
            ++count;
            if (line.startsWith("#") || line.length() == 0) continue;
            String[] split = line.split("[ \t]+");
            try {
                short seqF = Short.parseShort(split[0]);
                short seqX = Short.parseShort(split[1]);
                short seqY = Short.parseShort(split[2]);
                assert (seqF == 3);
                String seqName = "";
                if (split.length > 3) {
                    StringBuilder sb = new StringBuilder(40);
                    for (int i = 3; i < split.length; ++i) {
                        sb.append(split[i]).append(" ");
                    }
                    seqName = sb.toString();
                    seqName = StringUtil.remove(seqName, "()");
                }
                ArrayList<Short> seq = new ArrayList<Short>();
                while ((line = dataIS.readLine()) != null) {
                    ++count;
                    if (line.startsWith("#") || line.length() == 0) continue;
                    Matcher m = threeInts.matcher(line);
                    if (m.find()) {
                        short f = Short.parseShort(m.group(1));
                        short x = Short.parseShort(m.group(2));
                        short y = Short.parseShort(m.group(3));
                        seq.add(Descriptor.getFxy(f, x, y));
                        continue;
                    }
                    m = negOne.matcher(line);
                    if (!m.find()) continue;
                    d.addDescriptor(seqX, seqY, seqName, seq);
                }
            }
            catch (Exception e) {
                log.warn("TableD " + tablename + " Failed on line " + count + " = " + line + "\n " + e);
                e.printStackTrace();
            }
        }
        dataIS.close();
        return d;
    }

    public static void main(String[] args) throws IOException {
        Formatter out = new Formatter(System.out);
        TableB tableB = BufrTables.getTableB("B4M-000-014-B");
        tableB.show(out);
    }
}

