/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableB {
    private String name;
    private String location;
    private Map<Short, Descriptor> map = new HashMap<Short, Descriptor>();

    public TableB(String name, String location) {
        this.name = name;
        this.location = location;
    }

    void addDescriptor(short x, short y, int scale, int refVal, int width, String name, String units) {
        short id = (short)((x << 8) + y);
        this.map.put(id, new Descriptor(x, y, scale, refVal, width, name, units));
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public Descriptor getDescriptor(short id) {
        return this.map.get(id);
    }

    Collection<Descriptor> getDescriptors() {
        return this.map.values();
    }

    public void show(Formatter out) {
        Set<Short> keys = this.map.keySet();
        ArrayList<Short> sortKeys = new ArrayList<Short>(keys);
        Collections.sort(sortKeys);
        out.format("Table B %s %n", this.name);
        for (Short key : sortKeys) {
            Descriptor dd = this.map.get(key);
            dd.show(out);
            out.format("%n", new Object[0]);
        }
    }

    public class Descriptor {
        private final short x;
        private final short y;
        private final int scale;
        private final int refVal;
        private final int width;
        private final String units;
        private final String name;
        private final boolean numeric;

        Descriptor(short x, short y, int scale, int refVal, int width, String name, String units) {
            this.x = x;
            this.y = y;
            this.scale = scale;
            this.refVal = refVal;
            this.width = width;
            this.name = name;
            this.units = units;
            this.numeric = !units.equals("CCITT_IA5") && !units.equals("CCITT IA5");
        }

        public int getScale() {
            return this.scale;
        }

        public int getRefVal() {
            return this.refVal;
        }

        public int getWidth() {
            return this.width;
        }

        public String getUnits() {
            return this.units;
        }

        public String getName() {
            return this.name;
        }

        public short getId() {
            return (short)((this.x << 8) + this.y);
        }

        public String getFxy() {
            return "0-" + this.x + "-" + this.y;
        }

        public boolean isNumeric() {
            return this.numeric;
        }

        public String toString() {
            Formatter out = new Formatter();
            this.show(out);
            return out.toString();
        }

        void show(Formatter out) {
            out.format(" %8s scale=%d refVal=%d width=%d  units=(%s) name=(%s)", this.getFxy(), this.scale, this.refVal, this.width, this.units, this.name);
        }
    }
}

