/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableD {
    private String name;
    private String location;
    private Map<Short, Descriptor> map;

    public TableD(String name, String location) {
        this.name = name;
        this.location = location;
        this.map = new HashMap<Short, Descriptor>();
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    void addDescriptor(short x, short y, String name, List<Short> seq) {
        short id = (short)(49152 + (x << 8) + y);
        this.map.put(id, new Descriptor(x, y, name, seq));
    }

    public Descriptor getDescriptor(short id) {
        return this.map.get(id);
    }

    public void show(Formatter out) {
        Set<Short> keys = this.map.keySet();
        ArrayList<Short> sortKeys = new ArrayList<Short>(keys);
        Collections.sort(sortKeys);
        out.format("Table D %s %n", this.name);
        for (Short key : sortKeys) {
            Descriptor dd = this.map.get(key);
            dd.show(out);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Descriptor {
        private short x;
        private short y;
        private String name;
        private List<Short> seq;

        Descriptor(short x, short y, String name, List<Short> seq) {
            this.x = x;
            this.y = y;
            this.name = name;
            this.seq = seq;
        }

        public List<Short> getSequence() {
            return this.seq;
        }

        public String getName() {
            return this.name;
        }

        public short getId() {
            return (short)(49152 + (this.x << 8) + this.y);
        }

        public String getFxy() {
            return "3-" + this.x + "-" + this.y;
        }

        public String toString() {
            return this.getFxy() + " " + this.getName();
        }

        void show(Formatter out) {
            out.format(" %8s: name=(%s) seq=", this.getFxy(), this.name);
            for (short s : this.seq) {
                out.format(" %s,", ucar.nc2.iosp.bufr.Descriptor.makeString(s));
            }
            out.format("%n", new Object[0]);
        }
    }
}

