/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.Index;
import ucar.grib.TableLookup;
import ucar.grib.grib1.Grib1Lookup;
import ucar.grid.GridParameter;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.fmr.FmrcCoordSys;
import ucar.nc2.iosp.grib.GribHorizCoordSys;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.iosp.grib.GribTimeCoord;
import ucar.nc2.iosp.grib.GribVariable;
import ucar.nc2.iosp.grib.GribVertCoord;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index2NC {
    private static Logger logger = LoggerFactory.getLogger(Index2NC.class);
    private Map<String, GribHorizCoordSys> hcsHash = new HashMap<String, GribHorizCoordSys>(10);
    private DateFormatter formatter = new DateFormatter();
    private boolean debug = false;

    public static boolean isLayer(Index.GribRecord gr, TableLookup lookup) {
        if (lookup instanceof Grib1Lookup) {
            if (gr.levelType1 == 101) {
                return true;
            }
            if (gr.levelType1 == 104) {
                return true;
            }
            if (gr.levelType1 == 106) {
                return true;
            }
            if (gr.levelType1 == 108) {
                return true;
            }
            if (gr.levelType1 == 110) {
                return true;
            }
            if (gr.levelType1 == 112) {
                return true;
            }
            if (gr.levelType1 == 114) {
                return true;
            }
            if (gr.levelType1 == 116) {
                return true;
            }
            if (gr.levelType1 == 120) {
                return true;
            }
            if (gr.levelType1 == 121) {
                return true;
            }
            if (gr.levelType1 == 128) {
                return true;
            }
            return gr.levelType1 == 141;
        }
        if (gr.levelType1 == 0) {
            return false;
        }
        return gr.levelType2 != 255;
    }

    public static String makeLevelName(Index.GribRecord gr, TableLookup lookup) {
        String vname = lookup.getLevelName(gr);
        boolean isGrib1 = lookup instanceof Grib1Lookup;
        if (isGrib1) {
            return vname;
        }
        return Index2NC.isLayer(gr, lookup) ? vname + "_layer" : vname;
    }

    public static String makeVariableName(Index.GribRecord gr, TableLookup lookup) {
        GridParameter param = lookup.getParameter(gr);
        if (param == null) {
            return null;
        }
        String levelName = Index2NC.makeLevelName(gr, lookup);
        return levelName == null || levelName.length() == 0 ? param.getDescription() : param.getDescription() + "_" + levelName;
    }

    public static String makeLongName(Index.GribRecord gr, TableLookup lookup) {
        GridParameter param = lookup.getParameter(gr);
        String levelName = Index2NC.makeLevelName(gr, lookup);
        return levelName.length() == 0 ? param.getDescription() : param.getDescription() + " @ " + Index2NC.makeLevelName(gr, lookup);
    }

    void open(Index index, TableLookup lookup, int version, NetcdfFile ncfile, FmrcCoordSys fmrcCoordSys, CancelTask cancelTask) throws IOException {
        ArrayList<GribVariable> gribvars;
        String genType;
        List hcsList = index.getHorizCoordSys();
        boolean needGroups = hcsList.size() > 1;
        for (int i = 0; i < hcsList.size(); ++i) {
            Index.GdsRecord gdsIndex = (Index.GdsRecord)hcsList.get(i);
            Group g = null;
            if (needGroups) {
                g = new Group(ncfile, null, "proj" + i);
                ncfile.addGroup(null, g);
            }
            GribHorizCoordSys hcs = new GribHorizCoordSys(gdsIndex, lookup, g);
            this.hcsHash.put(gdsIndex.gdsKey, hcs);
        }
        Index.GribRecord firstRecord = null;
        List records = index.getGribRecords();
        if (GribServiceProvider.debugOpen) {
            System.out.println(" number of products = " + records.size());
        }
        for (Index.GribRecord gribRecord : records) {
            if (firstRecord == null) {
                firstRecord = gribRecord;
            }
            GribHorizCoordSys hcs = this.hcsHash.get(gribRecord.gdsKey);
            String name = Index2NC.makeVariableName(gribRecord, lookup);
            if (name == null) continue;
            GribVariable pv = hcs.varHash.get(name);
            if (null == pv) {
                String pname = lookup.getParameter(gribRecord).getDescription();
                pv = new GribVariable(name, pname, hcs, lookup);
                hcs.varHash.put(name, pv);
                List<GribVariable> plist = hcs.productHash.get(pname);
                if (null == plist) {
                    plist = new ArrayList<GribVariable>();
                    hcs.productHash.put(pname, plist);
                }
                plist.add(pv);
            }
            pv.addProduct(gribRecord);
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.0"));
        String creator = lookup.getFirstCenterName() + " subcenter = " + lookup.getFirstSubcenterId();
        if (creator != null) {
            ncfile.addAttribute(null, new Attribute("Originating_center", creator));
        }
        if ((genType = lookup.getTypeGenProcessName(firstRecord)) != null) {
            ncfile.addAttribute(null, new Attribute("Generating_Process_or_Model", genType));
        }
        if (null != lookup.getFirstProductStatusName()) {
            ncfile.addAttribute(null, new Attribute("Product_Status", lookup.getFirstProductStatusName()));
        }
        ncfile.addAttribute(null, new Attribute("Product_Type", lookup.getFirstProductTypeName()));
        ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
        ncfile.addAttribute(null, new Attribute("creator_name", creator));
        ncfile.addAttribute(null, new Attribute("file_format", "GRIB-" + version));
        ncfile.addAttribute(null, new Attribute("location", ncfile.getLocation()));
        ncfile.addAttribute(null, new Attribute("history", "Direct read of GRIB-" + version + " into NetCDF-Java 4.0 API"));
        ncfile.addAttribute(null, new Attribute("_CoordinateModelRunDate", this.formatter.toDateTimeStringISO(lookup.getFirstBaseTime())));
        if (fmrcCoordSys != null) {
            this.makeDefinedCoordSys(ncfile, lookup, fmrcCoordSys);
        } else {
            this.makeDenseCoordSys(ncfile, lookup, cancelTask);
        }
        if (GribServiceProvider.debugMissing) {
            int count = 0;
            Collection<GribHorizCoordSys> hcset = this.hcsHash.values();
            for (GribHorizCoordSys hcs : hcset) {
                gribvars = new ArrayList<GribVariable>(hcs.varHash.values());
                for (GribVariable gv : gribvars) {
                    count += gv.dumpMissingSummary();
                }
            }
            System.out.println(" total missing= " + count);
        }
        if (GribServiceProvider.debugMissingDetails) {
            Collection<GribHorizCoordSys> hcset = this.hcsHash.values();
            for (GribHorizCoordSys hcs : hcset) {
                System.out.println("******** Horiz Coordinate= " + hcs.getGridName());
                String lastVertDesc = null;
                gribvars = new ArrayList<GribVariable>(hcs.varHash.values());
                Collections.sort(gribvars, new CompareGribVariableByVertName());
                for (GribVariable gv : gribvars) {
                    String vertDesc = gv.getVertName();
                    if (!vertDesc.equals(lastVertDesc)) {
                        System.out.println("---Vertical Coordinate= " + vertDesc);
                        lastVertDesc = vertDesc;
                    }
                    gv.dumpMissing();
                }
            }
        }
        for (GribHorizCoordSys ghcs : this.hcsHash.values()) {
            ghcs.empty();
        }
    }

    private void makeDenseCoordSys(NetcdfFile ncfile, TableLookup lookup, CancelTask cancelTask) throws IOException {
        ArrayList<GribTimeCoord> timeCoords = new ArrayList<GribTimeCoord>();
        ArrayList<GribVertCoord> vertCoords = new ArrayList<GribVertCoord>();
        Collection<GribHorizCoordSys> hcset = this.hcsHash.values();
        for (GribHorizCoordSys hcs : hcset) {
            int vcIndex;
            if (cancelTask != null && cancelTask.isCancel()) break;
            ArrayList<GribVariable> gribvars = new ArrayList<GribVariable>(hcs.varHash.values());
            for (GribVariable pv : gribvars) {
                if (cancelTask != null && cancelTask.isCancel()) break;
                List<Index.GribRecord> recordList = pv.getRecords();
                Index.GribRecord record = recordList.get(0);
                String vname = Index2NC.makeLevelName(record, lookup);
                GribVertCoord useVertCoord = null;
                for (GribVertCoord gvcs : vertCoords) {
                    if (!vname.equals(gvcs.getLevelName()) || !gvcs.matchLevels(recordList)) continue;
                    useVertCoord = gvcs;
                }
                if (useVertCoord == null) {
                    useVertCoord = new GribVertCoord(recordList, vname, lookup);
                    vertCoords.add(useVertCoord);
                }
                pv.setVertCoord(useVertCoord);
                GribTimeCoord useTimeCoord = null;
                for (GribTimeCoord gribTimeCoord : timeCoords) {
                    if (!gribTimeCoord.matchLevels(recordList)) continue;
                    useTimeCoord = gribTimeCoord;
                }
                if (useTimeCoord == null) {
                    useTimeCoord = new GribTimeCoord(recordList, lookup);
                    timeCoords.add(useTimeCoord);
                }
                pv.setTimeCoord(useTimeCoord);
            }
            GribTimeCoord tcs0 = null;
            int maxTimes = 0;
            for (GribTimeCoord tcs : timeCoords) {
                if (tcs.getNTimes() <= maxTimes) continue;
                tcs0 = tcs;
                maxTimes = tcs.getNTimes();
            }
            int seqno = 1;
            for (GribTimeCoord tcs : timeCoords) {
                if (tcs != tcs0) {
                    tcs.setSequence(seqno++);
                }
                tcs.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addDimensionsToNetcdfFile(ncfile);
            Collections.sort(vertCoords);
            String listName = null;
            int start = 0;
            for (vcIndex = 0; vcIndex < vertCoords.size(); ++vcIndex) {
                GribVertCoord gvcs = (GribVertCoord)vertCoords.get(vcIndex);
                String vname = gvcs.getLevelName();
                if (listName == null) {
                    listName = vname;
                }
                if (vname.equals(listName)) continue;
                this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
                listName = vname;
                start = vcIndex;
            }
            this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
            ArrayList<List<GribVariable>> products = new ArrayList<List<GribVariable>>(hcs.productHash.values());
            Collections.sort(products, new CompareGribVariableListByName());
            for (List list : products) {
                if (cancelTask != null && cancelTask.isCancel()) break;
                if (list.size() == 1) {
                    GribVariable pv = (GribVariable)list.get(0);
                    Variable v = pv.makeVariable(ncfile, hcs.getGroup(), true);
                    ncfile.addVariable(hcs.getGroup(), v);
                    continue;
                }
                Collections.sort(list, new CompareGribVariableByNumberVertLevels());
                for (int k = 0; k < list.size(); ++k) {
                    GribVariable pv = (GribVariable)list.get(k);
                    ncfile.addVariable(hcs.getGroup(), pv.makeVariable(ncfile, hcs.getGroup(), k == 0));
                }
            }
            for (GribTimeCoord gribTimeCoord : timeCoords) {
                gribTimeCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addToNetcdfFile(ncfile);
            for (GribVertCoord gribVertCoord : vertCoords) {
                gribVertCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
        }
        for (GribVertCoord gvcs : vertCoords) {
            gvcs.empty();
        }
    }

    private void makeVerticalDimensions(List<GribVertCoord> vertCoordList, NetcdfFile ncfile, Group group) {
        GribVertCoord gvcs0 = null;
        int maxLevels = 0;
        for (GribVertCoord gvcs : vertCoordList) {
            if (gvcs.getNLevels() <= maxLevels) continue;
            gvcs0 = gvcs;
            maxLevels = gvcs.getNLevels();
        }
        int seqno = 1;
        for (GribVertCoord gvcs : vertCoordList) {
            if (gvcs != gvcs0) {
                gvcs.setSequence(seqno++);
            }
            gvcs.addDimensionsToNetcdfFile(ncfile, group);
        }
    }

    private void makeDefinedCoordSys(NetcdfFile ncfile, TableLookup lookup, FmrcCoordSys fmr) throws IOException {
        ArrayList<GribTimeCoord> timeCoords = new ArrayList<GribTimeCoord>();
        ArrayList<GribVertCoord> vertCoords = new ArrayList<GribVertCoord>();
        ArrayList<String> removeVariables = new ArrayList<String>();
        Collection<GribHorizCoordSys> hcset = this.hcsHash.values();
        for (GribHorizCoordSys hcs : hcset) {
            Set<String> keys = hcs.varHash.keySet();
            for (String key : keys) {
                GribVariable pv = hcs.varHash.get(key);
                Index.GribRecord record = pv.getFirstRecord();
                String searchName = this.findVariableName(ncfile, record, lookup, fmr);
                if (searchName == null) {
                    removeVariables.add(key);
                    continue;
                }
                pv.setVarName(searchName);
                FmrcCoordSys.VertCoord vc_def = fmr.findVertCoordForVariable(searchName);
                if (vc_def != null) {
                    String vc_name = vc_def.getName();
                    GribVertCoord useVertCoord = null;
                    for (GribVertCoord gvcs : vertCoords) {
                        if (!vc_name.equals(gvcs.getLevelName())) continue;
                        useVertCoord = gvcs;
                    }
                    if (useVertCoord == null) {
                        useVertCoord = new GribVertCoord(record, vc_name, lookup, vc_def.getValues1(), vc_def.getValues2());
                        useVertCoord.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
                        vertCoords.add(useVertCoord);
                    }
                    pv.setVertCoord(useVertCoord);
                } else {
                    pv.setVertCoord(new GribVertCoord(searchName));
                }
                FmrcCoordSys.TimeCoord tc_def = fmr.findTimeCoordForVariable(searchName, lookup.getFirstBaseTime());
                String tc_name = tc_def.getName();
                GribTimeCoord useTimeCoord = null;
                for (GribTimeCoord gtc : timeCoords) {
                    if (!tc_name.equals(gtc.getName())) continue;
                    useTimeCoord = gtc;
                }
                if (useTimeCoord == null) {
                    useTimeCoord = new GribTimeCoord(tc_name, tc_def.getOffsetHours(), lookup);
                    useTimeCoord.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
                    timeCoords.add(useTimeCoord);
                }
                pv.setTimeCoord(useTimeCoord);
            }
            for (String key : removeVariables) {
                hcs.varHash.remove(key);
            }
            hcs.addDimensionsToNetcdfFile(ncfile);
            Collection<GribVariable> vars = hcs.varHash.values();
            for (GribVariable pv : vars) {
                Variable v;
                Group g = hcs.getGroup() == null ? ncfile.getRootGroup() : hcs.getGroup();
                if (g.findVariable((v = pv.makeVariable(ncfile, g, true)).getShortName()) != null) {
                    logger.warn("GribServiceProvider.Index2NC: FmrcCoordSys has 2 variables mapped to =" + v.getShortName() + " for file " + ncfile.getLocation());
                    continue;
                }
                g.addVariable(v);
            }
            for (GribTimeCoord tcs : timeCoords) {
                tcs.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addToNetcdfFile(ncfile);
            for (GribVertCoord gvcs : vertCoords) {
                gvcs.addToNetcdfFile(ncfile, hcs.getGroup());
            }
        }
        if (this.debug) {
            System.out.println("Index2NC.makeDefinedCoordSys for " + ncfile.getLocation());
        }
    }

    private String findVariableName(NetcdfFile ncfile, Index.GribRecord gr, TableLookup lookup, FmrcCoordSys fmr) {
        String name = Index2NC.makeVariableName(gr, lookup);
        if (fmr.hasVariable(name)) {
            return name;
        }
        String pname = lookup.getParameter(gr).getDescription();
        if (fmr.hasVariable(pname)) {
            return pname;
        }
        String nameWunder = StringUtil.replace(name, ' ', "_");
        if (fmr.hasVariable(nameWunder)) {
            return nameWunder;
        }
        String pnameWunder = StringUtil.replace(pname, ' ', "_");
        if (fmr.hasVariable(pnameWunder)) {
            return pnameWunder;
        }
        logger.warn("GribServiceProvider.Index2NC: FmrcCoordSys does not have the variable named =" + name + " or " + pname + " or " + nameWunder + " or " + pnameWunder + " for file " + ncfile.getLocation());
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareGribVariableByNumberVertLevels
    implements Comparator<GribVariable> {
        private CompareGribVariableByNumberVertLevels() {
        }

        @Override
        public int compare(GribVariable gv1, GribVariable gv2) {
            int n2;
            int n1 = gv1.getVertCoord().getNLevels();
            if (n1 == (n2 = gv2.getVertCoord().getNLevels())) {
                return gv1.getVertCoord().getLevelName().compareTo(gv2.getVertCoord().getLevelName());
            }
            return n2 - n1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareGribVariableByVertName
    implements Comparator<GribVariable> {
        private CompareGribVariableByVertName() {
        }

        @Override
        public int compare(GribVariable gv1, GribVariable gv2) {
            return gv1.getVertName().compareToIgnoreCase(gv2.getVertName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareGribVariableListByName
    implements Comparator<List<GribVariable>> {
        private CompareGribVariableListByName() {
        }

        @Override
        public int compare(List<GribVariable> list1, List<GribVariable> list2) {
            GribVariable gv1 = list1.get(0);
            GribVariable gv2 = list2.get(0);
            return gv1.getName().compareToIgnoreCase(gv2.getName());
        }
    }
}

