/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.iosp.hdf4.ODLparser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HdfEos {
    private static Logger log = LoggerFactory.getLogger(HdfEos.class);
    private static boolean showTypes = false;

    public static void amendFromODL(NetcdfFile ncfile, Group eosGroup) throws IOException {
        Variable structMetadataVar;
        StringBuilder sbuff = null;
        String structMetadata = null;
        int n = 0;
        while ((structMetadataVar = eosGroup.findVariable("StructMetadata." + n)) != null) {
            if (structMetadata != null && sbuff == null) {
                sbuff = new StringBuilder(64000);
                sbuff.append(structMetadata);
            }
            Array A = structMetadataVar.read();
            ArrayChar ca = (ArrayChar)A;
            structMetadata = ca.getString();
            if (sbuff != null) {
                sbuff.append(structMetadata);
            }
            ++n;
        }
        if (sbuff != null) {
            structMetadata = sbuff.toString();
        }
        if (structMetadata != null) {
            new HdfEos().amendFromODL(ncfile, structMetadata);
        }
    }

    private void amendFromODL(NetcdfFile ncfile, String structMetadata) throws IOException {
        Element pointStructure;
        Element gridStructure;
        Group rootg = ncfile.getRootGroup();
        ODLparser parser = new ODLparser();
        Element root = parser.parseFromString(structMetadata);
        Enum featureType = null;
        Element swathStructure = root.getChild("SwathStructure");
        if (swathStructure != null) {
            List swaths = swathStructure.getChildren();
            for (Element elemSwath : swaths) {
                Element swathNameElem = elemSwath.getChild("SwathName");
                if (swathNameElem == null) {
                    log.warn("No SwathName element in " + elemSwath.getName());
                    continue;
                }
                String swathName = swathNameElem.getText();
                Group swathGroup = this.findGroupNested(rootg, swathName);
                if (swathGroup != null) {
                    featureType = this.amendSwath(ncfile, elemSwath, swathGroup);
                    continue;
                }
                log.warn("Cant find swath group " + swathName);
            }
        }
        if ((gridStructure = root.getChild("GridStructure")) != null) {
            List grids = gridStructure.getChildren();
            for (Element elemGrid : grids) {
                Element gridNameElem = elemGrid.getChild("GridName");
                if (gridNameElem == null) {
                    log.warn("Ne GridName element in " + elemGrid.getName());
                    continue;
                }
                String gridName = gridNameElem.getText();
                Group gridGroup = this.findGroupNested(rootg, gridName);
                if (gridGroup != null) {
                    featureType = this.amendGrid(elemGrid, gridGroup);
                    continue;
                }
                log.warn("Cant find Grid group " + gridName);
            }
        }
        if ((pointStructure = root.getChild("PointStructure")) != null) {
            List pts = pointStructure.getChildren();
            for (Element elem : pts) {
                Element nameElem = elem.getChild("PointName");
                if (nameElem == null) {
                    log.warn("No PointName element in " + elem.getName());
                    continue;
                }
                String name = nameElem.getText();
                Group ptGroup = this.findGroupNested(rootg, name);
                if (ptGroup != null) {
                    featureType = FeatureType.POINT;
                    continue;
                }
                log.warn("Cant find Point group " + name);
            }
        }
        if (featureType != null) {
            if (showTypes) {
                System.out.println("***EOS featureType= " + featureType.toString());
            }
            rootg.addAttribute(new Attribute("cdm_data_type", featureType.toString()));
        }
    }

    private FeatureType amendSwath(NetcdfFile ncfile, Element swathElem, Group parent) {
        Group dataG;
        Variable v;
        FeatureType featureType = FeatureType.SWATH;
        ArrayList<Dimension> unknownDims = new ArrayList<Dimension>();
        Element d = swathElem.getChild("Dimension");
        List dims = d.getChildren();
        for (Element elem : dims) {
            String name = elem.getChild("DimensionName").getText();
            if (name.equalsIgnoreCase("scalar")) continue;
            String sizeS = elem.getChild("Size").getText();
            int length = Integer.parseInt(sizeS);
            if (length > 0) {
                Dimension dim = new Dimension(name, length);
                parent.addDimension(dim);
                continue;
            }
            log.warn("Dimension " + name + " has size " + sizeS);
            Dimension udim = new Dimension(name, 1);
            udim.setGroup(parent);
            unknownDims.add(udim);
        }
        Element dmap = swathElem.getChild("DimensionMap");
        List dimMaps = dmap.getChildren();
        for (Element elem : dimMaps) {
            String geoDimName = elem.getChild("GeoDimension").getText();
            String dataDimName = elem.getChild("DataDimension").getText();
            String offsetS = elem.getChild("Offset").getText();
            String incrS = elem.getChild("Increment").getText();
            int offset = Integer.parseInt(offsetS);
            int incr = Integer.parseInt(incrS);
            v = new Variable(ncfile, parent, null, dataDimName);
            v.setDimensions(geoDimName);
            v.setDataType(DataType.INT);
            int npts = (int)v.getSize();
            Array data = Array.makeArray(v.getDataType(), npts, offset, incr);
            v.setCachedData(data, true);
            v.addAttribute(new Attribute("_DimensionMap", ""));
            parent.addVariable(v);
        }
        Group geoFieldsG = parent.findGroup("Geolocation Fields");
        if (geoFieldsG != null) {
            List<Dimension> xyDomain;
            Variable latAxis = null;
            Variable lonAxis = null;
            Element floc = swathElem.getChild("GeoField");
            List varsLoc = floc.getChildren();
            for (Element elem : varsLoc) {
                String varname = elem.getChild("GeoFieldName").getText();
                v = geoFieldsG.findVariable(varname);
                assert (v != null) : varname;
                AxisType axis = this.addAxisType(v);
                if (axis == AxisType.Lat) {
                    latAxis = v;
                }
                if (axis == AxisType.Lon) {
                    lonAxis = v;
                }
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(v, values, unknownDims);
            }
            if (latAxis != null && lonAxis != null && (xyDomain = CoordinateSystem.makeDomain(new Variable[]{latAxis, lonAxis})).size() < 2) {
                featureType = FeatureType.PROFILE;
            }
        }
        if ((dataG = parent.findGroup("Data Fields")) != null) {
            Element f = swathElem.getChild("DataField");
            List vars = f.getChildren();
            for (Element elem : vars) {
                Element dataFieldNameElem = elem.getChild("DataFieldName");
                if (dataFieldNameElem == null) continue;
                String varname = dataFieldNameElem.getText();
                v = dataG.findVariable(varname);
                if (v == null) {
                    log.error("Cant find " + varname);
                    continue;
                }
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(v, values, unknownDims);
            }
        }
        return featureType;
    }

    private AxisType addAxisType(Variable v) {
        String name = v.getShortName();
        if (name.equalsIgnoreCase("Latitude") || name.equalsIgnoreCase("GeodeticLatitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
            v.addAttribute(new Attribute("units", "degrees_north"));
            return AxisType.Lat;
        }
        if (name.equalsIgnoreCase("Longitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
            v.addAttribute(new Attribute("units", "degrees_east"));
            return AxisType.Lon;
        }
        if (name.equalsIgnoreCase("Time")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
            return AxisType.Time;
        }
        if (name.equalsIgnoreCase("Pressure")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            return AxisType.Pressure;
        }
        if (name.equalsIgnoreCase("Altitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
            v.addAttribute(new Attribute("positive", "up"));
            return AxisType.Height;
        }
        return null;
    }

    private FeatureType amendGrid(Element gridElem, Group parent) {
        Group dataG;
        ArrayList<Dimension> unknownDims = new ArrayList<Dimension>();
        String xdimSizeS = gridElem.getChild("XDim").getText();
        String ydimSizeS = gridElem.getChild("YDim").getText();
        int xdimSize = Integer.parseInt(xdimSizeS);
        int ydimSize = Integer.parseInt(ydimSizeS);
        parent.addDimension(new Dimension("XDim", xdimSize));
        parent.addDimension(new Dimension("YDim", ydimSize));
        Element d = gridElem.getChild("Dimension");
        List dims = d.getChildren();
        for (Element elem : dims) {
            String name = elem.getChild("DimensionName").getText();
            if (name.equalsIgnoreCase("scalar")) continue;
            String sizeS = elem.getChild("Size").getText();
            int length = Integer.parseInt(sizeS);
            Dimension old = parent.findDimension(name);
            if (old != null && old.getLength() == length) continue;
            if (length > 0) {
                Dimension dim = new Dimension(name, length);
                parent.addDimension(dim);
                continue;
            }
            log.warn("Dimension " + name + " has size " + sizeS);
            Dimension udim = new Dimension(name, 1);
            udim.setGroup(parent);
            unknownDims.add(udim);
        }
        Group geoFieldsG = parent.findGroup("Geolocation Fields");
        if (geoFieldsG != null) {
            Element floc = gridElem.getChild("GeoField");
            List varsLoc = floc.getChildren();
            for (Element elem : varsLoc) {
                String varname = elem.getChild("GeoFieldName").getText();
                Variable v = geoFieldsG.findVariable(varname);
                assert (v != null) : varname;
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(v, values, unknownDims);
            }
        }
        if ((dataG = parent.findGroup("Data Fields")) != null) {
            Element f = gridElem.getChild("DataField");
            List vars = f.getChildren();
            for (Element elem : vars) {
                String varname = elem.getChild("DataFieldName").getText();
                Variable v = dataG.findVariable(varname);
                assert (v != null) : varname;
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(v, values, unknownDims);
            }
        }
        return FeatureType.GRID;
    }

    private void setSharedDimensions(Variable v, List<Element> values, List<Dimension> unknownDims) {
        if (values.size() == 0) {
            return;
        }
        Iterator<Element> iter = values.iterator();
        while (iter.hasNext()) {
            Element value = iter.next();
            String dimName = value.getText();
            if (!dimName.equalsIgnoreCase("scalar")) continue;
            iter.remove();
        }
        List<Dimension> oldDims = v.getDimensions();
        if (oldDims.size() != values.size()) {
            log.error("Different number of dimensions for " + v);
            return;
        }
        ArrayList<Dimension> newDims = new ArrayList<Dimension>();
        Group group = v.getParentGroup();
        for (int i = 0; i < values.size(); ++i) {
            Element value = values.get(i);
            String dimName = value.getText();
            Dimension dim = group.findDimension(dimName);
            Dimension oldDim = oldDims.get(i);
            if (dim == null) {
                dim = this.checkUnknownDims(dimName, unknownDims, oldDim);
            }
            if (dim == null) {
                log.error("Unknown Dimension= " + dimName + " for variable = " + v.getName());
                return;
            }
            if (dim.getLength() != oldDim.getLength()) {
                log.error("Shared dimension (" + dim.getName() + ") has different length than data dimension (" + oldDim.getName() + ") shared=" + dim.getLength() + " org=" + oldDim.getLength() + " for " + v);
                return;
            }
            newDims.add(dim);
        }
        v.setDimensions(newDims);
    }

    private Dimension checkUnknownDims(String wantDim, List<Dimension> unknownDims, Dimension oldDim) {
        for (Dimension dim : unknownDims) {
            if (!dim.getName().equals(wantDim)) continue;
            int len = oldDim.getLength();
            if (len == 0) {
                dim.setUnlimited(true);
            }
            dim.setLength(len);
            Group parent = dim.getGroup();
            parent.addDimension(dim);
            unknownDims.remove(dim);
            log.warn("unknownDim " + wantDim + " length set to " + oldDim.getLength());
            return dim;
        }
        return null;
    }

    private Group findGroupNested(Group parent, String name) {
        for (Group g : parent.getGroups()) {
            if (!g.getShortName().equals(name)) continue;
            return g;
        }
        for (Group g : parent.getGroups()) {
            Group result = this.findGroupNested(g, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

