/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream.old;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.stream.old.StreamWriter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamIosp
extends AbstractIOServiceProvider {
    private RandomAccessFile raf;
    private NetcdfFile ncfile;
    private Map<String, Vinfo> varMap = new HashMap<String, Vinfo>();
    private boolean debug = true;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        byte[] magicb = new byte[8];
        this.readBytes(magicb);
        String magicS = new String(magicb);
        return magicS.equals(StreamWriter.MAGIC_HEADER);
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        String magic;
        this.raf = raf;
        this.ncfile = ncfile;
        if (!this.isValidFile(raf)) {
            throw new IllegalArgumentException("Not a NetCDF Stream file");
        }
        while (true) {
            if ((magic = this.readMagic()).equals(StreamWriter.MAGIC_HEADER)) {
                magic = this.readHeader();
                continue;
            }
            if (!magic.equals(StreamWriter.MAGIC_DATA)) break;
            this.readDataHeader();
        }
        throw new IllegalStateException("BAD MAGIC " + magic);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    private String readMagic() throws IOException {
        byte[] magic = new byte[4];
        this.readBytes(magic);
        String magicS = new String(magic);
        if (this.debug) {
            System.out.println("Got magic= " + magicS);
        }
        return magicS;
    }

    private String readHeader() throws IOException {
        String magic;
        Group root = this.ncfile.getRootGroup();
        while (true) {
            if ((magic = this.readMagic()).equals(StreamWriter.MAGIC_HEADER)) {
                magic = this.readMagic();
            }
            if (magic.equals("Atts")) {
                this.readAtts(root.getAttributes());
                continue;
            }
            if (magic.equals("Dims")) {
                this.readDims(root.getDimensions());
                continue;
            }
            if (!magic.equals("Vars")) break;
            this.readVars(root.getVariables());
        }
        return magic;
    }

    private void readAtts(List<Attribute> atts) throws IOException {
        int natts = this.readVInt();
        if (natts == 0) {
            return;
        }
        for (int i = 0; i < natts; ++i) {
            String name = this.readString();
            int type = this.readVInt();
            int nvals = this.readVInt();
            DataType dt = StreamWriter.getDataType(type);
            Array data = Array.factory(dt, new int[]{nvals});
            this.readValues(data.getIndexIterator(), dt);
            atts.add(new Attribute(name, data));
        }
    }

    private void readValues(IndexIterator ii, DataType dt) throws IOException {
        if (dt == DataType.BYTE) {
            while (ii.hasNext()) {
                ii.setByteNext(this.raf.readByte());
            }
        } else if (dt == DataType.CHAR) {
            while (ii.hasNext()) {
                ii.setCharNext((char)this.raf.readByte());
            }
        } else if (dt == DataType.SHORT) {
            while (ii.hasNext()) {
                ii.setShortNext(this.raf.readShort());
            }
        } else if (dt == DataType.INT) {
            while (ii.hasNext()) {
                ii.setIntNext(this.raf.readInt());
            }
        } else if (dt == DataType.FLOAT) {
            while (ii.hasNext()) {
                ii.setFloatNext(this.raf.readFloat());
            }
        } else if (dt == DataType.DOUBLE) {
            while (ii.hasNext()) {
                ii.setDoubleNext(this.raf.readDouble());
            }
        } else if (dt == DataType.STRING) {
            while (ii.hasNext()) {
                ii.setObjectNext(this.readString());
            }
        } else {
            throw new IllegalStateException("unknown data type == " + (Object)((Object)dt));
        }
    }

    private void readDims(List<Dimension> dims) throws IOException {
        int ndims = this.readVInt();
        for (int i = 0; i < ndims; ++i) {
            String name = this.readString();
            int length = this.readVInt();
            byte flags = this.readByte();
            boolean isShared = (flags & 1) != 0;
            boolean isUnlimited = (flags & 2) != 0;
            boolean isVariableLength = (flags & 4) != 0;
            dims.add(new Dimension(name, length, isShared, isUnlimited, isVariableLength));
        }
    }

    private void readVars(List<Variable> vars) throws IOException {
        int nvars = this.readVInt();
        for (int i = 0; i < nvars; ++i) {
            String varname = this.readString();
            int type = this.readVInt();
            DataType dt = StreamWriter.getDataType(type);
            if (this.debug) {
                System.out.println("  var= " + varname + " type = " + type + " dataType = " + (Object)((Object)dt));
            }
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            this.readDims(dims);
            Variable v = new Variable(this.ncfile, null, null, varname);
            v.setDataType(dt);
            v.setDimensions(dims);
            this.readAtts(v.getAttributes());
            vars.add(v);
            Vinfo vinfo = this.varMap.get(varname);
            if (vinfo == null) {
                vinfo = new Vinfo(varname, type);
                this.varMap.put(varname, vinfo);
            }
            vinfo.v = v;
            v.setSPobject(vinfo);
        }
    }

    private void readDataHeader() throws IOException {
        try {
            String varname = this.readString();
            int type = this.readVInt();
            Section s = this.readSection();
            long filePos = this.raf.getFilePointer();
            Vinfo vinfo = this.varMap.get(varname);
            if (vinfo == null) {
                vinfo = new Vinfo(varname, type);
                this.varMap.put(varname, vinfo);
            }
            DataType dtype = StreamWriter.getDataType(type);
            long size = s.computeSize() * (long)dtype.getSize();
            vinfo.data.add(new DataSection(s, filePos, size));
            this.raf.seek(filePos + size);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException("Illegal section");
        }
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        return null;
    }

    private void readData() throws IOException, InvalidRangeException {
        String name = this.readString();
        Section s = this.readSection();
        Variable v = this.ncfile.findVariable(name);
        assert (v != null);
        DataType dt = v.getDataType();
        if (this.debug) {
            System.out.println("  var= " + name + " datatype = " + (Object)((Object)dt) + " section = " + s);
        }
        if (dt == DataType.STRUCTURE) {
            ArrayStructure data = this.readStructureData((Structure)v, s);
        } else {
            Array data = Array.factory(dt, s.getShape());
            this.readValues(data.getIndexIterator(), v.getDataType());
        }
    }

    private ArrayStructure readStructureData(Structure v, Section s) throws IOException {
        StructureMembers sm = v.makeStructureMembers();
        int offset = 0;
        for (StructureMembers.Member m : sm.getMembers()) {
            m.setDataParam(offset);
            offset += m.getSizeBytes();
        }
        sm.setStructureSize(offset);
        int size = (int)((long)sm.getStructureSize() * s.computeSize());
        byte[] ba = new byte[size];
        this.readBytes(ba);
        ByteBuffer bb = ByteBuffer.wrap(ba);
        return new ArrayStructureBB(sm, s.getShape(), bb, 0);
    }

    private Section readSection() throws IOException, InvalidRangeException {
        int rank = this.readVInt();
        Section s = new Section();
        for (int i = 0; i < rank; ++i) {
            int first = this.readVInt();
            int length = this.readVInt();
            s.appendRange(new Range(first, first + length - 1));
        }
        return s;
    }

    private byte readByte() throws IOException {
        return this.raf.readByte();
    }

    private void readBytes(byte[] b) throws IOException {
        this.raf.readFully(b, 0, b.length);
    }

    private int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    private String readString() throws IOException {
        int length = this.readVInt();
        char[] chars = new char[length];
        this.readChars(chars, 0, length);
        return new String(chars, 0, length);
    }

    private void readChars(char[] buffer, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            byte b = this.readByte();
            buffer[i] = (b & 0x80) == 0 ? (char)(b & 0x7F) : ((b & 0xE0) != 224 ? (char)((b & 0x1F) << 6 | this.readByte() & 0x3F) : (char)((b & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F));
        }
    }

    private class DataSection {
        Section s;
        long filePos;
        long sizeBytes;

        DataSection(Section s, long filePos, long sizeBytes) {
            this.s = s;
            this.filePos = filePos;
            this.sizeBytes = sizeBytes;
        }
    }

    private class Vinfo {
        String name;
        Variable v;
        int type;
        List<DataSection> data = new ArrayList<DataSection>();

        Vinfo(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

