/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.XMLEntityResolver;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.radial.StationRadarCollectionImpl;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateType;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.Product;

public class TDSRadarDatasetCollection
extends StationRadarCollectionImpl {
    protected HashMap<String, Station> stationHMap;
    private List radarTimeSpan;
    private LatLonRect radarRegion;
    private String dsc_location;
    private List radarProducts;
    private String summary;
    protected static final Namespace defNS = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4");
    private URI docURI;

    public static TDSRadarDatasetCollection factory(InvDataset ds, String dsc_location, StringBuffer errlog) throws IOException, URISyntaxException {
        return TDSRadarDatasetCollection.factory(ds.getDocumentation("summary"), dsc_location, errlog);
    }

    public static TDSRadarDatasetCollection factory(String desc, String dsc_location, StringBuffer errlog) throws IOException {
        Document doc = null;
        XMLEntityResolver jaxp = new XMLEntityResolver(true);
        SAXBuilder builder = jaxp.getSAXBuilder();
        try {
            doc = builder.build(dsc_location);
        }
        catch (JDOMException e) {
            errlog.append(e.toString());
        }
        Element qcElem = doc.getRootElement();
        Namespace ns = qcElem.getNamespace();
        return new TDSRadarDatasetCollection(desc, dsc_location, qcElem, ns, errlog);
    }

    private TDSRadarDatasetCollection(String desc, String dsc_location, Element elem, Namespace ns, StringBuffer errlog) throws IOException {
        Element serviceElem = this.readElements(elem, "service");
        Element dsElem = this.readElements(elem, "dataset");
        Element metaElem = this.readElements(dsElem, "metadata");
        String sts = dsc_location.replaceFirst("dataset.xml", "stations.xml");
        HashMap stationHMap = this.readRadarStations(sts);
        LatLonRect radarRegion = this.readSelectRegion(metaElem, ns);
        List radarTimeSpan = this.readSelectTime(metaElem, ns);
        List productList = this.readSelectVariable(metaElem, ns);
        String summary = this.readSelectDocument(metaElem, ns);
        if (stationHMap == null) {
            errlog.append("TDSRadarDatasetCollection must have station selected");
            return;
        }
        if (radarRegion == null) {
            errlog.append("TDSRadarDatasetCollection must have region selected");
            return;
        }
        if (radarTimeSpan == null) {
            errlog.append("TDSRadarDatasetCollection must have time span selected");
            return;
        }
        this.desc = desc;
        this.dsc_location = dsc_location;
        this.radarProducts = productList;
        this.summary = summary;
        this.stationHMap = stationHMap;
        this.radarRegion = radarRegion;
        this.radarTimeSpan = radarTimeSpan;
        this.startDate = DateUnit.getStandardOrISO((String)radarTimeSpan.get(0));
        this.endDate = DateUnit.getStandardOrISO((String)radarTimeSpan.get(1));
        try {
            this.timeUnit = new DateUnit("hours since 1991-01-01T00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap readRadarStations(String stsXML_location) throws IOException {
        Document doc = null;
        XMLEntityResolver jaxp = new XMLEntityResolver(true);
        SAXBuilder builder = jaxp.getSAXBuilder();
        HashMap<String, Station> stations = new HashMap<String, Station>();
        try {
            doc = builder.build(stsXML_location);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        Element rootElem = doc.getRootElement();
        List children = rootElem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            Station s = this.readStation((Element)children.get(j));
            if (null == s) continue;
            stations.put(s.getName(), s);
        }
        return stations;
    }

    public Element readElements(Element elem, String eleName) {
        List children = elem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            Element child = (Element)children.get(j);
            String childName = child.getName();
            if (!childName.equals(eleName)) continue;
            return child;
        }
        return null;
    }

    private Station readStation(Element elem) {
        String name = elem.getAttributeValue("id");
        Element desc = elem.getChild("name");
        String descv = desc.getValue();
        Element lat = elem.getChild("latitude");
        String latv = lat.getValue();
        Element lon = elem.getChild("longitude");
        String lonv = lon.getValue();
        Element alt = elem.getChild("elevation");
        String altv = alt.getValue();
        StationImpl station = new StationImpl(name, descv, "", Double.parseDouble(latv), Double.parseDouble(lonv), Double.parseDouble(altv));
        return station;
    }

    public LatLonRect readSelectRegion(Element elem, Namespace ns) {
        Element region = elem.getChild("LatLonBox", ns);
        Element north = region.getChild("north", ns);
        String nv = north.getValue();
        Element south = region.getChild("south", ns);
        String sv = south.getValue();
        Element east = region.getChild("east", ns);
        String ev = east.getValue();
        Element west = region.getChild("west", ns);
        String wv = west.getValue();
        LatLonPointImpl p1 = new LatLonPointImpl(Double.valueOf(sv), Double.valueOf(wv));
        LatLonPointImpl p2 = new LatLonPointImpl(Double.valueOf(nv), Double.valueOf(ev));
        LatLonRect llr = new LatLonRect(p1, p2);
        return llr;
    }

    public List readSelectTime(Element elem, Namespace ns) {
        Element region = elem.getChild("TimeSpan", ns);
        List regionInfo = region.getChildren();
        Element start = region.getChild("start", ns);
        String sv = start.getValue();
        Element end = region.getChild("end", ns);
        String ev = end.getValue();
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(sv);
        ll.add(ev);
        return ll;
    }

    public List readSelectVariable(Element elem, Namespace ns) {
        ArrayList<Product> varlist = new ArrayList<Product>();
        Element v = elem.getChild("Variables", ns);
        List varInfo = v.getChildren();
        for (int j = 0; j < varInfo.size(); ++j) {
            Product s;
            Element p = (Element)varInfo.get(j);
            String id = p.getAttributeValue("name");
            if (id.contains("/")) {
                String[] c = id.split("/");
                s = new Product(c[0], c[1]);
                varlist.add(s);
                continue;
            }
            String name = p.getAttributeValue("vocabulary_name");
            s = new Product(id, name);
            varlist.add(s);
        }
        return varlist;
    }

    private String readSelectDocument(Element elem, Namespace ns) {
        Element doc = elem.getChild("documentation", ns);
        return doc.getValue();
    }

    protected void setTimeUnits() {
    }

    protected void setStartDate() {
    }

    protected void setEndDate() {
    }

    protected void setBoundingBox() {
    }

    public String getTitle() {
        return this.summary;
    }

    public String getLocation() {
        return this.dsc_location;
    }

    public String getDescription() {
        return this.desc;
    }

    public LatLonRect getRadarsBoundingBox() {
        return this.radarRegion;
    }

    public List getRadarTimeSpan() {
        return this.radarTimeSpan;
    }

    public List getRadarProducts() {
        return this.radarProducts;
    }

    public boolean checkStationProduct(String sName, Product product) {
        for (int j = 0; j < this.radarProducts.size(); ++j) {
            Product s = (Product)this.radarProducts.get(j);
            if (!s.equals(product)) continue;
            return true;
        }
        return false;
    }

    public boolean checkStationProduct(Product product) {
        return this.checkStationProduct(null, product);
    }

    public int getStationProductCount(String sName) {
        return this.radarProducts.size();
    }

    public List getStations() throws IOException {
        return this.getRadarStations();
    }

    public List getRadarStations() {
        ArrayList<Station> slist = new ArrayList<Station>();
        Iterator<Station> it = this.stationHMap.values().iterator();
        while (it.hasNext()) {
            slist.add(it.next());
        }
        return slist;
    }

    public Station getRadarStation(String sName) {
        return this.stationHMap.get(sName);
    }

    public List getStations(CancelTask cancel) throws IOException {
        return this.getStations(null, cancel);
    }

    public List getStations(LatLonRect boundingBox) throws IOException {
        return this.getStations(boundingBox, null);
    }

    public List getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        List sl = (List)this.stationHMap.values();
        ArrayList<Station> dsl = new ArrayList<Station>();
        if (!boundingBox.containedIn(this.radarRegion)) {
            return null;
        }
        for (Station s : sl) {
            LatLonPointImpl latlonPt = new LatLonPointImpl();
            latlonPt.set(s.getLatitude(), s.getLongitude());
            if (boundingBox.contains(latlonPt)) {
                dsl.add(s);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return dsl;
    }

    public RadialDatasetSweep getRadarDataset(String stnName, Date absTime) throws IOException {
        InvDataset invdata = this.queryRadarStation(stnName, absTime);
        if (invdata == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        ThreddsDataFactory tdFactory = new ThreddsDataFactory();
        ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(invdata, null);
        return (RadialDatasetSweep)result.featureDataset;
    }

    public RadialDatasetSweep getRadarDataset(String stnName, String productID, Date absTime) throws IOException {
        InvDataset invdata = this.queryRadarStation(stnName, productID, absTime);
        if (invdata == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        ThreddsDataFactory tdFactory = new ThreddsDataFactory();
        ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(invdata, null);
        return (RadialDatasetSweep)result.featureDataset;
    }

    public URI getRadarDatasetURI(String stnName, Date absTime) throws IOException {
        InvDataset invdata = this.queryRadarStation(stnName, absTime);
        List<InvAccess> acess = invdata.getAccess();
        InvAccess ia = acess.get(0);
        URI ui = ia.getStandardUri();
        if (ui == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        return ui;
    }

    private InvDataset queryRadarStation(String stnName, Date absTime) throws IOException {
        return this.queryRadarStation(stnName, (String)null, absTime);
    }

    private InvDataset queryRadarStation(String stnName, String productID, Date absTime) throws IOException {
        URI catalogURI;
        String stime = DateUtil.getTimeAsISO8601(absTime).replaceAll("GMT", "");
        StringBuffer queryb = new StringBuffer();
        String baseURI = this.dsc_location.replaceFirst("/dataset.xml", "?");
        queryb.append(baseURI);
        queryb.append("&stn=" + stnName);
        if (productID != null) {
            queryb.append("&var=" + productID);
        }
        if (absTime == null) {
            queryb.append("&time=present");
        } else {
            queryb.append("&time=" + stime);
        }
        try {
            catalogURI = new URI(queryb.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException("** MalformedURLException on URL <>\n" + e.getMessage() + "\n");
        }
        InvCatalogFactory factory = new InvCatalogFactory("default", false);
        InvCatalogImpl catalog = factory.readXML(catalogURI);
        StringBuilder buff = new StringBuilder();
        if (!catalog.check(buff)) {
            throw new IOException("Invalid catalog <" + catalogURI + ">\n" + buff.toString());
        }
        List<InvDataset> datasets = catalog.getDatasets();
        InvDataset idata = datasets.get(0);
        ArrayList dsets = (ArrayList)idata.getDatasets();
        InvDataset tdata = (InvDataset)dsets.get(0);
        return tdata;
    }

    public URI getRadarDatasetURI(String stnName, String productID, Date absTime) throws IOException {
        if (productID == null) {
            return this.getRadarDatasetURI(stnName, absTime);
        }
        InvDataset invdata = this.queryRadarStation(stnName, productID, absTime);
        List<InvAccess> acess = invdata.getAccess();
        InvAccess ia = acess.get(0);
        URI ui = ia.getStandardUri();
        if (ui == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        return ui;
    }

    private TDSRadarDatasetInfo queryRadarStation(String stnName, Date start, Date end) throws IOException {
        return this.queryRadarStation(stnName, null, start, end);
    }

    private TDSRadarDatasetInfo queryRadarStation(String stnName, String productID, Date start, Date end) throws IOException {
        URI catalogURI;
        String stime;
        StringBuffer queryb = new StringBuffer();
        String baseURI = this.dsc_location.replaceFirst("/dataset.xml", "?");
        queryb.append(baseURI);
        queryb.append("&stn=" + stnName);
        if (productID != null) {
            queryb.append("&var=" + productID);
        }
        if (start == null && end == null) {
            queryb.append("&time=present");
        } else if (end == null) {
            stime = DateUtil.getTimeAsISO8601(start).replaceAll("GMT", "");
            queryb.append("&time_start=" + stime);
            queryb.append("&time_end=present");
        } else {
            stime = DateUtil.getTimeAsISO8601(start).replaceAll("GMT", "");
            String etime = DateUtil.getTimeAsISO8601(end).replaceAll("GMT", "");
            queryb.append("&time_start=" + stime);
            queryb.append("&time_end=" + etime);
        }
        try {
            catalogURI = new URI(queryb.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException("** MalformedURLException on URL <>\n" + e.getMessage() + "\n");
        }
        InvCatalogFactory factory = new InvCatalogFactory("default", false);
        InvCatalogImpl catalog = factory.readXML(catalogURI);
        StringBuilder buff = new StringBuilder();
        if (!catalog.check(buff)) {
            throw new IOException("Invalid catalog <" + catalogURI + ">\n" + buff.toString());
        }
        List<InvDataset> datasets = catalog.getDatasets();
        InvDataset idata = datasets.get(0);
        ArrayList dsets = (ArrayList)idata.getDatasets();
        ArrayList<Date> absTimeList = new ArrayList<Date>();
        ArrayList<DatasetURIInfo> dURIList = new ArrayList<DatasetURIInfo>();
        ArrayList<InvDatasetInfo> dInvList = new ArrayList<InvDatasetInfo>();
        for (int i = 0; i < dsets.size(); ++i) {
            InvDataset tdata = (InvDataset)dsets.get(i);
            List<InvAccess> acess = tdata.getAccess();
            List<DateType> dates = tdata.getDates();
            InvAccess ia = acess.get(0);
            URI d = ia.getStandardUri();
            Date date = DateUnit.getStandardOrISO(((Object)dates.get(0)).toString());
            absTimeList.add(date);
            dURIList.add(new DatasetURIInfo(d, date));
            dInvList.add(new InvDatasetInfo(tdata, date));
        }
        TDSRadarDatasetInfo dri = new TDSRadarDatasetInfo(absTimeList, dURIList, dInvList);
        return dri;
    }

    public ArrayList getRadarStationURIs(String stnName, Date start, Date end) throws IOException {
        TDSRadarDatasetInfo dri = this.queryRadarStation(stnName, start, end);
        ArrayList uList = dri.getURIList();
        int size = uList.size();
        ArrayList<URI> datasetsURI = new ArrayList<URI>();
        for (int i = 0; i < size; ++i) {
            DatasetURIInfo du = (DatasetURIInfo)uList.get(i);
            datasetsURI.add(du.uri);
        }
        return datasetsURI;
    }

    public ArrayList getRadarStationDatasets(String stnName, Date start, Date end) throws IOException {
        ArrayList<FeatureDataset> datasetList = new ArrayList<FeatureDataset>();
        TDSRadarDatasetInfo dri = this.queryRadarStation(stnName, start, end);
        ArrayList iList = dri.getInvList();
        int size = iList.size();
        for (int i = 0; i < size; ++i) {
            InvDatasetInfo iv = (InvDatasetInfo)iList.get(i);
            InvDataset tdata = iv.inv;
            ThreddsDataFactory tdFactory = new ThreddsDataFactory();
            ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(tdata, null);
            datasetList.add(result.featureDataset);
        }
        return datasetList;
    }

    public ArrayList getRadarStationTimes(String stnName, Date start, Date end) throws IOException {
        return this.getRadarStationTimes(stnName, null, start, end);
    }

    public ArrayList getRadarStationTimes(String stnName, String productID, Date start, Date end) throws IOException {
        TDSRadarDatasetInfo dri = this.queryRadarStation(stnName, productID, start, end);
        return dri.absTimeList;
    }

    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return null;
    }

    private List queryRadarStationRTimes(String stn) throws IOException {
        return this.radarTimeSpan;
    }

    public ArrayList getDataURIs(String sName, DateSelection dateInfo) throws IOException {
        return this.getDataURIs(sName, dateInfo, null);
    }

    public ArrayList getData(String sName, DateSelection dateInfo) throws IOException {
        return this.getData(sName, dateInfo, null);
    }

    public ArrayList getData(String sName, DateSelection dateSelect, CancelTask cancel) throws IOException {
        if (cancel != null && cancel.isCancel()) {
            return null;
        }
        TDSRadarDatasetInfo dri = this.queryRadarStation(sName, dateSelect.getStartFixedDate(), dateSelect.getEndFixedDate());
        ArrayList<FeatureDataset> datasetList = new ArrayList<FeatureDataset>();
        List datasetINVs = dateSelect.apply(dri.getInvList());
        for (InvDatasetInfo ifo : datasetINVs) {
            InvDataset tdata = ifo.inv;
            ThreddsDataFactory tdFactory = new ThreddsDataFactory();
            ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(tdata, null);
            datasetList.add(result.featureDataset);
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return datasetList;
    }

    public ArrayList getDataURIs(String sName, DateSelection dateSelect, CancelTask cancel) throws IOException {
        if (cancel != null && cancel.isCancel()) {
            return null;
        }
        TDSRadarDatasetInfo dri = this.queryRadarStation(sName, dateSelect.getStartFixedDate(), dateSelect.getEndFixedDate());
        List datasetsURIs = dateSelect.apply(dri.getURIList());
        ArrayList<URI> uriList = new ArrayList<URI>();
        for (DatasetURIInfo ufo : datasetsURIs) {
            URI u = ufo.uri;
            uriList.add(u);
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return uriList;
    }

    public static long roundTo(long roundTo, long seconds) {
        int roundToSeconds = (int)roundTo;
        if (roundToSeconds == 0) {
            return seconds;
        }
        return seconds - (long)((int)seconds % roundToSeconds);
    }

    public static void main(String[] args) throws IOException {
        StringBuffer errlog = new StringBuffer();
        String ds_location = null;
        TDSRadarDatasetCollection dsc = null;
        List stns = null;
        ds_location = "http://motherlode.ucar.edu:8080/thredds/radarServer/nexrad/level3/CCS039/dataset.xml";
        dsc = TDSRadarDatasetCollection.factory("test", ds_location, errlog);
        System.out.println(" errs= " + errlog);
        stns = dsc.getStations();
        System.out.println(" nstns= " + stns.size());
        stns = dsc.getStations();
        System.out.println(" nstns= " + stns.size());
        Station stn = dsc.getRadarStation("DVN");
        List tl = dsc.getRadarTimeSpan();
        Date ts1 = DateUnit.getStandardOrISO("1998-06-28T01:01:21Z");
        Date ts2 = DateUnit.getStandardOrISO("1998-07-30T19:01:21Z");
        List pd = dsc.getRadarProducts();
        ArrayList tlist = dsc.getRadarStationTimes(stn.getName(), "BREF1", new Date(ts1.getTime()), new Date(ts2.getTime()));
        int sz = tlist.size();
        for (int i = 0; i < 3; ++i) {
            Date ts0 = (Date)tlist.get(i);
            RadialDatasetSweep rds = dsc.getRadarDataset(stn.getName(), "BREF1", ts0);
            boolean tt = false;
        }
        Date ts0 = (Date)tlist.get(0);
        URI stURL = dsc.getRadarDatasetURI(stn.getName(), ts0);
        assert (null != stURL);
        DateSelection dateS = new DateSelection(ts1, ts2);
        dateS.setInterval(3600000.0);
        dateS.setRoundTo(3600000.0);
        dateS.setPreRange(500000.0);
        dateS.setPostRange(500000.0);
        for (int i = 0; i < stns.size(); ++i) {
            stn = (Station)stns.get(i);
            ArrayList times = dsc.getRadarStationTimes(stn.getName(), new Date(System.currentTimeMillis() - 50065408L), new Date(System.currentTimeMillis()));
            if (times.size() > 0) {
                System.err.println(stn + " times:" + times.size() + " " + times.get(0) + " - " + times.get(times.size() - 1));
                continue;
            }
            System.err.println(stn + " no times");
        }
        ArrayList jList = dsc.getDataURIs("KABX", dateS);
        assert (null != jList);
        ArrayList mList = dsc.getData("KABX", dateS, null);
        assert (null != mList);
        Date ts = (Date)tlist.get(1);
        SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String st = isoDateTimeFormat.format(ts);
    }

    public class TDSRadarDatasetInfo {
        private ArrayList absTimeList;
        private ArrayList datasetInfoList;
        private ArrayList invDatasetList;

        public TDSRadarDatasetInfo() {
        }

        public TDSRadarDatasetInfo(ArrayList absTimeList, ArrayList datasetInfoList, ArrayList invDatasetList) {
            this.absTimeList = absTimeList;
            this.datasetInfoList = datasetInfoList;
            this.invDatasetList = invDatasetList;
        }

        public ArrayList getTimeList() {
            return this.absTimeList;
        }

        public ArrayList getURIList() {
            return this.datasetInfoList;
        }

        public ArrayList getInvList() {
            return this.invDatasetList;
        }
    }

    public class InvDatasetInfo
    implements DatedThing {
        private InvDataset inv = null;
        private Date date = null;

        public InvDatasetInfo(InvDataset u, Date date) {
            this.inv = u;
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }
    }

    public class DatasetURIInfo
    implements DatedThing {
        private URI uri = null;
        private Date date = null;

        public DatasetURIInfo(URI u, Date date) {
            this.uri = u;
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

