/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.DatedThing;

public class DateSelection {
    public boolean debug = false;
    public static final int TIMEMODE_FIXED = 0;
    public static final int TIMEMODE_CURRENT = 1;
    public static final int TIMEMODE_RELATIVE = 2;
    public static final int TIMEMODE_DATA = 3;
    public static int[] TIMEMODES = new int[]{0, 1, 2};
    public static String[] STARTMODELABELS = new String[]{"Fixed", "Current Time (Now)", "Relative to End Time  "};
    public static String[] ENDMODELABELS = new String[]{"Fixed", "Current Time (Now)", "Relative to Start Time"};
    private int startMode = 0;
    private int endMode = 0;
    private long startFixedTime = Long.MAX_VALUE;
    private long endFixedTime = Long.MAX_VALUE;
    private double startOffset = 0.0;
    private double endOffset = 0.0;
    private int skip = 0;
    private double preRange = Double.NaN;
    private double postRange = Double.NaN;
    private double interval = Double.NaN;
    private double roundTo = 0.0;
    private int count = Integer.MAX_VALUE;
    public static final int MAX_COUNT = Integer.MAX_VALUE;
    private int numTimesInRange = 1;
    private List times;
    private boolean doLatest = false;
    private boolean doAll = false;
    private Date nowTime;

    public DateSelection() {
    }

    public DateSelection(boolean doLatest, int count) {
        this.doLatest = doLatest;
        this.count = count;
    }

    public DateSelection(boolean doAll) {
        this.doAll = doAll;
    }

    public DateSelection(int startMode, double startOffset, int endMode, double endOffset) {
        this.startMode = startMode;
        this.startOffset = startOffset;
        this.endMode = endMode;
        this.endOffset = endOffset;
    }

    public DateSelection(Date startTime, Date endTime) {
        if (startTime != null) {
            this.startFixedTime = startTime.getTime();
        }
        if (endTime != null) {
            this.endFixedTime = endTime.getTime();
        }
        this.startMode = 0;
        this.endMode = 0;
        this.interval = 0.0;
    }

    public DateSelection(DateSelection that) {
        this.startMode = that.startMode;
        this.endMode = that.endMode;
        this.startFixedTime = that.startFixedTime;
        this.endFixedTime = that.endFixedTime;
        this.doLatest = that.doLatest;
        this.nowTime = that.nowTime;
        this.startOffset = that.startOffset;
        this.endOffset = that.endOffset;
        this.skip = that.skip;
        this.postRange = that.postRange;
        this.preRange = that.preRange;
        this.interval = that.interval;
        this.roundTo = that.roundTo;
        this.count = that.count;
    }

    public double[] getIntervalTicks() {
        Date[] range = this.getRange();
        long startTime = range[0].getTime();
        long endTime = range[1].getTime();
        double tickStartTime = (double)startTime - this.interval;
        double tickEndTime = (double)endTime + this.interval;
        double base = this.round(tickEndTime);
        return DateSelection.computeTicks(tickEndTime, tickStartTime, base, this.interval);
    }

    public List apply(List datedThings) {
        DatedThing datedThing;
        int i;
        datedThings = DatedObject.sort(datedThings, false);
        ArrayList<DatedThing> result = new ArrayList<DatedThing>();
        Date[] range = this.getRange();
        long startTime = range[0].getTime();
        long endTime = range[1].getTime();
        boolean hasInterval = this.hasInterval();
        double beforeRange = this.getPreRangeToUse();
        double afterRange = this.getPostRangeToUse();
        if (this.debug) {
            System.err.println("range:" + range[0] + " -- " + range[1]);
        }
        double[] ticks = null;
        if (hasInterval) {
            ticks = this.getIntervalTicks();
            if (ticks == null) {
                return result;
            }
            for (int i2 = 0; i2 < ticks.length; ++i2) {
                if (!this.debug) continue;
                System.err.println("Interval " + i2 + ": " + new Date((long)(ticks[i2] - beforeRange)) + " -- " + new Date((long)ticks[i2]) + " -- " + new Date((long)(ticks[i2] + afterRange)));
            }
        }
        int totalThings = 0;
        DatedThing[] closest = null;
        double[] minDistance = null;
        int currentInterval = 0;
        if (ticks != null) {
            closest = new DatedThing[ticks.length];
            minDistance = new double[ticks.length];
            currentInterval = ticks.length - 1;
        }
        int skipCnt = 0;
        for (i = 0; i < datedThings.size() && (!hasInterval || totalThings < this.count || this.skip > 0 && totalThings / (this.skip + 1) < this.count); ++i) {
            boolean thingInInterval;
            datedThing = (DatedThing)datedThings.get(i);
            long time = datedThing.getDate().getTime();
            if (time > endTime) {
                if (!this.debug) continue;
                System.err.println("after range:" + datedThing);
                continue;
            }
            if (time < startTime) {
                if (!this.debug) break;
                System.err.println("before range:" + datedThing);
                break;
            }
            if (!hasInterval) {
                if (this.skip == 0) {
                    result.add(datedThing);
                } else {
                    if (skipCnt == 0) {
                        result.add(datedThing);
                    }
                    if (++skipCnt >= this.skip + 1) {
                        skipCnt = 0;
                    }
                }
                if (result.size() < this.count) continue;
                break;
            }
            while (currentInterval >= 0 && ticks[currentInterval] - beforeRange > (double)time) {
                --currentInterval;
            }
            if (currentInterval < 0) break;
            boolean bl = thingInInterval = (double)time >= ticks[currentInterval] - beforeRange && (double)time <= ticks[currentInterval] + afterRange;
            if (!thingInInterval) {
                if (!this.debug) continue;
                System.err.println("Not in interval:" + datedThing);
                continue;
            }
            double distance = Math.abs((double)time - ticks[currentInterval]);
            if (closest[currentInterval] != null && !(distance < minDistance[currentInterval])) continue;
            if (closest[currentInterval] == null) {
                ++totalThings;
            }
            closest[currentInterval] = datedThing;
            minDistance[currentInterval] = distance;
        }
        if (closest != null) {
            skipCnt = 0;
            for (i = closest.length - 1; i >= 0; --i) {
                datedThing = closest[i];
                if (datedThing == null) continue;
                if (this.skip == 0) {
                    result.add(datedThing);
                    continue;
                }
                if (skipCnt == 0) {
                    result.add(datedThing);
                }
                if (++skipCnt < this.skip + 1) continue;
                skipCnt = 0;
            }
        }
        return result;
    }

    private static double[] computeTicks(double high, double low, double base, double interval) {
        double[] vals = null;
        long nlo = Math.round(Math.ceil((low - base) / Math.abs(interval)));
        long nhi = Math.round(Math.floor((high - base) / Math.abs(interval)));
        int numc = (int)(nhi - nlo) + 1;
        if (numc < 1) {
            return vals;
        }
        vals = new double[numc];
        for (int i = 0; i < numc; ++i) {
            vals[i] = base + (double)(nlo + (long)i) * interval;
        }
        return vals;
    }

    public Date[] getRange() {
        if (this.doLatest) {
            return null;
        }
        if (this.doAll) {
            return null;
        }
        double now = this.nowTime != null ? this.nowTime.getTime() : System.currentTimeMillis();
        double start = 0.0;
        double end = 0.0;
        if (this.startMode == 1) {
            start = now;
        } else if (this.startMode == 0) {
            start = this.startFixedTime;
        }
        if (this.endMode == 1) {
            end = now;
        } else if (this.endMode == 0) {
            end = this.endFixedTime;
        }
        if (this.startMode != 2) {
            start += this.startOffset;
        }
        if (this.endMode != 2) {
            end += this.endOffset;
        }
        if (this.startMode == 2) {
            start = end + this.startOffset;
        }
        if (this.endMode == 2) {
            end = start + this.endOffset;
        }
        Date startDate = new Date((long)start);
        Date endDate = new Date((long)end);
        return new Date[]{startDate, endDate};
    }

    private double round(double milliSeconds) {
        return DateSelection.roundTo(this.roundTo, milliSeconds);
    }

    public static double roundTo(double roundTo, double milliSeconds) {
        if (roundTo == 0.0) {
            return milliSeconds;
        }
        double seconds = milliSeconds / 1000.0;
        double rtSeconds = roundTo / 1000.0;
        return 1000.0 * (seconds - (double)((int)seconds) % rtSeconds);
    }

    protected Object makeTimeSet() {
        return null;
    }

    public void setStartMode(int value) {
        this.startMode = value;
    }

    public int getStartMode() {
        return this.startMode;
    }

    public void setEndMode(int value) {
        this.endMode = value;
    }

    public int getEndMode() {
        return this.endMode;
    }

    public boolean hasInterval() {
        return this.interval > 0.0;
    }

    public boolean hasPreRange() {
        return this.preRange == this.preRange;
    }

    public boolean hasPostRange() {
        return this.postRange == this.postRange;
    }

    public void setInterval(double value) {
        this.interval = value;
    }

    public double getInterval() {
        return this.interval;
    }

    public void setStartOffset(double value) {
        this.startOffset = value;
    }

    public double getStartOffset() {
        return this.startOffset;
    }

    public void setEndOffset(double value) {
        this.endOffset = value;
    }

    public double getEndOffset() {
        return this.endOffset;
    }

    public void setRoundTo(double value) {
        this.roundTo = value;
    }

    public double getRoundTo() {
        return this.roundTo;
    }

    public void setStartFixedTime(long value) {
        this.startFixedTime = value;
    }

    public void setStartFixedTime(Date d) {
        this.startFixedTime = d.getTime();
        this.startMode = 0;
    }

    public void setEndFixedTime(Date d) {
        this.endFixedTime = d.getTime();
        this.endMode = 0;
    }

    public Date getStartFixedDate() {
        return new Date(this.getStartFixedTime());
    }

    public Date getEndFixedDate() {
        return new Date(this.getEndFixedTime());
    }

    public long getStartFixedTime() {
        return this.startFixedTime;
    }

    public void setEndFixedTime(long value) {
        this.endFixedTime = value;
    }

    public long getEndFixedTime() {
        return this.endFixedTime;
    }

    public void setIntervalRange(double value) {
        this.setPreRange(value / 2.0);
        this.setPostRange(value / 2.0);
    }

    public void setPreRange(double value) {
        this.preRange = value;
    }

    public double getPreRangeToUse() {
        return this.hasPreRange() ? this.preRange : this.interval / 2.0;
    }

    public double getPostRangeToUse() {
        return this.hasPostRange() ? this.postRange : this.interval / 2.0;
    }

    public double getPreRange() {
        return this.preRange;
    }

    public void setPostRange(double value) {
        this.postRange = value;
    }

    public double getPostRange() {
        return this.postRange;
    }

    public void setCount(int value) {
        this.count = value;
    }

    public boolean hasCount() {
        return this.count != Integer.MAX_VALUE;
    }

    public int getCount() {
        return this.count;
    }

    public void setNumTimesInRange(int value) {
        this.numTimesInRange = value;
    }

    public int getNumTimesInRange() {
        return this.numTimesInRange;
    }

    public void setTimes(List value) {
        this.times = value;
    }

    public List getTimes() {
        return this.times;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.times != null) {
            hashCode ^= ((Object)this.times).hashCode();
        }
        return hashCode ^ new Double(this.startMode).hashCode() ^ new Double(this.endMode).hashCode() ^ new Double(this.startFixedTime).hashCode() ^ new Double(this.endFixedTime).hashCode() ^ new Double(this.startOffset).hashCode() ^ new Double(this.endOffset).hashCode() ^ new Double(this.skip).hashCode() ^ new Double(this.postRange).hashCode() ^ new Double(this.preRange).hashCode() ^ new Double(this.interval).hashCode() ^ new Double(this.roundTo).hashCode() ^ this.numTimesInRange ^ this.count;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateSelection)) {
            return false;
        }
        DateSelection that = (DateSelection)o;
        if (this.times != that.times) {
            return false;
        }
        if (this.times != null && !((Object)this.times).equals(that.times)) {
            return false;
        }
        return this.startMode == that.startMode && this.endMode == that.endMode && this.startFixedTime == that.startFixedTime && this.endFixedTime == that.endFixedTime && this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.skip == that.skip && this.postRange == that.postRange && this.preRange == that.preRange && this.interval == that.interval && this.roundTo == that.roundTo && this.numTimesInRange == that.numTimesInRange && this.count == that.count;
    }

    public void setSkip(int value) {
        this.skip = value;
    }

    public int getSkip() {
        return this.skip;
    }

    private void testRange(String msg) {
        Date[] range = this.getRange();
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(range[0] + " --  " + range[1]);
    }

    public void setDoLatest(boolean value) {
        this.doLatest = value;
    }

    public boolean isLatest() {
        return this.doLatest;
    }

    public boolean getDoLatest() {
        return this.doLatest;
    }

    public void setDoAll(boolean value) {
        this.doAll = value;
    }

    public boolean isAll() {
        return this.doAll;
    }

    public boolean getDoAll() {
        return this.doAll;
    }

    public void setNowTime(Date value) {
        this.nowTime = value;
    }

    public Date getNowTime() {
        return this.nowTime;
    }

    public static void main(String[] args) {
        DateSelection dateSelection = new DateSelection();
        List<DatedObject> dates = new ArrayList<DatedObject>();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 20; ++i) {
            dates.add(new DatedObject(new Date(now + DateUtil.minutesToMillis(20.0) - (long)(i * 10 * 60 * 1000))));
        }
        dateSelection.setEndMode(0);
        dateSelection.setEndFixedTime(now);
        dateSelection.setStartMode(2);
        dateSelection.setStartOffset(DateUtil.hoursToMillis(-2.0));
        dateSelection.setRoundTo(DateUtil.hoursToMillis(12.0));
        dateSelection.setInterval(DateUtil.minutesToMillis(15.0));
        dateSelection.setIntervalRange(DateUtil.minutesToMillis(6.0));
        dates = dateSelection.apply(dates);
        System.err.println("result:" + dates);
    }

    public String toString() {
        return " startMode      =" + this.startMode + "\n" + " endMode        =" + this.endMode + "\n" + " startFixedTime =" + this.startFixedTime + "\n" + " endFixedTime   =" + this.endFixedTime + "\n" + " startOffset    =" + this.startOffset + "\n" + " endOffset      =" + this.endOffset + "\n" + " postRange      =" + this.postRange + "\n" + " preRange       =" + this.preRange + "\n" + " interval       =" + this.interval + "\n" + " roundTo        =" + this.roundTo + "\n" + " count          =" + this.count + "\n";
    }
}

