/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.ConversionException;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.MultiplyException;
import ucar.units.OperationException;
import ucar.units.RaiseException;
import ucar.units.Unit;
import ucar.units.UnitImpl;
import ucar.units.UnitName;

public final class OffsetUnit
extends UnitImpl
implements DerivableUnit {
    private static final long serialVersionUID = 1L;
    private final double _offset;
    private final Unit _unit;
    private DerivedUnit _derivedUnit;

    public OffsetUnit(Unit unit, double offset) {
        this(unit, offset, null);
    }

    public OffsetUnit(Unit unit, double offset, UnitName id) {
        super(id);
        if (!(unit instanceof OffsetUnit)) {
            this._unit = unit;
            this._offset = offset;
        } else {
            this._unit = ((OffsetUnit)unit)._unit;
            this._offset = ((OffsetUnit)unit)._offset + offset;
        }
    }

    static Unit getInstance(Unit unit, double origin) {
        return origin == 0.0 ? unit : new OffsetUnit(unit, origin);
    }

    public Unit getUnit() {
        return this._unit;
    }

    public double getOffset() {
        return this._offset;
    }

    public Unit clone(UnitName id) {
        return new OffsetUnit(this.getUnit(), this.getOffset(), id);
    }

    public Unit multiplyBy(double scale) throws MultiplyException {
        if (scale == 0.0) {
            throw new MultiplyException(scale, (Unit)this);
        }
        return OffsetUnit.getInstance(this._unit.multiplyBy(scale), this._offset / scale);
    }

    public Unit shiftTo(double origin) {
        return OffsetUnit.getInstance(this._unit, origin + this._offset);
    }

    protected Unit myMultiplyBy(Unit that) throws MultiplyException {
        return that instanceof OffsetUnit ? this.getUnit().multiplyBy(((OffsetUnit)that).getUnit()) : this.getUnit().multiplyBy(that);
    }

    protected Unit myDivideBy(Unit that) throws OperationException {
        return that instanceof OffsetUnit ? this.getUnit().divideBy(((OffsetUnit)that).getUnit()) : this.getUnit().divideBy(that);
    }

    protected Unit myDivideInto(Unit that) throws OperationException {
        return that instanceof OffsetUnit ? this.getUnit().divideInto(((OffsetUnit)that).getUnit()) : this.getUnit().divideInto(that);
    }

    protected Unit myRaiseTo(int power) throws RaiseException {
        return this.getUnit().raiseTo(power);
    }

    public DerivedUnit getDerivedUnit() {
        if (this._derivedUnit == null) {
            this._derivedUnit = this.getUnit().getDerivedUnit();
        }
        return this._derivedUnit;
    }

    public float toDerivedUnit(float amount) throws ConversionException {
        return (float)this.toDerivedUnit((double)amount);
    }

    public double toDerivedUnit(double amount) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        return ((DerivableUnit)((Object)this.getUnit())).toDerivedUnit(amount + this.getOffset());
    }

    public float[] toDerivedUnit(float[] input, float[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        float origin = (float)this.getOffset();
        int i = input.length;
        while (--i >= 0) {
            output[i] = input[i] + origin;
        }
        return ((DerivableUnit)((Object)this.getUnit())).toDerivedUnit(output, output);
    }

    public double[] toDerivedUnit(double[] input, double[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        double origin = this.getOffset();
        int i = input.length;
        while (--i >= 0) {
            output[i] = input[i] + origin;
        }
        return ((DerivableUnit)((Object)this.getUnit())).toDerivedUnit(output, output);
    }

    public float fromDerivedUnit(float amount) throws ConversionException {
        return (float)this.fromDerivedUnit((double)amount);
    }

    public double fromDerivedUnit(double amount) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        return ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(amount) - this.getOffset();
    }

    public float[] fromDerivedUnit(float[] input, float[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(input, output);
        float origin = (float)this.getOffset();
        int i = input.length;
        while (--i >= 0) {
            int n = i;
            output[n] = output[n] - origin;
        }
        return output;
    }

    public double[] fromDerivedUnit(double[] input, double[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(input, output);
        double origin = this.getOffset();
        int i = input.length;
        while (--i >= 0) {
            int n = i;
            output[n] = output[n] - origin;
        }
        return output;
    }

    public boolean equals(Object object) {
        return object instanceof OffsetUnit ? super.equals(object) && this.getOffset() == ((OffsetUnit)object).getOffset() && ((Object)this.getUnit()).equals(((OffsetUnit)object).getUnit()) : this.getOffset() == 0.0 && ((Object)this.getUnit()).equals(object);
    }

    public int hashCode() {
        return super.hashCode() ^ (this.getOffset() == 0.0 ? 0 : Double.valueOf(this.getOffset()).hashCode()) ^ this.getUnit().hashCode();
    }

    public boolean isDimensionless() {
        return this.getUnit().isDimensionless();
    }

    public String toString() {
        String string = super.toString();
        return string != null ? string : this.getCanonicalString();
    }

    public String getCanonicalString() {
        return "(" + ((Object)this.getUnit()).toString() + ") @ " + this.getOffset();
    }

    public static void main(String[] args) throws Exception {
        BaseUnit kelvin = BaseUnit.getOrCreate(UnitName.newUnitName("kelvin", null, "K"), BaseQuantity.THERMODYNAMIC_TEMPERATURE);
        OffsetUnit celsius = new OffsetUnit(kelvin, 273.15);
        System.out.println("celsius.equals(kelvin)=" + celsius.equals(kelvin));
        System.out.println("celsius.getUnit().equals(kelvin)=" + ((Object)celsius.getUnit()).equals(kelvin));
        Unit celsiusKelvin = celsius.multiplyBy(kelvin);
        System.out.println("celsiusKelvin.divideBy(celsius)=" + celsiusKelvin.divideBy(celsius));
        System.out.println("celsius.divideBy(kelvin)=" + celsius.divideBy(kelvin));
        System.out.println("kelvin.divideBy(celsius)=" + kelvin.divideBy(celsius));
        System.out.println("celsius.raiseTo(2)=" + celsius.raiseTo(2));
        System.out.println("celsius.toDerivedUnit(1.)=" + celsius.toDerivedUnit(1.0));
        System.out.println("celsius.toDerivedUnit(new float[]{1,2,3}, new float[3])[1]=" + celsius.toDerivedUnit(new float[]{1.0f, 2.0f, 3.0f}, new float[3])[1]);
        System.out.println("celsius.fromDerivedUnit(274.15)=" + celsius.fromDerivedUnit(274.15));
        System.out.println("celsius.fromDerivedUnit(new float[]{274.15f},new float[1])[0]=" + celsius.fromDerivedUnit(new float[]{274.15f}, new float[1])[0]);
        System.out.println("celsius.equals(celsius)=" + celsius.equals(celsius));
        OffsetUnit celsius100 = new OffsetUnit(celsius, 100.0);
        System.out.println("celsius.equals(celsius100)=" + celsius.equals(celsius100));
        System.out.println("celsius.isDimensionless()=" + celsius.isDimensionless());
        BaseUnit radian = BaseUnit.getOrCreate(UnitName.newUnitName("radian", null, "rad"), BaseQuantity.PLANE_ANGLE);
        OffsetUnit offRadian = new OffsetUnit(radian, 1.570795);
        System.out.println("offRadian.isDimensionless()=" + offRadian.isDimensionless());
    }
}

