/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;

public class FrameBodyRVAD
extends AbstractID3v2FrameBody {
    byte bytesUsed = (byte)16;
    byte increment = 0;
    long peakBass = 0L;
    long peakCenter = 0L;
    long peakLeft = 0L;
    long peakLeftBack = 0L;
    long peakRight = 0L;
    long peakRightBack = 0L;
    long relativeBass = 0L;
    long relativeCenter = 0L;
    long relativeLeft = 0L;
    long relativeLeftBack = 0L;
    long relativeRight = 0L;
    long relativeRightBack = 0L;

    public FrameBodyRVAD() {
    }

    public FrameBodyRVAD(FrameBodyRVAD copyObject) {
        super(copyObject);
        this.bytesUsed = copyObject.bytesUsed;
        this.increment = copyObject.increment;
        this.peakBass = copyObject.peakBass;
        this.peakCenter = copyObject.peakCenter;
        this.peakLeft = copyObject.peakLeft;
        this.peakLeftBack = copyObject.peakLeftBack;
        this.peakRight = copyObject.peakRight;
        this.peakRightBack = copyObject.peakRightBack;
        this.relativeBass = copyObject.relativeBass;
        this.relativeCenter = copyObject.relativeCenter;
        this.relativeLeft = copyObject.relativeLeft;
        this.relativeLeftBack = copyObject.relativeLeftBack;
        this.relativeRight = copyObject.relativeRight;
        this.relativeRightBack = copyObject.relativeRightBack;
    }

    public FrameBodyRVAD(byte increment, byte bitsUsed, long relativeRight, long relativeLeft, long peakRight, long peakLeft, long relativeRightBack, long relativeLeftBack, long peakRightBack, long peakLeftBack, long relativeCenter, long peakCenter, long relativeBass, long peakBass) {
        this.increment = increment;
        this.bytesUsed = (byte)((bitsUsed - 1) / 8 + 1);
        this.relativeRight = relativeRight;
        this.relativeLeft = relativeLeft;
        this.peakRight = peakRight;
        this.peakLeft = peakLeft;
        this.relativeRightBack = relativeRightBack;
        this.relativeLeftBack = relativeLeftBack;
        this.peakRightBack = peakRightBack;
        this.peakLeftBack = peakLeftBack;
        this.relativeCenter = relativeCenter;
        this.peakCenter = peakCenter;
        this.relativeBass = relativeBass;
        this.peakBass = peakBass;
    }

    public FrameBodyRVAD(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public String getIdentifier() {
        return "RVAD";
    }

    public int getSize() {
        int size = 2 + this.bytesUsed * 4;
        if (this.relativeRightBack != 0L || this.relativeLeftBack != 0L || this.peakRightBack != 0L || this.peakLeftBack != 0L) {
            size += this.bytesUsed * 4;
        }
        if (this.relativeCenter != 0L || this.peakCenter != 0L) {
            size += this.bytesUsed * 2;
        }
        if (this.relativeBass != 0L || this.peakBass != 0L) {
            size += this.bytesUsed * 2;
        }
        return size;
    }

    public void equals() {
        throw new UnsupportedOperationException("Method equals() not yet implemented.");
    }

    protected void setupObjectList() {
        throw new UnsupportedOperationException();
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        int i;
        int offset = 0;
        int size = this.readHeader(file);
        byte[] buffer = new byte[size];
        file.read(buffer);
        this.increment = buffer[offset++];
        this.bytesUsed = (byte)((buffer[offset++] - 1) / 8 * 8 + 1);
        for (i = 0; i < this.bytesUsed; ++i) {
            this.relativeRight = (this.relativeRight << 8) + (long)buffer[i + offset];
        }
        offset += this.bytesUsed;
        for (i = 0; i < this.bytesUsed; ++i) {
            this.relativeLeft = (this.relativeLeft << 8) + (long)buffer[i + offset];
        }
        offset += this.bytesUsed;
        for (i = 0; i < this.bytesUsed; ++i) {
            this.peakRight = (this.peakRight << 8) + (long)buffer[i + offset];
        }
        offset += this.bytesUsed;
        for (i = 0; i < this.bytesUsed; ++i) {
            this.peakLeft = (this.peakLeft << 8) + (long)buffer[i + offset];
        }
        offset += this.bytesUsed;
        if (size > 2 + this.bytesUsed * 4) {
            for (i = 0; i < this.bytesUsed; ++i) {
                this.relativeRightBack = (this.relativeRightBack << 8) + (long)buffer[i + offset];
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                this.relativeLeftBack = (this.relativeLeftBack << 8) + (long)buffer[i + offset];
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                this.peakRightBack = (this.peakRightBack << 8) + (long)buffer[i + offset];
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                this.peakLeftBack = (this.peakLeftBack << 8) + (long)buffer[i + offset];
            }
            offset += this.bytesUsed;
        }
        if (size > 2 + this.bytesUsed * 8) {
            for (i = 0; i < this.bytesUsed; ++i) {
                this.relativeCenter = (this.relativeCenter << 8) + (long)buffer[i + offset];
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                this.peakCenter = (this.peakCenter << 8) + (long)buffer[i + offset];
            }
            offset += this.bytesUsed;
        }
        if (size > 2 + this.bytesUsed * 10) {
            for (i = 0; i < this.bytesUsed; ++i) {
                this.relativeBass = (this.relativeBass << 8) + (long)buffer[i + offset];
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                this.peakBass = (this.peakBass << 8) + (long)buffer[i + offset];
            }
            offset += this.bytesUsed;
        }
    }

    public String toString() {
        return this.increment + " " + this.bytesUsed * 8 + " " + this.relativeRight + " " + this.relativeLeft + " " + this.peakRight + " " + this.peakLeft + " " + this.relativeRightBack + " " + this.relativeLeftBack + " " + this.peakRightBack + " " + this.peakLeftBack + " " + this.relativeCenter + " " + this.peakCenter + " " + this.relativeBass + " " + this.peakBass;
    }

    public void write(RandomAccessFile file) throws IOException {
        int i;
        int offset = 0;
        this.writeHeader(file, this.getSize());
        byte[] buffer = new byte[this.getSize()];
        buffer[offset++] = this.increment;
        buffer[offset++] = this.bytesUsed;
        for (i = 0; i < this.bytesUsed; ++i) {
            buffer[i + offset] = (byte)(this.relativeRight >> (this.bytesUsed - i - 1) * 8);
        }
        offset += this.bytesUsed;
        for (i = 0; i < this.bytesUsed; ++i) {
            buffer[i + offset] = (byte)(this.relativeLeft >> (this.bytesUsed - i - 1) * 8);
        }
        offset += this.bytesUsed;
        for (i = 0; i < this.bytesUsed; ++i) {
            buffer[i + offset] = (byte)(this.peakRight >> (this.bytesUsed - i - 1) * 8);
        }
        offset += this.bytesUsed;
        for (i = 0; i < this.bytesUsed; ++i) {
            buffer[i + offset] = (byte)(this.peakLeft >> (this.bytesUsed - i - 1) * 8);
        }
        offset += this.bytesUsed;
        if (this.relativeRightBack != 0L || this.relativeLeftBack != 0L || this.peakRightBack != 0L || this.peakLeftBack != 0L) {
            for (i = 0; i < this.bytesUsed; ++i) {
                buffer[i + offset] = (byte)(this.relativeRightBack >> (this.bytesUsed - i - 1) * 8);
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                buffer[i + offset] = (byte)(this.relativeLeftBack >> (this.bytesUsed - i - 1) * 8);
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                buffer[i + offset] = (byte)(this.peakRightBack >> (this.bytesUsed - i - 1) * 8);
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                buffer[i + offset] = (byte)(this.peakLeftBack >> (this.bytesUsed - i - 1) * 8);
            }
            offset += this.bytesUsed;
        }
        if (this.relativeCenter != 0L || this.peakCenter != 0L) {
            for (i = 0; i < this.bytesUsed; ++i) {
                buffer[i + offset] = (byte)(this.relativeCenter >> (this.bytesUsed - i - 1) * 8);
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                buffer[i + offset] = (byte)(this.peakCenter >> (this.bytesUsed - i - 1) * 8);
            }
            offset += this.bytesUsed;
        }
        if (this.relativeBass != 0L || this.peakBass != 0L) {
            for (i = 0; i < this.bytesUsed; ++i) {
                buffer[i + offset] = (byte)(this.relativeBass >> (this.bytesUsed - i - 1) * 8);
            }
            offset += this.bytesUsed;
            for (i = 0; i < this.bytesUsed; ++i) {
                buffer[i + offset] = (byte)(this.peakBass >> (this.bytesUsed - i - 1) * 8);
            }
            offset += this.bytesUsed;
        }
        file.write(buffer);
    }
}

