/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v1;
import org.farng.mp3.id3.ID3v1Iterator;
import org.farng.mp3.id3.ID3v1_1;
import org.farng.mp3.lyrics3.AbstractLyrics3;

public class ID3v1
extends AbstractID3v1 {
    protected String album = "";
    protected String artist = "";
    protected String comment = "";
    protected String title = "";
    protected String year = "";
    protected byte genre = (byte)-1;

    public ID3v1() {
    }

    public ID3v1(ID3v1 copyObject) {
        super(copyObject);
        this.album = new String(copyObject.album);
        this.artist = new String(copyObject.artist);
        this.comment = new String(copyObject.comment);
        this.title = new String(copyObject.title);
        this.year = new String(copyObject.year);
        this.genre = copyObject.genre;
    }

    public ID3v1(AbstractMP3Tag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof ID3v1 && !(mp3tag instanceof ID3v1_1)) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v1_1 convertedTag = mp3tag instanceof ID3v1_1 ? (ID3v1_1)mp3tag : new ID3v1_1(mp3tag);
            this.album = new String(convertedTag.album.trim());
            this.artist = new String(convertedTag.artist.trim());
            this.comment = new String(convertedTag.comment.trim());
            this.title = new String(convertedTag.title.trim());
            this.year = new String(convertedTag.year.trim());
            this.genre = convertedTag.genre;
        }
    }

    public ID3v1(RandomAccessFile file) throws TagNotFoundException, IOException {
        this.read(file);
    }

    public void setAlbum(String album) {
        this.album = TagUtility.truncate(album, 30);
    }

    public String getAlbum() {
        return this.album;
    }

    public void setArtist(String artist) {
        this.artist = TagUtility.truncate(artist, 30);
    }

    public String getArtist() {
        return this.artist;
    }

    public void setComment(String comment) {
        this.comment = TagUtility.truncate(comment, 30);
    }

    public String getComment() {
        return this.comment;
    }

    public void setGenre(byte genre) {
        this.genre = genre;
    }

    public byte getGenre() {
        return this.genre;
    }

    public ID3v1 getID3tag(RandomAccessFile file) throws IOException {
        ID3v1 id3v1tag = new ID3v1_1();
        if (id3v1tag.seek(file)) {
            try {
                id3v1tag.read(file);
                id3v1tag.delete(file);
            }
            catch (TagNotFoundException ex) {
                id3v1tag = null;
            }
        } else {
            id3v1tag = null;
        }
        if (id3v1tag == null) {
            id3v1tag = new ID3v1();
            if (id3v1tag.seek(file)) {
                try {
                    id3v1tag.read(file);
                    id3v1tag.delete(file);
                }
                catch (TagNotFoundException ex) {
                    id3v1tag = null;
                }
            } else {
                id3v1tag = null;
            }
        }
        return id3v1tag;
    }

    public String getIdentifier() {
        return "ID3v1.00";
    }

    public int getSize() {
        return 128;
    }

    public void setTitle(String title) {
        this.title = TagUtility.truncate(title, 30);
    }

    public String getTitle() {
        return this.title;
    }

    public void setYear(String year) {
        this.year = TagUtility.truncate(year, 4);
    }

    public String getYear() {
        return this.year;
    }

    public void append(AbstractMP3Tag tag) {
        ID3v1 oldTag = this;
        if (tag != null) {
            ID3v1 newTag = tag instanceof ID3v1 ? (ID3v1)tag : new ID3v1();
            if (tag instanceof AbstractLyrics3) {
                TagOptionSingleton.getInstance().setId3v1SaveYear(false);
                TagOptionSingleton.getInstance().setId3v1SaveComment(false);
            }
            oldTag.title = TagOptionSingleton.getInstance().isId3v1SaveTitle() && oldTag.title.length() == 0 ? newTag.title : oldTag.title;
            oldTag.artist = TagOptionSingleton.getInstance().isId3v1SaveArtist() && oldTag.artist.length() == 0 ? newTag.artist : oldTag.artist;
            oldTag.album = TagOptionSingleton.getInstance().isId3v1SaveAlbum() && oldTag.album.length() == 0 ? newTag.album : oldTag.album;
            oldTag.year = TagOptionSingleton.getInstance().isId3v1SaveYear() && oldTag.year.length() == 0 ? newTag.year : oldTag.year;
            oldTag.comment = TagOptionSingleton.getInstance().isId3v1SaveComment() && oldTag.comment.length() == 0 ? newTag.comment : oldTag.comment;
            oldTag.genre = TagOptionSingleton.getInstance().isId3v1SaveGenre() && oldTag.genre < 0 ? newTag.genre : oldTag.genre;
        }
    }

    public void delete(RandomAccessFile file) throws IOException {
        if (this.seek(file)) {
            file.setLength(file.length() - 128L);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v1)) {
            return false;
        }
        ID3v1 id3v1 = (ID3v1)obj;
        if (!this.album.equals(id3v1.album)) {
            return false;
        }
        if (!this.artist.equals(id3v1.artist)) {
            return false;
        }
        if (!this.comment.equals(id3v1.comment)) {
            return false;
        }
        if (this.genre != id3v1.genre) {
            return false;
        }
        if (!this.title.equals(id3v1.title)) {
            return false;
        }
        if (!this.year.equals(id3v1.year)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        return new ID3v1Iterator(this);
    }

    public void overwrite(AbstractMP3Tag tag) {
        ID3v1 oldTag = this;
        if (tag != null) {
            ID3v1 newTag = tag instanceof ID3v1 ? (ID3v1)tag : new ID3v1();
            if (tag instanceof AbstractLyrics3) {
                TagOptionSingleton.getInstance().setId3v1SaveYear(false);
                TagOptionSingleton.getInstance().setId3v1SaveComment(false);
            }
            oldTag.title = TagOptionSingleton.getInstance().isId3v1SaveTitle() ? newTag.title : oldTag.artist;
            oldTag.artist = TagOptionSingleton.getInstance().isId3v1SaveArtist() ? newTag.artist : oldTag.artist;
            oldTag.album = TagOptionSingleton.getInstance().isId3v1SaveAlbum() ? newTag.album : oldTag.album;
            oldTag.year = TagOptionSingleton.getInstance().isId3v1SaveYear() ? newTag.year : oldTag.year;
            oldTag.comment = TagOptionSingleton.getInstance().isId3v1SaveComment() ? newTag.comment : oldTag.comment;
            oldTag.genre = TagOptionSingleton.getInstance().isId3v1SaveGenre() ? newTag.genre : oldTag.genre;
        }
    }

    public void read(RandomAccessFile file) throws TagNotFoundException, IOException {
        byte[] buffer = new byte[30];
        if (!this.seek(file)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        file.read(buffer, 0, 30);
        this.title = new String(buffer, 0, 30, "ISO-8859-1").trim();
        file.read(buffer, 0, 30);
        this.artist = new String(buffer, 0, 30, "ISO-8859-1").trim();
        file.read(buffer, 0, 30);
        this.album = new String(buffer, 0, 30, "ISO-8859-1").trim();
        file.read(buffer, 0, 4);
        this.year = new String(buffer, 0, 4, "ISO-8859-1").trim();
        file.read(buffer, 0, 30);
        this.comment = new String(buffer, 0, 30, "ISO-8859-1").trim();
        file.read(buffer, 0, 1);
        this.genre = buffer[0];
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        file.seek(file.length() - 128L);
        file.read(buffer, 0, 3);
        String tag = new String(buffer, 0, 3);
        return tag.equals("TAG");
    }

    public String toString() {
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        str = str + "Title = " + this.title + "\n";
        str = str + "Artist = " + this.artist + "\n";
        str = str + "Album = " + this.album + "\n";
        str = str + "Comment = " + this.comment + "\n";
        str = str + "Year = " + this.year + "\n";
        str = str + "Genre = " + this.genre + "\n";
        return str;
    }

    public void write(AbstractMP3Tag tag) {
        ID3v1 oldTag = this;
        if (tag != null) {
            ID3v1 newTag = tag instanceof ID3v1 ? (ID3v1)tag : new ID3v1_1(tag);
            oldTag.title = newTag.title;
            oldTag.artist = newTag.artist;
            oldTag.album = newTag.album;
            oldTag.year = newTag.year;
            oldTag.comment = newTag.comment;
            oldTag.genre = newTag.genre;
        }
    }

    public void write(RandomAccessFile file) throws IOException {
        int i;
        String str;
        byte[] buffer = new byte[128];
        int offset = 3;
        this.delete(file);
        file.seek(file.length());
        buffer[0] = 84;
        buffer[1] = 65;
        buffer[2] = 71;
        if (TagOptionSingleton.getInstance().isId3v1SaveTitle()) {
            str = TagUtility.truncate(this.title, 30);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset += 30;
        if (TagOptionSingleton.getInstance().isId3v1SaveArtist()) {
            str = TagUtility.truncate(this.artist, 30);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset += 30;
        if (TagOptionSingleton.getInstance().isId3v1SaveAlbum()) {
            str = TagUtility.truncate(this.album, 30);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset += 30;
        if (TagOptionSingleton.getInstance().isId3v1SaveYear()) {
            str = TagUtility.truncate(this.year, 4);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset += 4;
        if (TagOptionSingleton.getInstance().isId3v1SaveComment()) {
            str = TagUtility.truncate(this.comment, 30);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset += 30;
        if (TagOptionSingleton.getInstance().isId3v1SaveGenre()) {
            buffer[offset] = this.genre;
        }
        file.write(buffer);
    }

    public String getSongTitle() {
        return this.getTitle().trim();
    }

    public String getLeadArtist() {
        return this.getArtist().trim();
    }

    public String getAlbumTitle() {
        return this.getAlbum().trim();
    }

    public String getYearReleased() {
        return this.getYear().trim();
    }

    public String getSongComment() {
        return this.getComment().trim();
    }

    public String getSongGenre() {
        return Integer.toString(this.getGenre());
    }

    public String getTrackNumberOnAlbum() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongLyric() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getAuthorComposer() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongTitle(String songTitle) {
        this.setTitle(songTitle.trim());
    }

    public void setLeadArtist(String leadArtist) {
        this.setArtist(leadArtist.trim());
    }

    public void setAlbumTitle(String albumTitle) {
        this.setAlbum(albumTitle.trim());
    }

    public void setYearReleased(String yearReleased) {
        this.setYear(yearReleased.trim());
    }

    public void setSongComment(String songComment) {
        this.setComment(songComment.trim());
    }

    public void setSongGenre(String songGenre) {
        this.setGenre(Byte.parseByte(songGenre.trim()));
    }

    public void setTrackNumberOnAlbum(String trackNumberOnAlbum) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongLyric(String songLyrics) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setAuthorComposer(String authorComposer) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }
}

