/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.AbstractMP3Fragment;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractFrameBodyTextInformation;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.lyrics3.AbstractLyrics3v2FieldBody;
import org.farng.mp3.lyrics3.FieldBodyAUT;
import org.farng.mp3.lyrics3.FieldBodyEAL;
import org.farng.mp3.lyrics3.FieldBodyEAR;
import org.farng.mp3.lyrics3.FieldBodyETT;
import org.farng.mp3.lyrics3.FieldBodyIMG;
import org.farng.mp3.lyrics3.FieldBodyIND;
import org.farng.mp3.lyrics3.FieldBodyINF;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.FieldBodyUnsupported;

public class Lyrics3v2Field
extends AbstractMP3Fragment {
    public Lyrics3v2Field() {
    }

    public Lyrics3v2Field(Lyrics3v2Field copyObject) {
        super(copyObject);
    }

    public Lyrics3v2Field(AbstractLyrics3v2FieldBody body) {
        super(body);
    }

    public Lyrics3v2Field(AbstractID3v2Frame frame) throws TagException {
        String frameIdentifier = frame.getIdentifier();
        if (frameIdentifier.startsWith("USLT")) {
            this.setBody(new FieldBodyLYR(""));
            ((FieldBodyLYR)this.getBody()).addLyric((FrameBodyUSLT)frame.getBody());
        } else if (frameIdentifier.startsWith("SYLT")) {
            this.setBody(new FieldBodyLYR(""));
            ((FieldBodyLYR)this.getBody()).addLyric((FrameBodySYLT)frame.getBody());
        } else if (frameIdentifier.startsWith("COMM")) {
            String text = new String(((FrameBodyCOMM)frame.getBody()).getText());
            this.setBody(new FieldBodyINF(text));
        } else if (frameIdentifier.equals("TCOM")) {
            AbstractFrameBodyTextInformation textFrame = (AbstractFrameBodyTextInformation)frame.getBody();
            this.setBody(new FieldBodyAUT(""));
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.setBody(new FieldBodyAUT(textFrame.getText()));
            }
        } else if (frameIdentifier.equals("TALB")) {
            AbstractFrameBodyTextInformation textFrame = (AbstractFrameBodyTextInformation)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.setBody(new FieldBodyEAL(textFrame.getText()));
            }
        } else if (frameIdentifier.equals("TPE1")) {
            AbstractFrameBodyTextInformation textFrame = (AbstractFrameBodyTextInformation)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.setBody(new FieldBodyEAR(textFrame.getText()));
            }
        } else if (frameIdentifier.equals("TIT2")) {
            AbstractFrameBodyTextInformation textFrame = (AbstractFrameBodyTextInformation)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.setBody(new FieldBodyETT(textFrame.getText()));
            }
        } else {
            throw new TagException("Cannot create Lyrics3v2 field from given ID3v2 frame");
        }
    }

    public Lyrics3v2Field(RandomAccessFile file) throws InvalidTagException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        if (this.getBody() == null) {
            return "";
        }
        return this.getBody().getIdentifier();
    }

    public int getSize() {
        return this.getBody().getSize() + 5 + this.getIdentifier().length();
    }

    public void read(RandomAccessFile file) throws InvalidTagException, IOException {
        long filePointer;
        byte b;
        byte[] buffer = new byte[6];
        do {
            filePointer = file.getFilePointer();
        } while ((b = file.readByte()) == 0);
        file.seek(filePointer);
        file.read(buffer, 0, 3);
        String identifier = new String(buffer, 0, 3);
        if (!TagUtility.isLyrics3v2FieldIdentifier(identifier)) {
            throw new InvalidTagException(identifier + " is not a valid ID3v2.4 frame");
        }
        this.setBody(this.readBody(identifier, file));
    }

    public String toString() {
        if (this.getBody() == null) {
            return "";
        }
        return this.getBody().toString();
    }

    public void write(RandomAccessFile file) throws IOException {
        if (this.getBody().getSize() > 0 || TagOptionSingleton.getInstance().isLyrics3SaveEmptyField()) {
            byte[] buffer = new byte[3];
            String str = this.getIdentifier();
            for (int i = 0; i < str.length(); ++i) {
                buffer[i] = (byte)str.charAt(i);
            }
            file.write(buffer, 0, str.length());
            this.getBody().write(file);
        }
    }

    private AbstractLyrics3v2FieldBody readBody(String identifier, RandomAccessFile file) throws InvalidTagException, IOException {
        AbstractLyrics3v2FieldBody newBody = identifier.equals("AUT") ? new FieldBodyAUT(file) : (identifier.equals("EAL") ? new FieldBodyEAL(file) : (identifier.equals("EAR") ? new FieldBodyEAR(file) : (identifier.equals("ETT") ? new FieldBodyETT(file) : (identifier.equals("IMG") ? new FieldBodyIMG(file) : (identifier.equals("IND") ? new FieldBodyIND(file) : (identifier.equals("INF") ? new FieldBodyINF(file) : (identifier.equals("LYR") ? new FieldBodyLYR(file) : new FieldBodyUnsupported(file))))))));
        return newBody;
    }
}

