/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.i18n.text.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.abdera.i18n.text.io.PeekAheadInputStream;

public class CharsetSniffingInputStream
extends FilterInputStream {
    protected String encoding;
    protected boolean bomset = false;
    protected final boolean preserve;

    public CharsetSniffingInputStream(InputStream in) {
        this(in, true);
    }

    public CharsetSniffingInputStream(InputStream in, boolean preserveBom) {
        super(!(in instanceof PeekAheadInputStream) ? new PeekAheadInputStream(in, 4) : in);
        this.preserve = preserveBom;
        try {
            this.encoding = this.detectEncoding();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isBomSet() {
        return this.bomset;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected PeekAheadInputStream getInternal() {
        return (PeekAheadInputStream)this.in;
    }

    private static boolean equals(byte[] a1, int len, byte[] a2) {
        int n = 0;
        int i = 0;
        while (n < len) {
            if (a1[n] != a2[i]) {
                return false;
            }
            ++n;
            ++i;
        }
        return true;
    }

    protected String detectEncoding() throws IOException {
        PeekAheadInputStream pin = (PeekAheadInputStream)this.in;
        byte[] bom = new byte[4];
        pin.peek(bom);
        this.bomset = false;
        Encoding[] encodingArray = Encoding.values();
        int n = encodingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Encoding enc = encodingArray[n2];
            int bomlen = enc.equals(bom);
            if (bomlen > 0) {
                this.bomset = enc.getBom();
                if (this.bomset && !this.preserve) {
                    pin.read(new byte[bomlen]);
                }
                return enc.getEncoding();
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Encoding
    extends Enum<Encoding> {
        public static final /* enum */ Encoding UTF32be;
        public static final /* enum */ Encoding UTF32le;
        public static final /* enum */ Encoding INVALID;
        public static final /* enum */ Encoding UTF16be;
        public static final /* enum */ Encoding UTF16le;
        public static final /* enum */ Encoding UTF8;
        public static final /* enum */ Encoding UTF32be2;
        public static final /* enum */ Encoding UTF32le2;
        public static final /* enum */ Encoding UTF16be2;
        public static final /* enum */ Encoding UTF16le2;
        private final String enc;
        private final byte[][] checks;
        private final boolean bom;
        private static final /* synthetic */ Encoding[] ENUM$VALUES;

        static {
            byte[][] byArrayArray = new byte[1][];
            byte[] byArray = new byte[4];
            byArray[2] = -2;
            byArray[3] = -1;
            byArrayArray[0] = byArray;
            UTF32be = new Encoding("UTF-32", true, byArrayArray);
            byte[][] byArrayArray2 = new byte[1][];
            byte[] byArray2 = new byte[4];
            byArray2[0] = -1;
            byArray2[1] = -2;
            byArrayArray2[0] = byArray2;
            UTF32le = new Encoding("UTF-32", true, byArrayArray2);
            byte[][] byArrayArray3 = new byte[2][];
            byte[] byArray3 = new byte[4];
            byArray3[0] = -2;
            byArray3[1] = -1;
            byArrayArray3[0] = byArray3;
            byte[] byArray4 = new byte[4];
            byArray4[2] = -1;
            byArray4[3] = -2;
            byArrayArray3[1] = byArray4;
            INVALID = new Encoding(null, true, byArrayArray3);
            UTF16be = new Encoding("UTF-16", true, new byte[][]{{-2, -1}});
            UTF16le = new Encoding("UTF-16", true, new byte[][]{{-1, -2}});
            UTF8 = new Encoding("UTF-8", true, new byte[][]{{-17, -69, -65}});
            byte[][] byArrayArray4 = new byte[1][];
            byte[] byArray5 = new byte[4];
            byArray5[3] = 60;
            byArrayArray4[0] = byArray5;
            UTF32be2 = new Encoding("UTF-32be", false, byArrayArray4);
            byte[][] byArrayArray5 = new byte[1][];
            byte[] byArray6 = new byte[4];
            byArray6[0] = 60;
            byArrayArray5[0] = byArray6;
            UTF32le2 = new Encoding("UTF-32le", false, byArrayArray5);
            byte[][] byArrayArray6 = new byte[1][];
            byte[] byArray7 = new byte[4];
            byArray7[1] = 60;
            byArray7[3] = 63;
            byArrayArray6[0] = byArray7;
            UTF16be2 = new Encoding("UTF-16be", false, byArrayArray6);
            byte[][] byArrayArray7 = new byte[1][];
            byte[] byArray8 = new byte[4];
            byArray8[0] = 60;
            byArray8[2] = 63;
            byArrayArray7[0] = byArray8;
            UTF16le2 = new Encoding("UTF-16le", false, byArrayArray7);
            ENUM$VALUES = new Encoding[]{UTF32be, UTF32le, INVALID, UTF16be, UTF16le, UTF8, UTF32be2, UTF32le2, UTF16be2, UTF16le2};
        }

        private Encoding(String name, boolean bom, byte[] ... checks) {
            this.enc = name;
            this.checks = checks;
            this.bom = bom;
        }

        public String getEncoding() {
            return this.enc;
        }

        public boolean getBom() {
            return this.bom;
        }

        public int equals(byte[] bom) {
            byte[][] byArray = this.checks;
            int n = this.checks.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] check = byArray[n2];
                if (CharsetSniffingInputStream.equals(bom, check.length, check)) {
                    return check.length;
                }
                ++n2;
            }
            return 0;
        }

        public static Encoding[] values() {
            Encoding[] encodingArray = ENUM$VALUES;
            int n = encodingArray.length;
            Encoding[] encodingArray2 = new Encoding[n];
            System.arraycopy(ENUM$VALUES, 0, encodingArray2, 0, n);
            return encodingArray2;
        }

        public static Encoding valueOf(String string) {
            return Enum.valueOf(Encoding.class, string);
        }
    }
}

