/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.netbios.win32;

import java.io.IOException;
import java.nio.channels.IllegalBlockingModeException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.alfresco.jlan.netbios.win32.NetBIOSSelectionKey;
import org.alfresco.jlan.netbios.win32.NetBIOSSocket;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.netbios.win32.WinsockNetBIOSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetBIOSSelector {
    private static final int DefaultSockArraySize = 64;
    private int[] m_sockIds;
    private int[] m_eventIds;
    private Hashtable<Integer, NetBIOSSelectionKey> m_selectionKeys;
    private Set<Integer> m_keySet;
    private Set<NetBIOSSelectionKey> m_triggeredKeys;

    public NetBIOSSelector() {
        this.m_sockIds = new int[64];
        this.m_selectionKeys = new Hashtable();
        this.m_keySet = this.m_selectionKeys.keySet();
        this.m_triggeredKeys = new HashSet<NetBIOSSelectionKey>();
    }

    public NetBIOSSelector(int initSize) {
        this.m_sockIds = new int[initSize];
        this.m_selectionKeys = new Hashtable();
        this.m_keySet = this.m_selectionKeys.keySet();
        this.m_triggeredKeys = new HashSet<NetBIOSSelectionKey>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NetBIOSSelectionKey registerSocket(NetBIOSSocket socket, int ops) throws IOException, IllegalBlockingModeException {
        NetBIOSSelectionKey selKey = null;
        Hashtable<Integer, NetBIOSSelectionKey> hashtable = this.m_selectionKeys;
        synchronized (hashtable) {
            Integer key = new Integer(socket.getSocket());
            if (this.m_selectionKeys.containsKey(key)) {
                throw new IOException("Socket already registered with selector");
            }
            if (!socket.isNonBlocking()) {
                throw new IllegalBlockingModeException();
            }
            selKey = new NetBIOSSelectionKey(this, socket, ops, null);
            this.m_selectionKeys.put(key, selKey);
        }
        return selKey;
    }

    public final NetBIOSSelectionKey deregisterSocket(NetBIOSSocket socket) throws IOException {
        NetBIOSSelectionKey selKey = this.m_selectionKeys.remove(new Integer(socket.getSocket()));
        if (selKey != null) {
            this.m_triggeredKeys.remove(selKey);
        }
        return selKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int select() throws WinsockNetBIOSException {
        int idx = 0;
        Hashtable<Integer, NetBIOSSelectionKey> hashtable = this.m_selectionKeys;
        synchronized (hashtable) {
            if (this.m_sockIds.length < this.m_selectionKeys.size()) {
                this.m_sockIds = new int[this.m_selectionKeys.size()];
            }
            for (Integer curKey : this.m_keySet) {
                NetBIOSSelectionKey selKey = this.m_selectionKeys.get(curKey);
                if (this.m_triggeredKeys.contains(selKey) || (selKey.interestOps() & 5) == 0) continue;
                this.m_sockIds[idx++] = selKey.socket().getSocket();
            }
        }
        if (idx == 0) {
            return 0;
        }
        if (this.m_eventIds == null || this.m_eventIds.length != this.m_sockIds.length) {
            this.m_eventIds = new int[this.m_sockIds.length];
        }
        this.m_triggeredKeys.clear();
        int eventCnt = Win32NetBIOS.SelectReceiveSockets(idx, this.m_sockIds, this.m_eventIds);
        if (eventCnt > 0) {
            for (int i = 0; i < eventCnt; ++i) {
                NetBIOSSelectionKey selKey = this.m_selectionKeys.get(new Integer(this.m_eventIds[i]));
                if (selKey == null) continue;
                selKey.setTriggers(selKey.socket().isListener() ? 1 : 4);
                this.m_triggeredKeys.add(selKey);
            }
        }
        return eventCnt;
    }

    public final void close() {
        this.m_selectionKeys.clear();
        this.m_triggeredKeys.clear();
    }

    public final Set<Integer> keys() {
        return this.m_keySet;
    }

    public final NetBIOSSelectionKey getSelectionKey(Integer key) {
        return this.m_selectionKeys.get(key);
    }

    public final Set<NetBIOSSelectionKey> selectedKeys() {
        return this.m_triggeredKeys;
    }
}

