/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth;

import java.util.Vector;
import org.alfresco.jlan.server.auth.UserAccount;

public class UserAccountList {
    private Vector<UserAccount> m_users = new Vector();

    public final void addUser(UserAccount user) {
        this.removeUser(user);
        this.m_users.add(user);
    }

    public final UserAccount findUser(String user) {
        for (int i = 0; i < this.m_users.size(); ++i) {
            UserAccount acc = this.m_users.get(i);
            if (!acc.getUserName().equalsIgnoreCase(user)) continue;
            return acc;
        }
        return null;
    }

    public final boolean hasUser(String user) {
        for (int i = 0; i < this.m_users.size(); ++i) {
            UserAccount acc = this.m_users.get(i);
            if (acc.getUserName().compareTo(user) != 0) continue;
            return true;
        }
        return false;
    }

    public final UserAccount getUserAt(int idx) {
        if (idx >= this.m_users.size()) {
            return null;
        }
        return this.m_users.get(idx);
    }

    public final int numberOfUsers() {
        return this.m_users.size();
    }

    public final void removeAllUsers() {
        this.m_users.removeAllElements();
    }

    public final void removeUser(UserAccount userAcc) {
        for (int i = 0; i < this.m_users.size(); ++i) {
            UserAccount acc = this.m_users.get(i);
            if (acc.getUserName().compareTo(userAcc.getUserName()) != 0) continue;
            this.m_users.removeElementAt(i);
            return;
        }
    }

    public final void removeUser(String user) {
        for (int i = 0; i < this.m_users.size(); ++i) {
            UserAccount acc = this.m_users.get(i);
            if (acc.getUserName().compareTo(user) != 0) continue;
            this.m_users.removeElementAt(i);
            return;
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.m_users.size());
        str.append(":");
        for (int i = 0; i < this.m_users.size(); ++i) {
            UserAccount acc = this.m_users.get(i);
            str.append(acc.getUserName());
            str.append(",");
        }
        str.append("]");
        return str.toString();
    }
}

