/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.acl;

import java.util.Hashtable;
import org.alfresco.jlan.server.auth.acl.ACLParseException;
import org.alfresco.jlan.server.auth.acl.AccessControl;
import org.alfresco.jlan.server.auth.acl.AccessControlParser;
import org.alfresco.jlan.server.auth.acl.InvalidACLTypeException;
import org.springframework.extensions.config.ConfigElement;

public class AccessControlFactory {
    private Hashtable<String, AccessControlParser> m_parsers = new Hashtable();

    public final AccessControl createAccessControl(String type, ConfigElement params) throws ACLParseException, InvalidACLTypeException {
        AccessControlParser parser = this.m_parsers.get(type);
        if (parser == null) {
            throw new InvalidACLTypeException(type);
        }
        return parser.createAccessControl(params);
    }

    public final void addParser(AccessControlParser parser) {
        this.m_parsers.put(parser.getType(), parser);
    }

    public final AccessControlParser removeParser(String type) {
        return this.m_parsers.remove(type);
    }
}

