/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.passthru;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.alfresco.jlan.netbios.NetworkSession;
import org.alfresco.jlan.util.DataPacker;

public class TcpipSMBNetworkSession
extends NetworkSession {
    private static final String ProtocolName = "Native SMB (port 445)";
    private Socket m_socket;
    private DataInputStream m_in;
    private DataOutputStream m_out;
    private int m_sessPort = 445;
    private static boolean m_debug = false;
    private static PrintStream m_dbg = System.out;

    public TcpipSMBNetworkSession() {
        super(ProtocolName);
    }

    public TcpipSMBNetworkSession(int tmo) {
        super(ProtocolName);
        this.setTimeout(tmo);
    }

    public TcpipSMBNetworkSession(int tmo, int port) {
        super(ProtocolName);
        this.setTimeout(tmo);
        this.m_sessPort = port;
    }

    public void Open(String toName, String fromName, String toAddr) throws IOException, UnknownHostException {
        this.m_socket = new Socket();
        this.m_socket.setSoTimeout(this.getTimeout());
        InetSocketAddress sockAddr = new InetSocketAddress(toName, this.m_sessPort);
        this.m_socket.connect(sockAddr, this.getTimeout());
        this.m_in = new DataInputStream(this.m_socket.getInputStream());
        this.m_out = new DataOutputStream(this.m_socket.getOutputStream());
    }

    public boolean isConnected() {
        return this.m_socket != null;
    }

    public final boolean hasData() throws IOException {
        if (this.m_socket == null || this.m_in == null) {
            return false;
        }
        return this.m_in.available() > 0;
    }

    public int Receive(byte[] buf) throws IOException {
        int rdlen = this.m_in.read(buf, 0, 4);
        if (rdlen < 4) {
            throw new IOException("TCP/IP SMB Short Read");
        }
        int pktlen = DataPacker.getInt(buf, 0);
        if (m_debug) {
            m_dbg.println("TcpSMB: Rx " + pktlen + " bytes");
        }
        int totlen = 0;
        int offset = 4;
        while (pktlen > 0) {
            rdlen = this.m_in.read(buf, offset, pktlen);
            totlen += rdlen;
            pktlen -= rdlen;
            offset += rdlen;
        }
        return totlen;
    }

    public boolean Send(byte[] data, int siz) throws IOException {
        DataPacker.putInt(siz, data, 0);
        int len = siz + 4;
        this.m_out.write(data, 0, len);
        return true;
    }

    public void Close() throws IOException {
        if (this.m_in != null) {
            this.m_in.close();
            this.m_in = null;
        }
        if (this.m_out != null) {
            this.m_out.close();
            this.m_out = null;
        }
        if (this.m_socket != null) {
            this.m_socket.close();
            this.m_socket = null;
        }
    }

    public void setTimeout(int tmo) {
        super.setTimeout(tmo);
        if (this.m_socket != null) {
            try {
                this.m_socket.setSoTimeout(this.getTimeout());
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public static void setDebug(boolean dbg) {
        m_debug = dbg;
    }
}

