/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.spnego;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.alfresco.jlan.server.auth.asn.DERBitString;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERGeneralString;
import org.alfresco.jlan.server.auth.asn.DERObject;
import org.alfresco.jlan.server.auth.asn.DEROctetString;
import org.alfresco.jlan.server.auth.asn.DEROid;
import org.alfresco.jlan.server.auth.asn.DERSequence;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class NegTokenInit {
    private Oid[] m_mechTypes;
    private int m_contextFlags = -1;
    private byte[] m_mechToken;
    private String m_mecListMICPrincipal;

    public NegTokenInit() {
    }

    public NegTokenInit(Oid[] mechTypes, String mechPrincipal) {
        this.m_mechTypes = mechTypes;
        this.m_mecListMICPrincipal = mechPrincipal;
    }

    public NegTokenInit(Vector mechTypes, String mechPrincipal) {
        this.m_mechTypes = new Oid[mechTypes.size()];
        for (int i = 0; i < mechTypes.size(); ++i) {
            this.m_mechTypes[i] = (Oid)mechTypes.get(i);
        }
        this.m_mecListMICPrincipal = mechPrincipal;
    }

    public final Oid[] getOids() {
        return this.m_mechTypes;
    }

    public final int getContextFlags() {
        return this.m_contextFlags;
    }

    public final byte[] getMechtoken() {
        return this.m_mechToken;
    }

    public final String getPrincipal() {
        return this.m_mecListMICPrincipal;
    }

    public final boolean hasOid(Oid oid) {
        boolean foundOid = false;
        if (this.m_mechTypes != null) {
            foundOid = oid.containedIn(this.m_mechTypes);
        }
        return foundOid;
    }

    public final int numberOfOids() {
        return this.m_mechTypes != null ? this.m_mechTypes.length : 0;
    }

    public final Oid getOidAt(int idx) {
        if (this.m_mechTypes != null && idx >= 0 && idx < this.m_mechTypes.length) {
            return this.m_mechTypes[idx];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(byte[] buf, int off, int len) throws IOException {
        DERBuffer derBuf = new DERBuffer(buf, off, len);
        DERObject derObj = derBuf.unpackApplicationSpecific();
        if (!(derObj instanceof DEROid)) throw new IOException("Invalid security blob");
        DEROid derOid = (DEROid)derObj;
        if (!derOid.getOid().equals("1.3.6.1.5.5.2")) {
            throw new IOException("Not an SPNEGO blob");
        }
        derObj = derBuf.unpackObject();
        if (!(derObj instanceof DERSequence)) throw new IOException("Bad object type in blob");
        DERSequence derSeq = (DERSequence)derObj;
        if ((derObj = derSeq.getTaggedObject(0)) == null) {
            throw new IOException("No mechTypes list in blob");
        }
        if (!(derObj instanceof DERSequence)) {
            throw new IOException("Invalid mechTypes object");
        }
        DERSequence derOidSeq = (DERSequence)derObj;
        this.m_mechTypes = new Oid[derOidSeq.numberOfObjects()];
        int idx = 0;
        for (int i = 0; i < derOidSeq.numberOfObjects(); ++i) {
            derObj = derOidSeq.getObjectAt(i);
            if (!(derObj instanceof DEROid)) continue;
            derOid = (DEROid)derObj;
            try {
                this.m_mechTypes[idx++] = new Oid(derOid.getOid());
                continue;
            }
            catch (GSSException ex) {
                throw new IOException("Bad mechType OID");
            }
        }
        derObj = derSeq.getTaggedObject(1);
        if (derObj != null && derObj instanceof DERBitString) {
            DERBitString derBitStr = (DERBitString)derObj;
            this.m_contextFlags = derBitStr.intValue();
        }
        if ((derObj = derSeq.getTaggedObject(2)) == null) {
            throw new IOException("No mechToken in blob");
        }
        if (!(derObj instanceof DEROctetString)) {
            throw new IOException("Invalid mechToken object");
        }
        DEROctetString derStr = (DEROctetString)derObj;
        this.m_mechToken = derStr.getValue();
    }

    public byte[] encode() throws IOException {
        ArrayList<DERObject> objList = new ArrayList<DERObject>();
        objList.add(new DEROid("1.3.6.1.5.5.2"));
        DERSequence derSeq = new DERSequence();
        derSeq.setTagNo(0);
        DERSequence mechTypesSeq = new DERSequence();
        mechTypesSeq.setTagNo(0);
        for (int i = 0; i < this.m_mechTypes.length; ++i) {
            Oid mechType = this.m_mechTypes[i];
            mechTypesSeq.addObject(new DEROid(mechType.toString()));
        }
        derSeq.addObject(mechTypesSeq);
        if (this.m_mecListMICPrincipal != null) {
            DERSequence derMecSeq = new DERSequence();
            derMecSeq.setTagNo(3);
            DERGeneralString mecStr = new DERGeneralString(this.m_mecListMICPrincipal);
            mecStr.setTagNo(0);
            derMecSeq.addObject(mecStr);
            derSeq.addObject(derMecSeq);
        }
        objList.add(derSeq);
        DERBuffer derBuf = new DERBuffer();
        derBuf.packApplicationSpecific(objList);
        return derBuf.getBytes();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[NegTokenInit ");
        if (this.m_mechTypes != null) {
            str.append("mechTypes=");
            for (int i = 0; i < this.m_mechTypes.length; ++i) {
                str.append(this.m_mechTypes[i].toString());
                str.append(",");
            }
        }
        if (this.m_contextFlags != -1) {
            str.append(" context=0x");
            str.append(Integer.toHexString(this.m_contextFlags));
        }
        if (this.m_mechToken != null) {
            str.append(" token=");
            str.append(this.m_mechToken.length);
            str.append(" bytes");
        }
        if (this.m_mecListMICPrincipal != null) {
            str.append(" principal=");
            str.append(this.m_mecListMICPrincipal);
        }
        str.append("]");
        return str.toString();
    }
}

