/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.locking.FileLock;
import org.alfresco.jlan.locking.FileLockList;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.locking.NotLockedException;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.FileStatus;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.server.locking.OpLockDetails;

public class FileState {
    public static final long NoTimeout = -1L;
    public static final long DefTimeout = 120000L;
    public static final long RenameTimeout = 60000L;
    public static final long DeleteTimeout = 15000L;
    public static final int UnknownFileId = -1;
    public static final int FILE_LOADWAIT = 0;
    public static final int FILE_LOADING = 1;
    public static final int FILE_AVAILABLE = 2;
    public static final int FILE_UPDATED = 3;
    public static final int FILE_SAVEWAIT = 4;
    public static final int FILE_SAVING = 5;
    public static final int FILE_SAVED = 6;
    public static final int FILE_DELETED = 7;
    public static final int FILE_RENAMED = 8;
    public static final int FILE_DELETEONCLOSE = 9;
    private static final String[] _fileStates = new String[]{"LoadWait", "Loading", "Available", "Updated", "SaveWait", "Saving", "Saved", "Deleted", "Renamed", "DeleteOnClose"};
    public static final String FileInformation = "FileInfo";
    public static final String StreamsList = "StreamsList";
    private String m_path;
    private int m_fileId = -1;
    private long m_tmo;
    private int m_fileStatus;
    private int m_status = 2;
    private int m_openCount;
    private int m_sharedAccess = 7;
    private int m_pid = -1;
    private Hashtable<String, Object> m_cache;
    private FileLockList m_lockList;
    private OpLockDetails m_oplock;
    private long m_retainUntil = -1L;
    private PseudoFileList m_pseudoFiles;
    private long m_accessDate;
    private long m_modifyDate;
    private long m_changeDate;
    private long m_allocSize;
    private Object m_filesysObj;

    public FileState(String fname, boolean caseSensitive) {
        this.setPath(fname, caseSensitive);
        this.setExpiryTime(System.currentTimeMillis() + 120000L);
        this.m_fileStatus = -1;
    }

    public FileState(String fname, int status, boolean caseSensitive) {
        this.setPath(fname, caseSensitive);
        this.setExpiryTime(System.currentTimeMillis() + 120000L);
        this.m_fileStatus = status;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final boolean fileExists() {
        return this.m_fileStatus == 1 || this.m_fileStatus == 2;
    }

    public final int getFileStatus() {
        return this.m_fileStatus;
    }

    public final boolean isDirectory() {
        return this.m_fileStatus == 2;
    }

    public final int getOpenCount() {
        return this.m_openCount;
    }

    public final int getFileId() {
        return this.m_fileId;
    }

    public final int getSharedAccess() {
        return this.m_sharedAccess;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final int getStatus() {
        return this.m_status;
    }

    public final boolean hasActiveLocks() {
        return this.m_lockList != null && this.m_lockList.numberOfLocks() > 0;
    }

    public final boolean hasNoTimeout() {
        return this.m_tmo == -1L;
    }

    public final boolean hasActiveRetentionPeriod() {
        if (this.m_retainUntil == -1L) {
            return false;
        }
        return System.currentTimeMillis() < this.m_retainUntil;
    }

    public final long getRetentionExpiryDateTime() {
        return this.m_retainUntil;
    }

    public final boolean exists() {
        return this.m_fileStatus == 1 || this.m_fileStatus == 2;
    }

    public final boolean allowsOpen(FileOpenParams params) {
        if (this.getOpenCount() == 0) {
            return true;
        }
        if (this.getSharedAccess() == 3 && params.getSharedAccess() == 3) {
            return true;
        }
        if ((this.getSharedAccess() & 1) != 0 && params.isReadOnlyAccess()) {
            return true;
        }
        return (this.getSharedAccess() & 2) != 0 && params.isWriteOnlyAccess();
    }

    public final synchronized int incrementOpenCount() {
        ++this.m_openCount;
        return this.m_openCount;
    }

    public final synchronized int decrementOpenCount() {
        if (this.m_openCount <= 0) {
            Debug.println("@@@@@ File close name=" + this.getPath() + ", count=" + this.m_openCount + " <<ERROR>>");
        } else {
            --this.m_openCount;
        }
        return this.m_openCount;
    }

    public final boolean hasExpired(long curTime) {
        if (this.m_tmo == -1L) {
            return false;
        }
        return curTime > this.m_tmo;
    }

    public final long getSecondsToExpire(long curTime) {
        if (this.m_tmo == -1L) {
            return -1L;
        }
        return (this.m_tmo - curTime) / 1000L;
    }

    public final String getStatusAsString() {
        if (this.m_status >= 0 && this.m_status < _fileStates.length) {
            return _fileStates[this.m_status];
        }
        return "Unknown";
    }

    public final void setFileStatus(int status) {
        this.m_fileStatus = status;
    }

    public final void setFileId(int id) {
        this.m_fileId = id;
    }

    public final void setExpiryTime(long expire) {
        this.m_tmo = expire;
    }

    public final void setRetentionExpiryDateTime(long expires) {
        this.m_retainUntil = expires;
    }

    public final void setSharedAccess(int mode) {
        if (this.getOpenCount() == 0) {
            this.m_sharedAccess = mode;
        }
    }

    public final void setStatus(int sts) {
        this.m_status = sts;
    }

    public final synchronized void addAttribute(String name, Object attr) {
        if (this.m_cache == null) {
            this.m_cache = new Hashtable();
        }
        this.m_cache.put(name, attr);
    }

    public final Object findAttribute(String name) {
        if (this.m_cache == null) {
            return null;
        }
        return this.m_cache.get(name);
    }

    public final synchronized Object removeAttribute(String name) {
        if (this.m_cache == null) {
            return null;
        }
        return this.m_cache.remove(name);
    }

    public final synchronized void removeAllAttributes() {
        if (this.m_cache != null) {
            this.m_cache.clear();
        }
        this.m_cache = null;
    }

    public final void setPath(String path, boolean caseSensitive) {
        this.m_path = FileState.normalizePath(path, caseSensitive);
    }

    public final void setProcessId(int pid) {
        if (this.getOpenCount() == 0) {
            this.m_pid = pid;
        }
    }

    public final int numberOfLocks() {
        if (this.m_lockList != null) {
            return this.m_lockList.numberOfLocks();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLock(FileLock lock) throws LockConflictException {
        Object object;
        if (this.m_lockList == null) {
            object = this;
            synchronized (object) {
                if (this.m_lockList == null) {
                    this.m_lockList = new FileLockList();
                }
            }
        }
        object = this.m_lockList;
        synchronized (object) {
            if (!this.m_lockList.allowsLock(lock)) {
                throw new LockConflictException();
            }
            this.m_lockList.addLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLock(FileLock lock) throws NotLockedException {
        if (this.m_lockList == null) {
            throw new NotLockedException();
        }
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            if (this.m_lockList.removeLock(lock) == null) {
                throw new NotLockedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canReadFile(long offset, long len, int pid) {
        if (this.m_lockList == null) {
            return true;
        }
        boolean readOK = false;
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            readOK = this.m_lockList.canReadFile(offset, len, pid);
        }
        return readOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canWriteFile(long offset, long len, int pid) {
        if (this.m_lockList == null) {
            return true;
        }
        boolean writeOK = false;
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            writeOK = this.m_lockList.canWriteFile(offset, len, pid);
        }
        return writeOK;
    }

    public final boolean hasOpLock() {
        return this.m_oplock != null;
    }

    public final OpLockDetails getOpLock() {
        return this.m_oplock;
    }

    public final synchronized void setOpLock(OpLockDetails oplock) throws ExistingOpLockException {
        if (this.m_oplock != null) {
            throw new ExistingOpLockException();
        }
        this.m_oplock = oplock;
    }

    public final synchronized void clearOpLock() {
        this.m_oplock = null;
    }

    public final boolean hasPseudoFiles() {
        if (this.m_pseudoFiles != null) {
            return this.m_pseudoFiles.numberOfFiles() > 0;
        }
        return false;
    }

    public final PseudoFileList getPseudoFileList() {
        return this.m_pseudoFiles;
    }

    public final void addPseudoFile(PseudoFile pfile) {
        if (this.m_pseudoFiles == null) {
            this.m_pseudoFiles = new PseudoFileList();
        }
        this.m_pseudoFiles.addFile(pfile);
    }

    public final boolean hasAccessDateTime() {
        return this.m_accessDate != 0L;
    }

    public final long getAccessDateTime() {
        return this.m_accessDate;
    }

    public final void updateAccessDateTime() {
        this.m_accessDate = System.currentTimeMillis();
    }

    public final boolean hasChangeDateTime() {
        return this.m_changeDate != 0L;
    }

    public final long getChangeDateTime() {
        return this.m_changeDate;
    }

    public final void updateChangeDateTime() {
        this.m_changeDate = System.currentTimeMillis();
    }

    public final boolean hasModifyDateTime() {
        return this.m_modifyDate != 0L;
    }

    public final long getModifyDateTime() {
        return this.m_modifyDate;
    }

    public final void updateModifyDateTime() {
        this.m_accessDate = this.m_modifyDate = System.currentTimeMillis();
    }

    public final void updateModifyDateTime(long modTime) {
        this.m_modifyDate = modTime;
    }

    public final boolean hasFilesystemObject() {
        return this.m_filesysObj != null;
    }

    public final Object getFilesystemObject() {
        return this.m_filesysObj;
    }

    public final void setFilesystemObject(Object filesysObj) {
        this.m_filesysObj = filesysObj;
    }

    public final boolean hasAllocationSize() {
        return this.m_allocSize > 0L;
    }

    public final long getAllocationSize() {
        return this.m_allocSize;
    }

    public final void setAllocationSize(long allocSize) {
        this.m_allocSize = allocSize;
    }

    public static final String normalizePath(String path) {
        return FileState.normalizePath(path, true);
    }

    public static final String normalizePath(String path, boolean caseSensitive) {
        String normPath = path;
        if (caseSensitive) {
            int pos;
            if (path.length() > 3 && (pos = path.lastIndexOf(92)) != -1) {
                String pathPart = path.substring(0, pos).toUpperCase();
                String namePart = path.substring(pos);
                normPath = pathPart + namePart;
            }
        } else {
            normPath = path.toUpperCase();
        }
        return normPath;
    }

    public final void DumpAttributes(PrintStream out) {
        if (this.m_cache != null) {
            Enumeration<String> names = this.m_cache.keys();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                Object attrib = this.m_cache.get(name);
                out.println("++    " + name + " : " + attrib);
            }
        } else {
            out.println("++    No Attributes");
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getPath());
        str.append(",");
        str.append(FileStatus.asString(this.getFileStatus()));
        str.append(":Opn=");
        str.append(this.getOpenCount());
        str.append(",Str=");
        str.append(",Fid=");
        str.append(this.getFileId());
        str.append(",Expire=");
        str.append(this.getSecondsToExpire(System.currentTimeMillis()));
        str.append(",Sts=");
        str.append(_fileStates[this.getStatus()]);
        str.append(",Locks=");
        str.append(this.numberOfLocks());
        if (this.hasOpLock()) {
            str.append(",OpLock=");
            str.append(this.getOpLock());
        }
        str.append("]");
        return str.toString();
    }
}

