/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.thread;

import java.util.LinkedList;
import java.util.Vector;
import org.alfresco.jlan.server.thread.ThreadRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadRequestQueue {
    private LinkedList<ThreadRequest> m_queue = new LinkedList();

    public final int numberOfRequests() {
        return this.m_queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRequest(ThreadRequest req) {
        LinkedList<ThreadRequest> linkedList = this.m_queue;
        synchronized (linkedList) {
            this.m_queue.add(req);
            this.m_queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRequests(Vector<ThreadRequest> reqList) {
        LinkedList<ThreadRequest> linkedList = this.m_queue;
        synchronized (linkedList) {
            for (int i = 0; i < reqList.size(); ++i) {
                this.m_queue.add(reqList.get(i));
                this.m_queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ThreadRequest removeRequest() throws InterruptedException {
        LinkedList<ThreadRequest> linkedList = this.m_queue;
        synchronized (linkedList) {
            while (this.m_queue.size() == 0) {
                this.m_queue.wait();
            }
            return this.m_queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitWhileEmpty() throws InterruptedException {
        LinkedList<ThreadRequest> linkedList = this.m_queue;
        synchronized (linkedList) {
            while (this.m_queue.size() == 0) {
                this.m_queue.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitUntilEmpty() throws InterruptedException {
        LinkedList<ThreadRequest> linkedList = this.m_queue;
        synchronized (linkedList) {
            while (this.m_queue.size() != 0) {
                this.m_queue.wait();
            }
        }
    }
}

