/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc;

import org.alfresco.jlan.smb.dcerpc.UUID;

public class DCEPipeType {
    private static final String[] _pipeNames = new String[]{"\\PIPE\\srvsvc", "\\PIPE\\samr", "\\PIPE\\winreg", "\\PIPE\\wkssvc", "\\PIPE\\NETLOGON", "\\PIPE\\lsarpc", "\\PIPE\\spoolss", "\\PIPE\\netdfs", "\\PIPE\\svcctl", "\\PIPE\\EVENTLOG", "\\PIPE\\NETLOGON"};
    private static final String[] _srvNames = new String[]{"\\PIPE\\ntsvcs", "\\PIPE\\lsass", "\\PIPE\\winreg", "\\PIPE\\ntsvcs", "\\PIPE\\lsass", "\\PIPE\\lsass", "\\PIPE\\spoolss", "\\PIPE\\netdfs", "\\PIPE\\svcctl", "\\PIPE\\EVENTLOG"};
    public static final int PIPE_SRVSVC = 0;
    public static final int PIPE_SAMR = 1;
    public static final int PIPE_WINREG = 2;
    public static final int PIPE_WKSSVC = 3;
    public static final int PIPE_NETLOGON = 4;
    public static final int PIPE_LSARPC = 5;
    public static final int PIPE_SPOOLSS = 6;
    public static final int PIPE_NETDFS = 7;
    public static final int PIPE_SVCCTL = 8;
    public static final int PIPE_EVENTLOG = 9;
    public static final int PIPE_NETLOGON1 = 10;
    private static UUID _uuidNetLogon = new UUID("8a885d04-1ceb-11c9-9fe8-08002b104860", 2);
    private static UUID _uuidWinReg = new UUID("338cd001-2244-31f1-aaaa-900038001003", 1);
    private static UUID _uuidSvcCtl = new UUID("367abb81-9844-35f1-ad32-98f038001003", 2);
    private static UUID _uuidLsaRpc = new UUID("12345678-1234-abcd-ef00-0123456789ab", 0);
    private static UUID _uuidSrvSvc = new UUID("4b324fc8-1670-01d3-1278-5a47bf6ee188", 3);
    private static UUID _uuidWksSvc = new UUID("6bffd098-a112-3610-9833-46c3f87e345a", 1);
    private static UUID _uuidSamr = new UUID("12345778-1234-abcd-ef00-0123456789ac", 1);
    private static UUID _uuidSpoolss = new UUID("12345778-1234-abcd-ef00-0123456789ab", 1);
    private static UUID _uuidSvcctl = new UUID("367abb81-9844-35f1-ad32-98f038001003", 2);
    private static UUID _uuidEventLog = new UUID("82273FDC-E32A-18C3-3F78-827929DC23EA", 0);
    private static UUID _uuidNetLogon1 = new UUID("12345678-1234-abcd-ef00-01234567cffb", 1);

    public static final int getNameAsType(String name) {
        for (int i = 0; i < _pipeNames.length; ++i) {
            if (!_pipeNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static final String getTypeAsString(int typ) {
        if (typ >= 0 && typ < _pipeNames.length) {
            return _pipeNames[typ];
        }
        return null;
    }

    public static final String getTypeAsStringShort(int typ) {
        if (typ >= 0 && typ < _pipeNames.length) {
            String name = _pipeNames[typ];
            return name.substring(5);
        }
        return null;
    }

    public static final UUID getUUIDForType(int typ) {
        UUID ret = null;
        switch (typ) {
            case 4: {
                ret = _uuidNetLogon;
                break;
            }
            case 10: {
                ret = _uuidNetLogon1;
                break;
            }
            case 2: {
                ret = _uuidWinReg;
                break;
            }
            case 5: {
                ret = _uuidLsaRpc;
                break;
            }
            case 3: {
                ret = _uuidWksSvc;
                break;
            }
            case 1: {
                ret = _uuidSamr;
                break;
            }
            case 0: {
                ret = _uuidSrvSvc;
                break;
            }
            case 6: {
                ret = _uuidSpoolss;
                break;
            }
            case 8: {
                ret = _uuidSvcCtl;
                break;
            }
            case 9: {
                ret = _uuidEventLog;
            }
        }
        return ret;
    }

    public static final String getServerPipeName(int typ) {
        if (typ >= 0 && typ < _srvNames.length) {
            return _srvNames[typ];
        }
        return null;
    }
}

