/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.server;

import org.alfresco.jlan.smb.dcerpc.DCECommand;
import org.alfresco.jlan.smb.dcerpc.DCEDataPacker;
import org.alfresco.jlan.smb.server.SMBTransPacket;
import org.alfresco.jlan.util.DataPacker;

public class DCESrvPacket
extends SMBTransPacket {
    private static final int VERSIONMAJOR = 0;
    private static final int VERSIONMINOR = 1;
    private static final int PDUTYPE = 2;
    private static final int HEADERFLAGS = 3;
    private static final int PACKEDDATAREP = 4;
    private static final int FRAGMENTLEN = 8;
    private static final int AUTHLEN = 10;
    private static final int CALLID = 12;
    private static final int DCEDATA = 16;
    private static final int ALLOCATIONHINT = 16;
    private static final int PRESENTIDENT = 20;
    private static final int OPERATIONID = 22;
    private static final int OPERATIONDATA = 24;
    public static final int FLG_FIRSTFRAG = 1;
    public static final int FLG_LASTFRAG = 2;
    public static final int FLG_ONLYFRAG = 3;
    private static final byte HDR_VERSIONMAJOR = 5;
    private static final byte HDR_VERSIONMINOR = 0;
    private static final int HDR_PACKEDDATAREP = 16;
    private int m_offset;

    public DCESrvPacket(byte[] buf) {
        super(buf);
    }

    public DCESrvPacket(int siz) {
        super(siz);
        this.setMultiplexId(DCESrvPacket.getNextMultiplexId());
    }

    public final int getMajorVersion() {
        return this.getBuffer()[this.m_offset + 0] & 0xFF;
    }

    public final int getMinorVersion() {
        return this.getBuffer()[this.m_offset + 1] & 0xFF;
    }

    public final int getPDUType() {
        return this.getBuffer()[this.m_offset + 2] & 0xFF;
    }

    public final int getDCEHeaderFlags() {
        return this.getBuffer()[this.m_offset + 3] & 0xFF;
    }

    public final int getPackedDataRepresentation() {
        return DataPacker.getIntelInt(this.getBuffer(), this.m_offset + 4);
    }

    public final int getFragmentLength() {
        return DataPacker.getIntelShort(this.getBuffer(), this.m_offset + 8);
    }

    public final void setFragmentLength(int len) {
        DataPacker.putIntelShort(len, this.getBuffer(), this.m_offset + 8);
    }

    public final int getAuthenticationLength() {
        return DataPacker.getIntelShort(this.getBuffer(), this.m_offset + 10);
    }

    public final int getCallId() {
        return DataPacker.getIntelInt(this.getBuffer(), this.m_offset + 12);
    }

    public final boolean isFirstFragment() {
        return (this.getDCEHeaderFlags() & 1) != 0;
    }

    public final boolean isLastFragment() {
        return (this.getDCEHeaderFlags() & 2) != 0;
    }

    public final boolean isOnlyFragment() {
        return (this.getDCEHeaderFlags() & 3) == 3;
    }

    public final int getDCEDataOffset() {
        int dataOff = -1;
        switch (this.getPDUType()) {
            case 11: 
            case 12: {
                dataOff = this.m_offset + 16;
                break;
            }
            case 0: 
            case 2: {
                dataOff = this.m_offset + 24;
            }
        }
        return dataOff;
    }

    public final int getAllocationHint() {
        return DataPacker.getIntelInt(this.getBuffer(), this.m_offset + 16);
    }

    public final void setAllocationHint(int alloc) {
        DataPacker.putIntelInt(alloc, this.getBuffer(), this.m_offset + 16);
    }

    public final int getPresentationIdentifier() {
        return DataPacker.getIntelShort(this.getBuffer(), this.m_offset + 20);
    }

    public final void setPresentationIdentifier(int ident) {
        DataPacker.putIntelShort(ident, this.getBuffer(), this.m_offset + 20);
    }

    public final int getOperationId() {
        return DataPacker.getIntelShort(this.getBuffer(), this.m_offset + 22);
    }

    public final void initializeDCERequest(int handle, byte typ, int flags, int callId) {
        this.InitializeTransact(16, null, 0, null, 0);
        int bytPos = DCEDataPacker.longwordAlign(this.getByteOffset());
        this.setParameter(3, 0);
        this.setParameter(4, bytPos - 4);
        this.setParameter(5, 0);
        this.setParameter(6, 0);
        this.setParameter(7, bytPos - 4);
        this.setParameter(8, 0);
        this.setParameter(9, 0);
        this.setSetupParameter(0, 38);
        this.setSetupParameter(1, handle);
        this.m_offset = bytPos;
        byte[] buf = this.getBuffer();
        DataPacker.putZeros(buf, this.m_offset, 24);
        buf[this.m_offset + 0] = 5;
        buf[this.m_offset + 1] = 0;
        buf[this.m_offset + 2] = typ;
        buf[this.m_offset + 3] = (byte)(flags & 0xFF);
        DataPacker.putIntelInt(16, buf, this.m_offset + 4);
        DataPacker.putIntelInt(0, buf, this.m_offset + 10);
        DataPacker.putIntelInt(callId, buf, this.m_offset + 12);
    }

    public final void initializeDCEReply() {
        this.setParameterCount(10);
        this.setParameter(0, 0);
        this.setParameter(1, 0);
        int bytPos = DCEDataPacker.longwordAlign(this.getByteOffset());
        this.setParameter(3, 0);
        this.setParameter(4, bytPos - 4);
        this.setParameter(5, 0);
        this.setParameter(6, 0);
        this.setParameter(7, bytPos - 4);
        this.setParameter(8, 0);
        this.setParameter(9, 0);
    }

    public final void DumpHeader() {
        System.out.println("** DCE/RPC Header - PDU Type = " + DCECommand.getCommandString(this.getPDUType()));
        System.out.println("  Version         : " + this.getMajorVersion() + "." + this.getMinorVersion());
        System.out.println("  Flags           : 0x" + this.getDCEHeaderFlags());
        System.out.println("  Packed Data Rep : 0x" + this.getPackedDataRepresentation());
        System.out.println("  Fragment Length : " + this.getFragmentLength());
        System.out.println("  Auth Length     : " + this.getAuthenticationLength());
        System.out.println("  Call ID         : " + this.getCallId());
    }
}

