/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Time;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.locking.FileLock;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.locking.NotLockedException;
import org.alfresco.jlan.server.auth.ICifsAuthenticator;
import org.alfresco.jlan.server.auth.InvalidUserException;
import org.alfresco.jlan.server.auth.acl.AccessControlManager;
import org.alfresco.jlan.server.core.InvalidDeviceInterfaceException;
import org.alfresco.jlan.server.core.ShareType;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DeferredPacketException;
import org.alfresco.jlan.server.filesys.DirectoryNotEmptyException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskOfflineException;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.FileAccess;
import org.alfresco.jlan.server.filesys.FileAction;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileNameException;
import org.alfresco.jlan.server.filesys.FileOfflineException;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.FileSharingException;
import org.alfresco.jlan.server.filesys.IOControlNotImplementedException;
import org.alfresco.jlan.server.filesys.IOCtlInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.PathNotFoundException;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.SecurityDescriptorInterface;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.TooManyConnectionsException;
import org.alfresco.jlan.server.filesys.TooManyFilesException;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.UnsupportedInfoLevelException;
import org.alfresco.jlan.server.filesys.VolumeInfo;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockDetails;
import org.alfresco.jlan.server.locking.OpLockInterface;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.smb.InvalidUNCPathException;
import org.alfresco.jlan.smb.LockingAndX;
import org.alfresco.jlan.smb.NTTime;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.SMBDate;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.nt.LoadException;
import org.alfresco.jlan.smb.nt.NTIOCtl;
import org.alfresco.jlan.smb.nt.SaveException;
import org.alfresco.jlan.smb.nt.SecurityDescriptor;
import org.alfresco.jlan.smb.server.CIFSThreadRequest;
import org.alfresco.jlan.smb.server.CoreProtocolHandler;
import org.alfresco.jlan.smb.server.DiskInfoPacker;
import org.alfresco.jlan.smb.server.FindInfoPacker;
import org.alfresco.jlan.smb.server.IPCHandler;
import org.alfresco.jlan.smb.server.NTParameterPacker;
import org.alfresco.jlan.smb.server.NTTransPacket;
import org.alfresco.jlan.smb.server.QueryInfoPacker;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.SMBSrvTransPacket;
import org.alfresco.jlan.smb.server.SrvTransactBuffer;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.smb.server.notify.NotifyChangeEventList;
import org.alfresco.jlan.smb.server.notify.NotifyChangeHandler;
import org.alfresco.jlan.smb.server.notify.NotifyRequest;
import org.alfresco.jlan.smb.server.ntfs.NTFSStreamsInterface;
import org.alfresco.jlan.smb.server.ntfs.StreamInfoList;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.MemorySize;
import org.alfresco.jlan.util.WildCard;

public class NTProtocolHandler
extends CoreProtocolHandler {
    public static final boolean ReturnDotFiles = true;
    public static final long DotFileDateTime = System.currentTimeMillis();
    public static final boolean FakeOpLocks = false;
    public static final int FileSizeChangeRate = 10;
    public static final int MaxPathLength = 255;
    public static final int NTFSStreamsInfoBufsize = 4096;
    private static byte[] _sdEveryOne = new byte[]{1, 0, 4, -128, 20, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 28, 0, 1, 0, 0, 0, 0, 0, 20, 0, -1, 1, 31, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};

    protected NTProtocolHandler() {
    }

    protected NTProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    public String getName() {
        return "NT";
    }

    public boolean runProtocol(SMBSrvPacket smbPkt) throws IOException, SMBSrvException, TooManyConnectionsException {
        if (!smbPkt.checkPacketSignature()) {
            throw new IOException("Invalid SMB signature");
        }
        if (this.m_sess.hasDebug(2) && this.hasChainedCommand(smbPkt)) {
            this.m_sess.debugPrintln("AndX Command = 0x" + Integer.toHexString(smbPkt.getAndXCommand()));
        }
        smbPkt.resetBytePointer();
        this.m_sess.setProcessId(smbPkt.getProcessId());
        boolean handledOK = true;
        switch (smbPkt.getCommand()) {
            case 115: {
                this.procSessionSetup(smbPkt);
                break;
            }
            case 117: {
                this.procTreeConnectAndX(smbPkt);
                break;
            }
            case 37: 
            case 50: {
                this.procTransact2(smbPkt);
                break;
            }
            case 38: 
            case 51: {
                this.procTransact2Secondary(smbPkt);
                break;
            }
            case 52: {
                this.procFindClose(smbPkt);
                break;
            }
            case 45: {
                this.procOpenAndX(smbPkt);
                break;
            }
            case 4: {
                this.procCloseFile(smbPkt);
                break;
            }
            case 46: {
                this.procReadAndX(smbPkt);
                break;
            }
            case 47: {
                this.procWriteAndX(smbPkt);
                break;
            }
            case 7: {
                this.procRenameFile(smbPkt);
                break;
            }
            case 6: {
                this.procDeleteFile(smbPkt);
                break;
            }
            case 1: {
                this.procDeleteDirectory(smbPkt);
                break;
            }
            case 113: {
                this.procTreeDisconnect(smbPkt);
                break;
            }
            case 36: {
                this.procLockingAndX(smbPkt);
                break;
            }
            case 116: {
                this.procLogoffAndX(smbPkt);
                break;
            }
            case 162: {
                this.procNTCreateAndX(smbPkt);
                break;
            }
            case 112: {
                super.runProtocol(smbPkt);
                break;
            }
            case 164: {
                this.procNTCancel(smbPkt);
                break;
            }
            case 160: {
                this.procNTTransaction(smbPkt);
                break;
            }
            case 161: {
                this.procNTTransactionSecondary(smbPkt);
                break;
            }
            case 43: {
                super.procEcho(smbPkt);
                break;
            }
            default: {
                int treeId = smbPkt.getTreeId();
                TreeConnection conn = null;
                if (treeId != -1) {
                    conn = this.m_sess.findTreeConnection(smbPkt);
                }
                if (conn != null) {
                    if (conn.getSharedDevice().getType() == 0 || conn.getSharedDevice().getType() == 1) {
                        handledOK = super.runProtocol(smbPkt);
                        break;
                    }
                    if (conn.getSharedDevice().getType() != 3) break;
                    IPCHandler.processIPCRequest(this.m_sess, smbPkt);
                    handledOK = true;
                    break;
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            }
        }
        return handledOK;
    }

    protected void procSessionSetup(SMBSrvPacket smbPkt) throws SMBSrvException, IOException, TooManyConnectionsException {
        ICifsAuthenticator cifsAuthenticator = this.m_sess.getSMBServer().getCifsAuthenticator();
        try {
            cifsAuthenticator.processSessionSetup(this.m_sess, smbPkt);
        }
        catch (SMBSrvException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, ex.getNTErrorCode(), ex.getErrorCode(), ex.getErrorClass());
            return;
        }
        SMBSrvPacket outPkt = smbPkt;
        if (smbPkt.hasAssociatedPacket() && !smbPkt.hasAndXCommand()) {
            outPkt = outPkt.getAssociatedPacket();
        }
        int pos = outPkt.getLength();
        if (smbPkt.hasAndXCommand() && smbPkt.getPosition() < smbPkt.getReceivedLength()) {
            pos = this.procAndXCommands(outPkt, null);
            pos -= 4;
            outPkt = smbPkt.getAssociatedPacket();
        } else {
            outPkt.setAndXCommand(255);
        }
        this.m_sess.sendResponseSMB(outPkt, pos);
        if (outPkt.getLongErrorCode() == 0) {
            this.m_sess.setState(3);
            this.m_sess.getSMBServer().sessionLoggedOn(this.m_sess);
        }
    }

    protected final int procAndXCommands(SMBSrvPacket smbPkt, NetworkFile file) {
        SMBSrvPacket respPkt = smbPkt.getAssociatedPacket();
        if (respPkt == null) {
            throw new RuntimeException("No response packet allocated for AndX request");
        }
        int andxCmd = smbPkt.getAndXCommand();
        int andxOff = smbPkt.getParameter(1) + 4;
        respPkt.setAndXCommand(andxCmd);
        int endOfPkt = respPkt.getByteOffset() + respPkt.getByteCount();
        respPkt.setParameter(1, endOfPkt - 4);
        int paramBlk = 36;
        boolean andxErr = false;
        while (andxCmd != 255 && !andxErr) {
            int prevEndOfPkt = endOfPkt;
            boolean endOfChain = false;
            switch (andxCmd) {
                case 117: {
                    endOfPkt = this.procChainedTreeConnectAndX(andxOff, smbPkt, respPkt, endOfPkt);
                    break;
                }
                case 4: {
                    endOfPkt = this.procChainedClose(andxOff, smbPkt, respPkt, endOfPkt);
                    endOfChain = true;
                    break;
                }
                case 46: {
                    endOfPkt = this.procChainedReadAndX(andxOff, smbPkt, respPkt, endOfPkt, file);
                    break;
                }
                default: {
                    Debug.println("<<<<< Chained command : 0x" + Integer.toHexString(andxCmd) + " Not Processed >>>>>");
                }
            }
            respPkt.setAndXCommand(paramBlk, andxCmd);
            respPkt.setAndXParameter(paramBlk, 1, prevEndOfPkt - 4);
            if (!endOfChain) {
                andxCmd = smbPkt.getAndXParameter(andxOff, 0) & 0xFF;
                andxOff = smbPkt.getAndXParameter(andxOff, 1);
                paramBlk = prevEndOfPkt;
            } else {
                andxCmd = 255;
            }
            if (respPkt.getErrorCode() == 0) continue;
            andxErr = true;
        }
        return endOfPkt;
    }

    protected final int procChainedTreeConnectAndX(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff) {
        String devType;
        byte[] outBuf;
        int pos;
        block28: {
            boolean unicode;
            String uncPath;
            int flags = smbPkt.getAndXParameter(cmdOff, 2);
            int pwdLen = smbPkt.getAndXParameter(cmdOff, 3);
            VirtualCircuit vc = this.m_sess.findVirtualCircuit(respPkt.getUserId());
            if (vc == null) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            smbPkt.setBytePointer(smbPkt.getAndXByteOffset(cmdOff), smbPkt.getAndXByteCount(cmdOff));
            String pwd = null;
            if (pwdLen > 0) {
                byte[] pwdByt = smbPkt.unpackBytes(pwdLen);
                pwd = new String(pwdByt);
            }
            if ((uncPath = smbPkt.unpackString(unicode = smbPkt.isUnicode())) == null) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            String service = smbPkt.unpackString(false);
            if (service == null) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            int servType = ShareType.ServiceAsType(service);
            if (servType == -1 && service.compareTo("?????") != 0) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            if (this.m_sess.hasDebug(64)) {
                this.m_sess.debugPrintln("NT ANDX Tree Connect AndX - " + uncPath + ", " + service);
            }
            PCShare share = null;
            try {
                share = new PCShare(uncPath);
            }
            catch (InvalidUNCPathException ex) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            if (share.getShareName().compareTo("IPC$") == 0) {
                servType = 3;
            }
            if (this.m_sess.hasClientInformation() && this.m_sess.getClientInformation().isNullSession() && servType != 3) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741790, 5, 1);
                return endOff;
            }
            SharedDevice shareDev = null;
            try {
                shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.m_sess, true);
            }
            catch (InvalidUserException ex) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741715, 5, 1);
                return endOff;
            }
            catch (Exception ex) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741620, 6, 2);
                return endOff;
            }
            if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741620, 6, 2);
                return endOff;
            }
            ICifsAuthenticator auth = this.getSession().getSMBServer().getCifsAuthenticator();
            int sharePerm = 2;
            if (auth != null && auth.getAccessMode() == 0 && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) < 0) {
                respPkt.setError(smbPkt.isLongErrorCode(), -1073741790, 5, 1);
                return endOff;
            }
            if (this.getSession().getServer().hasAccessControlManager() && shareDev.hasAccessControls()) {
                AccessControlManager aclMgr = this.getSession().getServer().getAccessControlManager();
                int aclPerm = aclMgr.checkAccessControl(this.getSession(), shareDev);
                if (aclPerm == 0) {
                    respPkt.setError(smbPkt.isLongErrorCode(), -1073741790, 5, 1);
                    return endOff;
                }
                if (aclPerm != -1) {
                    sharePerm = aclPerm;
                }
            }
            TreeConnection tree = null;
            try {
                int treeId = vc.addConnection(shareDev);
                respPkt.setTreeId(treeId);
                tree = vc.findConnection(treeId);
                tree.setPermission(sharePerm);
                if (tree.getInterface() != null) {
                    tree.getInterface().treeOpened(this.m_sess, tree);
                }
                if (this.m_sess.hasDebug(64)) {
                    this.m_sess.debugPrintln("ANDX Tree Connect AndX - Allocated Tree Id = " + treeId);
                }
            }
            catch (TooManyConnectionsException ex) {
                respPkt.setError(89, 2);
                return endOff;
            }
            respPkt.setAndXParameterCount(endOff, 2);
            respPkt.setAndXParameter(endOff, 0, 255);
            respPkt.setAndXParameter(endOff, 1, 0);
            pos = respPkt.getAndXByteOffset(endOff);
            outBuf = respPkt.getBuffer();
            pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), outBuf, pos, true);
            devType = "";
            try {
                if (shareDev.getType() == 0) {
                    if (shareDev.getInterface() instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)shareDev.getInterface());
                        if (ntfsStreams.hasStreamsEnabled(this.m_sess, tree)) {
                            devType = "NTFS";
                        }
                    } else {
                        DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                        devType = diskCtx.getFilesystemType();
                    }
                }
            }
            catch (InvalidDeviceInterfaceException ex) {
                if (!this.m_sess.hasDebug(64)) break block28;
                Debug.println("ANDX TreeConnectAndX error " + ex.getMessage());
            }
        }
        pos = DataPacker.putString(devType, outBuf, pos, true, respPkt.isUnicode());
        int bytLen = pos - respPkt.getAndXByteOffset(endOff);
        respPkt.setAndXByteCount(endOff, bytLen);
        return pos;
    }

    protected final int procChainedReadAndX(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff, NetworkFile netFile) {
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            respPkt.setError(15, 1);
            return endOff;
        }
        long offset = smbPkt.getAndXParameterLong(cmdOff, 3);
        offset &= 0xFFFFFFFFL;
        int maxCount = smbPkt.getAndXParameter(cmdOff, 5);
        if (smbPkt.getAndXParameterCount(cmdOff) == 12) {
            long topOff = smbPkt.getAndXParameterLong(cmdOff, 10);
            offset += topOff << 32;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Chained File Read AndX : Size=" + maxCount + " ,Pos=" + offset);
        }
        byte[] buf = respPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            respPkt.setAndXParameterCount(endOff, 12);
            dataPos = respPkt.getAndXByteOffset(endOff);
            dataPos = DataPacker.wordAlign(dataPos);
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
            respPkt.setAndXParameter(endOff, 0, 255);
            respPkt.setAndXParameter(endOff, 1, 0);
            respPkt.setAndXParameter(endOff, 2, 0);
            respPkt.setAndXParameter(endOff, 3, 0);
            respPkt.setAndXParameter(endOff, 4, 0);
            respPkt.setAndXParameter(endOff, 5, rdlen);
            respPkt.setAndXParameter(endOff, 6, dataPos - 4);
            for (int i = 7; i < 12; ++i) {
                respPkt.setAndXParameter(endOff, i, 0);
            }
            respPkt.setAndXByteCount(endOff, dataPos + rdlen - respPkt.getAndXByteOffset(endOff));
            endOff = dataPos + rdlen;
        }
        catch (InvalidDeviceInterfaceException ex) {
            respPkt.setError(13, 1);
            return endOff;
        }
        catch (IOException ex) {
            // empty catch block
        }
        return endOff;
    }

    protected final int procChainedClose(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff) {
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            respPkt.setError(15, 1);
            return endOff;
        }
        int fid = smbPkt.getAndXParameter(cmdOff, 0);
        int ftime = smbPkt.getAndXParameter(cmdOff, 1);
        int fdate = smbPkt.getAndXParameter(cmdOff, 2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            respPkt.setError(15, 1);
            return endOff;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Chained File Close [" + smbPkt.getTreeId() + "] fid=" + fid);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (InvalidDeviceInterfaceException ex) {
            respPkt.setError(13, 1);
            return endOff;
        }
        catch (IOException ex) {
            // empty catch block
        }
        respPkt.setAndXParameterCount(endOff, 0);
        respPkt.setAndXByteCount(endOff, 0);
        endOff = respPkt.getAndXByteOffset(endOff) - 4;
        conn.removeFile(fid, this.getSession());
        return endOff;
    }

    protected void procTreeConnectAndX(SMBSrvPacket smbPkt) throws SMBSrvException, TooManyConnectionsException, IOException {
        String devType;
        int pos;
        TreeConnection tree;
        block30: {
            String uncPath;
            if (!smbPkt.checkPacketIsValid(4, 3)) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
            if (vc == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            int flags = smbPkt.getParameter(2);
            int pwdLen = smbPkt.getParameter(3);
            smbPkt.resetBytePointer();
            boolean unicode = smbPkt.isUnicode();
            String pwd = null;
            if (pwdLen > 0) {
                byte[] pwdByts = smbPkt.unpackBytes(pwdLen);
                pwd = new String(pwdByts);
            }
            if ((uncPath = smbPkt.unpackString(unicode)) == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            String service = smbPkt.unpackString(false);
            if (service == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            int servType = ShareType.ServiceAsType(service);
            if (servType == -1 && service.compareTo("?????") != 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            if (this.m_sess.hasDebug(64)) {
                this.m_sess.debugPrintln("NT Tree Connect AndX - " + uncPath + ", " + service);
            }
            String shareName = null;
            String hostName = null;
            if (uncPath.startsWith("\\")) {
                try {
                    PCShare share = new PCShare(uncPath);
                    shareName = share.getShareName();
                    hostName = share.getNodeName();
                }
                catch (InvalidUNCPathException ex) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                    return;
                }
            } else {
                shareName = uncPath;
            }
            if (shareName.compareTo("IPC$") == 0) {
                servType = 3;
            }
            if (this.m_sess.hasClientInformation() && this.m_sess.getClientInformation().isNullSession() && servType != 3) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                return;
            }
            SharedDevice shareDev = null;
            try {
                shareDev = this.m_sess.getSMBServer().findShare(hostName, shareName, servType, this.m_sess, true);
            }
            catch (InvalidUserException ex) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741715, 5, 1);
                return;
            }
            catch (Exception ex) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741620, 6, 2);
                return;
            }
            if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741620, 6, 2);
                return;
            }
            ICifsAuthenticator auth = this.getSession().getSMBServer().getCifsAuthenticator();
            int sharePerm = 2;
            if (auth != null && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) < 0) {
                if (this.m_sess.hasDebug(64)) {
                    this.m_sess.debugPrint("Tree connect to " + shareName + ", access denied");
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                return;
            }
            if (this.getSession().getServer().hasAccessControlManager() && shareDev.hasAccessControls()) {
                AccessControlManager aclMgr = this.getSession().getServer().getAccessControlManager();
                int aclPerm = aclMgr.checkAccessControl(this.getSession(), shareDev);
                if (aclPerm == 0) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                    return;
                }
                if (aclPerm != -1) {
                    sharePerm = aclPerm;
                }
            }
            int treeId = vc.addConnection(shareDev);
            smbPkt.setTreeId(treeId);
            tree = vc.findConnection(treeId);
            tree.setPermission(sharePerm);
            if (this.m_sess.hasDebug(64)) {
                this.m_sess.debugPrintln("Tree Connect AndX - Allocated Tree Id = " + treeId + ", Permission = " + FileAccess.asString(sharePerm));
            }
            smbPkt.setParameterCount(3);
            smbPkt.setAndXCommand(255);
            smbPkt.setParameter(1, 0);
            smbPkt.setParameter(2, 0);
            pos = smbPkt.getByteOffset();
            pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), smbPkt.getBuffer(), pos, true);
            devType = "";
            try {
                if (shareDev.getType() == 0) {
                    if (shareDev.getInterface() instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)shareDev.getInterface());
                        if (ntfsStreams.hasStreamsEnabled(this.m_sess, tree)) {
                            devType = "NTFS";
                        }
                    } else {
                        DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                        devType = diskCtx.getFilesystemType();
                    }
                }
            }
            catch (InvalidDeviceInterfaceException ex) {
                if (!this.m_sess.hasDebug(64)) break block30;
                Debug.println("TreeConnectAndX error " + ex.getMessage());
            }
        }
        pos = DataPacker.wordAlign(pos);
        pos = DataPacker.putString(devType, smbPkt.getBuffer(), pos, true, smbPkt.isUnicode());
        smbPkt.setByteCount(pos - smbPkt.getByteOffset());
        this.m_sess.sendResponseSMB(smbPkt);
        if (tree.getInterface() != null) {
            tree.getInterface().treeOpened(this.m_sess, tree);
        }
    }

    protected void procCloseFile(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(3, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        int fid = smbPkt.getParameter(0);
        int ftime = smbPkt.getParameter(1);
        int fdate = smbPkt.getParameter(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File close [" + smbPkt.getTreeId() + "] fid=" + fid + ", fileId=" + netFile.getFileId());
        }
        boolean delayedClose = false;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                long startTime = 0L;
                if (netFile.hasDeleteOnClose() && this.m_sess.hasDebug(0x4000000)) {
                    startTime = System.currentTimeMillis();
                }
                if (netFile.hasOpLock()) {
                    this.releaseOpLock(this.m_sess, smbPkt, disk, conn, netFile);
                }
                disk.closeFile(this.m_sess, conn, netFile);
                if (netFile.hasDelayedClose()) {
                    delayedClose = true;
                    netFile.setDelayedClose(false);
                    if (this.m_sess.hasDebug(512)) {
                        this.m_sess.debugPrintln("File close delayed [" + smbPkt.getTreeId() + "] fid=" + fid + ", path=" + netFile.getFullName());
                    }
                }
                if (startTime != 0L && this.m_sess.hasDebug(0x4000000)) {
                    Debug.println("Benchmark: Delete on close " + netFile.getName() + " took " + (System.currentTimeMillis() - startTime) + "ms");
                }
            }
            if (!delayedClose) {
                netFile.setClosed(true);
            }
            if (this.m_sess.hasDebug(0x4000000)) {
                if (!netFile.isDirectory()) {
                    if (netFile.wasCreated() && netFile.getWriteCount() > 0) {
                        this.m_sess.debugPrintln("Benchmark: File=" + netFile.getFullName() + ", Size=" + MemorySize.asScaledString(netFile.getFileSize()) + ", Write Time=" + (System.currentTimeMillis() - netFile.getCreationDate()) + "ms" + ", ClosedAt=" + new Time(System.currentTimeMillis()));
                    }
                } else if (netFile.getCreationDate() != 0L) {
                    this.m_sess.debugPrintln("Benchmark: Dir=" + netFile.getFullName() + ", Write Time=" + (System.currentTimeMillis() - netFile.getCreationDate()) + "ms, CreatedAt=" + new Time(netFile.getCreationDate()));
                } else {
                    this.m_sess.debugPrintln("Benchmark: Dir=" + netFile.getFullName() + ", ClosedAt=" + new Time(System.currentTimeMillis()));
                }
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!delayedClose) {
            conn.removeFile(fid, this.getSession());
        }
        smbPkt.setParameterCount(0);
        smbPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (netFile.getWriteCount() > 0 && diskCtx.hasFileServerNotifications()) {
            diskCtx.getChangeHandler().notifyFileSizeChanged(netFile.getFullName());
        }
        if (netFile.hasDeleteOnClose() && diskCtx.hasFileServerNotifications()) {
            diskCtx.getChangeHandler().notifyFileChanged(2, netFile.getFullName());
        }
    }

    protected void procTransact2(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(14, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        TreeConnection conn = vc.findConnection(smbPkt.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        SMBSrvTransPacket tranPkt = new SMBSrvTransPacket(smbPkt.getBuffer());
        SrvTransactBuffer transBuf = null;
        int subCmd = tranPkt.getSubFunction();
        if (tranPkt.getTotalParameterCount() == tranPkt.getRxParameterBlockLength() && tranPkt.getTotalDataCount() == tranPkt.getRxDataBlockLength()) {
            transBuf = new SrvTransactBuffer(tranPkt);
        } else {
            transBuf = new SrvTransactBuffer(tranPkt.getSetupCount(), tranPkt.getTotalParameterCount(), tranPkt.getTotalDataCount());
            transBuf.setType(tranPkt.getCommand());
            transBuf.setFunction(subCmd);
            byte[] buf = tranPkt.getBuffer();
            transBuf.appendSetup(buf, tranPkt.getSetupOffset(), tranPkt.getSetupCount() * 2);
            transBuf.appendParameter(buf, tranPkt.getRxParameterBlock(), tranPkt.getRxParameterBlockLength());
            transBuf.appendData(buf, tranPkt.getRxDataBlock(), tranPkt.getRxDataBlockLength());
        }
        transBuf.setReturnLimits(tranPkt.getMaximumReturnSetupCount(), tranPkt.getMaximumReturnParameterCount(), tranPkt.getMaximumReturnDataCount());
        if (transBuf.isMultiPacket()) {
            vc.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB(smbPkt);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.procTransaction(vc, transBuf, this.m_sess, smbPkt);
            return;
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("Transaction [" + smbPkt.getTreeId() + "] tbuf=" + transBuf);
        }
        this.processTransactionBuffer(transBuf, smbPkt);
    }

    protected void procTransact2Secondary(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int dlen;
        if (!smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        if (!vc.hasTransaction() || vc.getTransaction().isType() == 37 && smbPkt.getCommand() != 38 || vc.getTransaction().isType() == 50 && smbPkt.getCommand() != 51) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 1, 2);
            return;
        }
        SMBSrvTransPacket tpkt = new SMBSrvTransPacket(smbPkt.getBuffer());
        byte[] buf = tpkt.getBuffer();
        SrvTransactBuffer transBuf = vc.getTransaction();
        int plen = tpkt.getSecondaryParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, tpkt.getSecondaryParameterBlockOffset(), plen);
        }
        if ((dlen = tpkt.getSecondaryDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, tpkt.getSecondaryDataBlockOffset(), dlen);
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("Transaction Secondary [" + treeId + "] paramLen=" + plen + ", dataLen=" + dlen);
        }
        int totParam = tpkt.getTotalParameterCount();
        int totData = tpkt.getTotalDataCount();
        int paramDisp = tpkt.getParameterBlockDisplacement();
        int dataDisp = tpkt.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("Transaction complete, processing ...");
            }
            vc.setTransaction(null);
            if (conn.getSharedDevice().getType() == 3) {
                IPCHandler.procTransaction(vc, transBuf, this.m_sess, smbPkt);
                return;
            }
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("Transaction second [" + treeId + "] tbuf=" + transBuf);
            }
            this.processTransactionBuffer(transBuf, smbPkt);
        } else {
            this.m_sess.sendSuccessResponseSMB(smbPkt);
        }
    }

    private final void processTransactionBuffer(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procTrans2FindFirst(tbuf, smbPkt);
                break;
            }
            case 2: {
                this.procTrans2FindNext(tbuf, smbPkt);
                break;
            }
            case 3: {
                this.procTrans2QueryFileSys(tbuf, smbPkt);
                break;
            }
            case 5: {
                this.procTrans2QueryPath(tbuf, smbPkt);
                break;
            }
            case 7: {
                this.procTrans2QueryFile(tbuf, smbPkt);
                break;
            }
            case 8: {
                this.procTrans2SetFile(tbuf, smbPkt);
                break;
            }
            case 6: {
                this.procTrans2SetPath(tbuf, smbPkt);
                break;
            }
            default: {
                this.m_sess.debugPrintln("NT Error Transact2 Command = 0x" + Integer.toHexString(tbuf.getFunction()));
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            }
        }
    }

    protected final void procFindClose(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        int searchId = smbPkt.getParameter(0);
        SearchContext ctx = vc.getSearchContext(searchId);
        if (ctx == null) {
            this.m_sess.sendSuccessResponseSMB(smbPkt);
            return;
        }
        if (this.m_sess.hasDebug(128)) {
            this.m_sess.debugPrintln("Close trans search [" + searchId + "]");
        }
        vc.deallocateSearchSlot(searchId);
        this.m_sess.sendSuccessResponseSMB(smbPkt);
    }

    protected final void procLockingAndX(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        int fid = smbPkt.getParameter(2);
        int lockType = smbPkt.getParameter(3);
        long lockTmo = smbPkt.getParameterLong(4);
        int unlockCnt = smbPkt.getParameter(6);
        int lockCnt = smbPkt.getParameter(7);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(32768)) {
            this.m_sess.debugPrintln("File Lock [" + netFile.getFileId() + "] : type=0x" + Integer.toHexString(lockType) + ", tmo=" + lockTmo + ", locks=" + lockCnt + ", unlocks=" + unlockCnt);
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (LockingAndX.hasOplockBreak(lockType)) {
            if (this.m_sess.hasDebug(0x8000000)) {
                Debug.println("Oplock break, file=" + netFile);
            }
            if (disk instanceof OpLockInterface) {
                OpLockInterface oplockIface = (OpLockInterface)((Object)disk);
                OpLockManager oplockMgr = oplockIface.getOpLockManager(this.m_sess, conn);
                if (oplockMgr == null) {
                    if (this.m_sess.hasDebug(0x8000000)) {
                        Debug.print("  OpLock manager is null, tree=" + conn);
                    }
                    this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
                    return;
                }
                OpLockDetails oplock = oplockMgr.getOpLockDetails(netFile.getFullName());
                if (oplock == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, 158, 1);
                    return;
                }
                oplockMgr.releaseOpLock(oplock.getPath());
                if (this.m_sess.hasDebug(0x8000000)) {
                    Debug.println("  Oplock released, oplock=" + oplock);
                }
                if (oplock.hasDeferredSession()) {
                    if (this.m_sess.hasDebug(0x8000000)) {
                        Debug.println("  Queued deferred request to thread pool sess=" + oplock.getDeferredSession().getUniqueId() + ", pkt=" + oplock.getDeferredPacket());
                    }
                    this.m_sess.getThreadPool().queueRequest(new CIFSThreadRequest(oplock.getDeferredSession(), oplock.getDeferredPacket()));
                    return;
                }
            } else {
                this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
                return;
            }
        }
        if (unlockCnt > 0 || lockCnt > 0) {
            if (disk instanceof FileLockingInterface) {
                FileLockingInterface lockInterface = (FileLockingInterface)((Object)disk);
                LockManager lockMgr = lockInterface.getLockManager(this.m_sess, conn);
                smbPkt.resetBytePointer();
                boolean largeFileLock = LockingAndX.hasLargeFiles(lockType);
                int lockIdx = 0;
                while (lockIdx < unlockCnt + lockCnt) {
                    boolean isLock;
                    int pid = smbPkt.unpackWord();
                    long offset = -1L;
                    long length = -1L;
                    if (!largeFileLock) {
                        offset = smbPkt.unpackInt();
                        length = smbPkt.unpackInt();
                    } else {
                        smbPkt.skipBytes(2);
                        offset = (long)smbPkt.unpackInt() << 32;
                        offset += (long)smbPkt.unpackInt();
                        length = (long)smbPkt.unpackInt() << 32;
                        length += (long)smbPkt.unpackInt();
                    }
                    FileLock fLock = lockMgr.createLockObject(this.m_sess, conn, netFile, offset, length, pid);
                    boolean bl = isLock = lockIdx++ < lockCnt;
                    if (this.m_sess.hasDebug(32768)) {
                        this.m_sess.debugPrintln("  " + (isLock ? "Lock" : "UnLock") + " lock=" + fLock);
                    }
                    try {
                        if (!isLock) {
                            lockMgr.unlockFile(this.m_sess, conn, netFile, fLock);
                            continue;
                        }
                        lockMgr.lockFile(this.m_sess, conn, netFile, fLock);
                    }
                    catch (NotLockedException ex) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, 158, 1);
                        return;
                    }
                    catch (LockConflictException ex) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741739, 33, 1);
                        return;
                    }
                    catch (IOException ex) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, 65, 2);
                        return;
                    }
                }
            } else if (unlockCnt > 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 158, 1);
                return;
            }
            smbPkt.setParameterCount(2);
            smbPkt.setAndXCommand(255);
            smbPkt.setParameter(1, 0);
            smbPkt.setByteCount(0);
            this.m_sess.sendResponseSMB(smbPkt);
        }
    }

    protected final void procLogoffAndX(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(2, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int uid = smbPkt.getUserId();
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(uid);
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (this.m_sess.hasDebug(32)) {
            Debug.println("[SMB] LogoffAndX vc=" + vc);
        }
        vc.setLoggedOn(false);
        if (vc.getConnectionCount() == 0) {
            this.m_sess.removeVirtualCircuit(vc.getUID());
            if (this.m_sess.hasDebug(32)) {
                this.m_sess.debugPrintln("  Removed virtual circuit " + vc);
            }
        }
        this.m_sess.sendSuccessResponseSMB(smbPkt);
        if (this.m_sess.numberOfVirtualCircuits() == 0) {
            if (this.m_sess.hasDebug(32)) {
                Debug.println("  Closing session, no more virtual circuits");
            }
            this.m_sess.hangupSession("Client logoff");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procOpenAndX(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int fid;
        if (!smbPkt.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        int flags = smbPkt.getParameter(2);
        int access = smbPkt.getParameter(3);
        int srchAttr = smbPkt.getParameter(4);
        int fileAttr = smbPkt.getParameter(5);
        int crTime = smbPkt.getParameter(6);
        int crDate = smbPkt.getParameter(7);
        int openFunc = smbPkt.getParameter(8);
        int allocSiz = smbPkt.getParameterLong(9);
        String fileName = smbPkt.unpackString(smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        long crDateTime = 0L;
        if (crTime > 0 && crDate > 0) {
            crDateTime = new SMBDate(crDate, crTime).getTime();
        }
        FileOpenParams params = new FileOpenParams(fileName, openFunc, access, srchAttr, fileAttr, allocSiz, crDateTime, smbPkt.getProcessIdFull());
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Open AndX [" + treeId + "] params=" + params);
        }
        if (!this.isValidPath(params.getPath())) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block26: {
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                int fileSts = disk.fileExists(this.m_sess, conn, fileName);
                if (fileSts == 0) {
                    if (FileAction.createNotExists(openFunc)) {
                        if (!conn.hasWriteAccess()) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                            return;
                        }
                        netFile = disk.createFile(this.m_sess, conn, params);
                        respAction = 2;
                        break block26;
                    } else {
                        if (fileSts == 2) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
                        return;
                    }
                }
                netFile = disk.openFile(this.m_sess, conn, params);
                if (FileAction.truncateExistingFile(openFunc)) {
                    disk.truncateFile(this.m_sess, conn, netFile, 0L);
                    respAction = 3;
                } else {
                    respAction = 1;
                }
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741757, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 21, 3);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        smbPkt.setParameterCount(15);
        smbPkt.setAndXCommand(255);
        smbPkt.setParameter(1, 0);
        smbPkt.setParameter(2, fid);
        smbPkt.setParameter(3, netFile.getFileAttributes());
        SMBDate modDate = null;
        if (netFile.hasModifyDate()) {
            modDate = new SMBDate(netFile.getModifyDate());
        }
        smbPkt.setParameter(4, modDate != null ? modDate.asSMBTime() : 0);
        smbPkt.setParameter(5, modDate != null ? modDate.asSMBDate() : 0);
        smbPkt.setParameterLong(6, netFile.getFileSizeInt());
        smbPkt.setParameter(8, netFile.getGrantedAccess());
        smbPkt.setParameter(9, 0);
        smbPkt.setParameter(10, 0);
        smbPkt.setParameter(11, respAction);
        smbPkt.setParameter(12, 0);
        smbPkt.setParameter(13, 0);
        smbPkt.setParameter(14, 0);
        smbPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected final void procReadAndX(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        if (!smbPkt.checkPacketIsValid(10, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int fid = smbPkt.getParameter(2);
        long offset = smbPkt.getParameterLong(3);
        offset &= 0xFFFFFFFFL;
        int maxCount = smbPkt.getParameter(5);
        if (smbPkt.getParameterCount() == 12) {
            long topOff = smbPkt.getParameterLong(10);
            offset += topOff << 32;
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Read AndX [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset);
        }
        SMBSrvPacket respPkt = smbPkt;
        byte[] buf = respPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            int dataLen;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            respPkt.setParameterCount(12);
            dataPos = respPkt.getByteOffset();
            dataPos = DataPacker.wordAlign(dataPos);
            if (maxCount > buf.length - dataPos) {
                respPkt = this.m_sess.getPacketPool().allocatePacket(maxCount + dataPos, smbPkt);
                buf = respPkt.getBuffer();
                respPkt.setParameterCount(12);
            }
            if ((dataLen = buf.length - dataPos) < maxCount) {
                maxCount = dataLen;
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 30, 3);
            return;
        }
        catch (LockConflictException ex) {
            if (this.m_sess.hasDebug(32768)) {
                this.m_sess.debugPrintln("Read Lock Error [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741740, 33, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("Filesystem Offline Error [" + netFile.getFileId() + "] Read File");
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Read Error [" + netFile.getFileId() + "] : " + ex.toString());
                this.m_sess.debugPrintln(ex);
                this.m_sess.debugPrintln("  NetworkFile name=" + netFile.getName() + "/" + netFile.getFullName());
                this.m_sess.debugPrintln("  attr=0x" + Integer.toHexString(netFile.getFileAttributes()) + ", size=" + netFile.getFileSize());
                this.m_sess.debugPrintln("  fid=" + netFile.getFileId() + ", cdate=" + netFile.getCreationDate() + ", mdate=" + netFile.getModifyDate());
                this.m_sess.debugPrintln("Offset = " + offset + " (0x" + Long.toHexString(offset) + ")");
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 30, 3);
            return;
        }
        respPkt.setAndXCommand(255);
        respPkt.setParameter(1, 0);
        respPkt.setParameter(2, 0);
        respPkt.setParameter(3, 0);
        respPkt.setParameter(4, 0);
        respPkt.setParameter(5, rdlen);
        respPkt.setParameter(6, dataPos - 4);
        for (int i = 7; i < 12; ++i) {
            respPkt.setParameter(i, 0);
        }
        respPkt.setByteCount(dataPos + rdlen - smbPkt.getByteOffset());
        if (smbPkt.hasAndXCommand()) {
            int pos = this.procAndXCommands(smbPkt, netFile);
            this.m_sess.sendResponseSMB(smbPkt.getAssociatedPacket(), pos);
        } else {
            this.m_sess.sendResponseSMB(respPkt);
        }
    }

    protected void procRenameFile(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        boolean isUni = smbPkt.isUnicode();
        smbPkt.resetBytePointer();
        if (smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String oldName = smbPkt.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String newName = smbPkt.unpackString(isUni);
        if (newName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Rename [" + treeId + "] old name=" + oldName + ", new name=" + newName);
        }
        if (!this.isValidPath(oldName)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        if (!this.isValidPath(newName)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        Object netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.renameFile(this.m_sess, conn, oldName, newName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741757, 32, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        smbPkt.setParameterCount(0);
        smbPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasFileServerNotifications()) {
            diskCtx.getChangeHandler().notifyRename(oldName, newName);
        }
    }

    protected void procDeleteFile(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(1, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        boolean isUni = smbPkt.isUnicode();
        smbPkt.resetBytePointer();
        if (smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String fileName = smbPkt.unpackString(isUni);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Delete [" + treeId + "] name=" + fileName);
        }
        Object netFile = null;
        long startTime = 0L;
        try {
            if (this.m_sess.hasDebug(0x4000000)) {
                startTime = System.currentTimeMillis();
            }
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteFile(this.m_sess, conn, fileName);
            if (this.m_sess.hasDebug(0x4000000)) {
                Debug.println("Benchmark: Delete file " + fileName + " took " + (System.currentTimeMillis() - startTime) + "ms");
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        smbPkt.setParameterCount(0);
        smbPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasFileServerNotifications()) {
            diskCtx.getChangeHandler().notifyFileChanged(2, fileName);
        }
    }

    protected void procDeleteDirectory(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        boolean isUni = smbPkt.isUnicode();
        smbPkt.resetBytePointer();
        if (smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String dirName = smbPkt.unpackString(isUni);
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Directory Delete [" + treeId + "] name=" + dirName);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteDirectory(this.m_sess, conn, dirName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (DirectoryNotEmptyException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 145, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 3, 1);
            return;
        }
        smbPkt.setParameterCount(0);
        smbPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasFileServerNotifications()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(2, dirName);
        }
    }

    protected final void procTrans2FindFirst(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int srchAttr = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int srchFlag = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String srchPath = paramBuf.getString(tbuf.isUnicode());
        if (tbuf.isUnicode() && WildCard.containsUnicodeWildcard(srchPath)) {
            srchPath = WildCard.convertUnicodeWildcardToDOS(srchPath);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Converted Unicode wildcards to:" + srchPath);
            }
        }
        if (!this.isValidSearchPath(srchPath)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        if (srchPath == null || srchPath.length() == 0) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (srchPath.endsWith("\\")) {
            srchPath = srchPath + "*.*";
        } else if (!srchPath.startsWith("\\")) {
            srchPath = "\\" + srchPath;
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search path missing leading slash, converted to relative path");
            }
        }
        if (infoLevl == 770 && !this.getSession().hasMacintoshExtensions()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 65535, 2);
            return;
        }
        SearchContext ctx = null;
        DiskInterface disk = null;
        int searchId = -1;
        boolean wildcardSearch = false;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            searchId = vc.allocateSearchSlot();
            if (searchId == -1) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 89, 2);
                return;
            }
            if (WildCard.containsWildcards(srchPath)) {
                wildcardSearch = true;
            }
            if ((ctx = disk.startSearch(this.m_sess, conn, srchPath, srchAttr)) == null) {
                if (searchId != -1) {
                    vc.deallocateSearchSlot(searchId);
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741809, 2, 1);
                return;
            }
            ctx.setTreeId(treeId);
            ctx.setMaximumFiles(maxFiles);
            vc.setSearchContext(searchId, ctx);
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Start trans search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles + ", maxLen=" + maxLen + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag) + ",dotFiles=" + ctx.hasDotFiles());
            }
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean resumeIds = false;
            if (infoLevl == 1 && (srchFlag & 4) != 0) {
                resumeIds = true;
            }
            if (wildcardSearch) {
                if (resumeIds) {
                    dataBuf.putInt(-1);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                FileInfo dotInfo = new FileInfo(".", 0L, 16);
                dotInfo.setFileId(dotInfo.getFileName().hashCode());
                if (ctx.hasDotFiles()) {
                    ctx.getDotInfo(dotInfo);
                }
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
                if (resumeIds) {
                    dataBuf.putInt(-2);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                if (ctx.hasDotFiles()) {
                    ctx.getDotDotInfo(dotInfo);
                } else {
                    dotInfo.setFileName("..");
                    dotInfo.setFileId(dotInfo.getFileName().hashCode());
                    dotInfo.setCreationDateTime(DotFileDateTime);
                    dotInfo.setModifyDateTime(DotFileDateTime);
                    dotInfo.setAccessDateTime(DotFileDateTime);
                }
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
            }
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeIds) {
                        dataBuf.putInt(ctx.getResumeId());
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
                if (!this.m_sess.hasDebug(128)) continue;
                this.m_sess.debugPrintln("Find first response full, restart at " + info.getFileName());
            }
            if (!wildcardSearch && fileCnt == 0) {
                throw new FileNotFoundException(srchPath);
            }
            if (maxFiles == 1 && fileCnt == 1) {
                searchDone = true;
            }
            FindInfoPacker.clearNextOffset(dataBuf, infoLevl, lastNameOff);
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(searchId);
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(smbPkt);
            tpkt.doTransactionResponse(this.m_sess, replyBuf, smbPkt);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search [" + searchId + "] Returned " + fileCnt + " files, dataLen=" + dataBuf.getLength() + ", moreFiles=" + ctx.hasMoreFiles());
            }
            if (searchDone || !ctx.hasMoreFiles()) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Search complete)");
                }
                vc.deallocateSearchSlot(searchId);
            } else if ((srchFlag & 1) != 0) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Close)");
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741809, 18, 1);
        }
        catch (PathNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741496, 65535, 2);
        }
        catch (DiskOfflineException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
    }

    protected final void procTrans2FindNext(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int searchId = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        int reskey = paramBuf.getInt();
        int srchFlag = paramBuf.getShort();
        String resumeName = paramBuf.getString(tbuf.isUnicode());
        SearchContext ctx = null;
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            ctx = vc.getSearchContext(searchId);
            if (ctx == null) {
                this.m_sess.debugPrintln("Search context null - [" + searchId + "]");
                this.m_sess.sendErrorResponseSMB(smbPkt, 18, 1);
                return;
            }
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Continue search [" + searchId + "] - " + resumeName + ", maxFiles=" + maxFiles + ", maxLen=" + maxLen + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag));
            }
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean resumeIds = false;
            if (infoLevl == 1 && (srchFlag & 4) != 0) {
                resumeIds = true;
            }
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeIds) {
                        dataBuf.putInt(ctx.getResumeId());
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
                if (!this.m_sess.hasDebug(128)) continue;
                this.m_sess.debugPrintln("Find next response full, restart at " + info.getFileName());
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(smbPkt);
            tpkt.doTransactionResponse(this.m_sess, replyBuf, smbPkt);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search [" + searchId + "] Returned " + fileCnt + " files, dataLen=" + dataBuf.getLength() + ", moreFiles=" + ctx.hasMoreFiles());
            }
            if (searchDone || !ctx.hasMoreFiles()) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Search complete)");
                }
                vc.deallocateSearchSlot(searchId);
            } else if ((srchFlag & 1) != 0) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Close)");
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 18, 1);
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
        }
    }

    protected final void procTrans2QueryFileSys(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Query File System Info - level = 0x" + Integer.toHexString(infoLevl));
        }
        try {
            int prmPos;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            smbPkt.setParameterCount(10);
            byte[] buf = smbPkt.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(smbPkt.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            SrvDiskInfo diskInfo = null;
            VolumeInfo volInfo = null;
            switch (infoLevl) {
                case 1: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packStandardInfo(diskInfo, replyBuf);
                    break;
                }
                case 2: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packVolumeInfo(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 258: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packFsVolumeInformation(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 259: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packFsSizeInformation(diskInfo, replyBuf);
                    break;
                }
                case 260: {
                    DiskInfoPacker.packFsDevice(7, diskCtx.getDeviceAttributes(), replyBuf);
                    break;
                }
                case 261: {
                    NTFSStreamsInterface ntfsStreams;
                    String fsType = diskCtx.getFilesystemType();
                    if (disk instanceof NTFSStreamsInterface && (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).hasStreamsEnabled(this.m_sess, conn)) {
                        fsType = "NTFS";
                    }
                    DiskInfoPacker.packFsAttribute(diskCtx.getFilesystemAttributes(), 255, fsType, tbuf.isUnicode(), replyBuf);
                    break;
                }
                case 769: {
                    boolean ntfs = false;
                    if (disk instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                        ntfs = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
                    }
                    if (ntfs) break;
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packMacFsInformation(diskInfo, volInfo, ntfs, replyBuf);
                    break;
                }
                case 1007: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    long userLimit = -1L;
                    if (diskCtx.hasQuotaManager()) {
                        userLimit = diskCtx.getQuotaManager().getUserFreeSpace(this.m_sess, conn);
                    }
                    userLimit = userLimit != -1L ? (userLimit /= diskInfo.getUnitSize()) : diskInfo.getTotalUnits();
                    DiskInfoPacker.packFullFsSizeInformation(userLimit, diskInfo, replyBuf);
                }
            }
            if (replyBuf.getPosition() == dataPos) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
                return;
            }
            int bytCnt = replyBuf.getPosition() - smbPkt.getByteOffset();
            replyBuf.setEndOfBuffer();
            int dataLen = replyBuf.getLength();
            SMBSrvTransPacket.initTransactReply(smbPkt, 0, prmPos, dataLen, dataPos);
            smbPkt.setByteCount(bytCnt);
            this.m_sess.sendResponseSMB(smbPkt);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
    }

    protected final void procTrans2QueryPath(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (path.endsWith(":$DATA")) {
            path = path.substring(0, path.length() - ":$DATA".length());
        }
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Query Path - level = 0x" + Integer.toHexString(infoLevl) + ", path = " + path);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            smbPkt.setParameterCount(10);
            byte[] buf = smbPkt.getBuffer();
            int prmPos = DataPacker.longwordAlign(smbPkt.getByteOffset());
            int dataPos = prmPos + 4;
            smbPkt.setPosition(prmPos);
            smbPkt.packWord(0);
            DataBuffer replyBuf = new DataBuffer(256);
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            if (!streams && path.indexOf(":") != -1) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 2, 1);
                return;
            }
            int dataLen = 0;
            if (streams && (infoLevl == 265 || infoLevl == 1022)) {
                NTFSStreamsInterface ntfsStreams;
                StreamInfoList streamList;
                if (this.m_sess.hasDebug(0x200000)) {
                    this.m_sess.debugPrintln("Get NTFS streams list path=" + path);
                }
                if ((streamList = (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).getStreamList(this.m_sess, conn, path)) == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 1, 2);
                    return;
                }
                dataLen = QueryInfoPacker.packStreamFileInfo(streamList, replyBuf, true);
            } else {
                FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, path);
                if (fileInfo == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
                    return;
                }
                dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            }
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            SMBSrvPacket respPkt = smbPkt;
            SMBSrvTransPacket.initTransactReply(respPkt, 2, prmPos, dataLen, dataPos);
            if (respPkt.getAvailableLength() < dataLen + 4) {
                respPkt = this.m_sess.getPacketPool().allocatePacket(smbPkt.getByteOffset() + dataLen + 4, smbPkt, smbPkt.getByteOffset());
            }
            replyBuf.setEndOfBuffer();
            replyBuf.copyData(respPkt.getBuffer(), dataPos);
            respPkt.setByteCount(dataPos + dataLen - respPkt.getByteOffset());
            this.m_sess.sendResponseSMB(respPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
    }

    protected final void procTrans2QueryFile(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Query File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", stream=" + netFile.getStreamId() + ", name=" + netFile.getFullName());
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            smbPkt.setParameterCount(10);
            byte[] buf = smbPkt.getBuffer();
            int prmPos = DataPacker.longwordAlign(smbPkt.getByteOffset());
            int dataPos = prmPos + 4;
            smbPkt.setPosition(prmPos);
            smbPkt.packWord(0);
            boolean streams = false;
            DataBuffer replyBuf = null;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            int dataLen = 0;
            if (streams && (infoLevl == 265 || infoLevl == 1022)) {
                NTFSStreamsInterface ntfsStreams;
                StreamInfoList streamList;
                if (this.m_sess.hasDebug(0x200000)) {
                    this.m_sess.debugPrintln("Get NTFS streams list fid=" + fid + ", name=" + netFile.getFullName());
                }
                if ((streamList = (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).getStreamList(this.m_sess, conn, netFile.getFullName())) == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 1, 2);
                    return;
                }
                if (streamList.numberOfStreams() > 1 && buf.length < 4096) {
                    smbPkt = this.m_sess.getPacketPool().allocatePacket(4096, smbPkt, dataPos);
                    buf = smbPkt.getBuffer();
                }
                replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
                dataLen = QueryInfoPacker.packStreamFileInfo(streamList, replyBuf, true);
            } else {
                FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, netFile.getFullName());
                if (fileInfo == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 1, 2);
                    return;
                }
                fileInfo.setFileSize(netFile.getFileSize());
                fileInfo.setAllocationSize(fileInfo.getSize() + 511L & 0xFFFFFE00L);
                if (netFile.hasAccessDate()) {
                    fileInfo.setAccessDateTime(netFile.getAccessDate());
                }
                replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
                dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            }
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, dataLen, dataPos);
            smbPkt.setByteCount(replyBuf.getPosition() - smbPkt.getByteOffset());
            this.m_sess.sendResponseSMB(smbPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
    }

    protected final void procTrans2SetFile(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Set File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", name=" + netFile.getFullName());
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DataBuffer dataBuf = tbuf.getDataBuffer();
            FileInfo finfo = null;
            switch (infoLevl) {
                case 257: {
                    int setFlags = 0;
                    finfo = new FileInfo(netFile.getFullName(), 0L, -1);
                    long timeNow = System.currentTimeMillis();
                    long nttim = dataBuf.getLong();
                    boolean hasSetTime = false;
                    if (nttim != 0L) {
                        if (nttim != -1L) {
                            finfo.setCreationDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 16;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) != 0L) {
                        if (nttim != -1L) {
                            finfo.setAccessDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 32;
                        } else {
                            finfo.setAccessDateTime(timeNow);
                            setFlags += 32;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) > 0L) {
                        if (nttim != -1L) {
                            finfo.setModifyDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 8;
                        } else {
                            finfo.setModifyDateTime(timeNow);
                            setFlags += 8;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) > 0L) {
                        if (nttim != -1L) {
                            finfo.setChangeDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 64;
                        }
                        hasSetTime = true;
                    }
                    int attr = dataBuf.getInt();
                    int unknown = dataBuf.getInt();
                    if (!hasSetTime && unknown == 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setNetworkFile(netFile);
                    finfo.setFileInformationFlags(setFlags);
                    disk.setFileInformation(this.m_sess, conn, netFile.getFullName(), finfo);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set Basic Info [" + treeId + "] name=" + netFile.getFullName() + ", attr=0x" + Integer.toHexString(attr) + ", setTime=" + hasSetTime + ", setFlags=0x" + Integer.toHexString(setFlags) + ", unknown=" + unknown);
                    break;
                }
                case 260: {
                    long eofPos = dataBuf.getLong();
                    disk.truncateFile(this.m_sess, conn, netFile, eofPos);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set end of file position fid=" + fid + ", eof=" + eofPos);
                    break;
                }
                case 259: {
                    long allocSize = dataBuf.getLong();
                    disk.truncateFile(this.m_sess, conn, netFile, allocSize);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set allocation size fid=" + fid + ", allocSize=" + allocSize);
                    break;
                }
                case 1010: {
                    boolean streams = false;
                    if (disk instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                        streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
                    }
                    if (!streams) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741637, 65535, 2);
                        return;
                    }
                    boolean overwrite = dataBuf.getByte() == 1;
                    dataBuf.skipBytes(3);
                    int rootFid = dataBuf.getInt();
                    int nameLen = dataBuf.getInt();
                    String newName = dataBuf.getString(nameLen, true);
                    if (this.m_sess.hasDebug(256)) {
                        this.m_sess.debugPrintln("  Set rename fid=" + fid + ", newName=" + newName + ", overwrite=" + overwrite + ", rootFID=" + rootFid);
                    }
                    if (newName.indexOf("\\") != -1) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741637, 65535, 2);
                        return;
                    }
                    if (this.m_sess.hasDebug(0x200000)) {
                        this.m_sess.debugPrintln("Rename stream fid=" + fid + ", name=" + netFile.getFullNameStream() + ", newName=" + newName + ", overwrite=" + overwrite);
                    }
                    NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                    ntfsStreams.renameStream(this.m_sess, conn, netFile.getFullNameStream(), newName, overwrite);
                    break;
                }
                case 258: 
                case 1013: {
                    int flag = dataBuf.getByte();
                    boolean delFlag = flag == 1;
                    FileInfo delInfo = new FileInfo();
                    delInfo.setDeleteOnClose(delFlag);
                    delInfo.setFileInformationFlags(1024);
                    disk.setFileInformation(this.m_sess, conn, netFile.getFullName(), delInfo);
                    netFile.setDeleteOnClose(delFlag);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set file disposition fid=" + fid + ", name=" + netFile.getName() + ", delete=" + delFlag);
                }
            }
            smbPkt.setParameterCount(10);
            byte[] buf = smbPkt.getBuffer();
            int prmPos = smbPkt.getByteOffset();
            prmPos = DataPacker.longwordAlign(prmPos);
            DataPacker.putIntelShort(0, buf, prmPos);
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, 0, prmPos + 4);
            smbPkt.setByteCount(prmPos - smbPkt.getByteOffset() + 4);
            this.m_sess.sendResponseSMB(smbPkt);
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            if (diskCtx.hasFileServerNotifications() && netFile.getFullName() != null) {
                NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
                if (finfo != null) {
                    if (finfo.hasSetFlag(4)) {
                        changeHandler.notifyAttributesChanged(netFile.getFullName(), netFile.isDirectory());
                    }
                    if (finfo.hasSetFlag(8)) {
                        changeHandler.notifyLastWriteTimeChanged(netFile.getFullName(), netFile.isDirectory());
                    }
                } else if (infoLevl == 259 || infoLevl == 260) {
                    changeHandler.notifyFileSizeChanged(netFile.getFullName());
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
        }
        catch (DiskFullException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741697, 29, 3);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (DirectoryNotEmptyException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 145, 1);
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
    }

    protected final void procTrans2SetPath(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Set Path - path=" + path + ", level=0x" + Integer.toHexString(infoLevl));
        }
        if (!this.isValidPath(path)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DataBuffer dataBuf = tbuf.getDataBuffer();
            FileInfo finfo = null;
            int setFlags = 0;
            int attr = 0;
            switch (infoLevl) {
                case 1: {
                    int fileSize;
                    finfo = new FileInfo(path, 0L, -1);
                    int smbDate = dataBuf.getShort();
                    int smbTime = dataBuf.getShort();
                    boolean hasSetTime = false;
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setCreationDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 16;
                        hasSetTime = true;
                    }
                    smbDate = dataBuf.getShort();
                    smbTime = dataBuf.getShort();
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setAccessDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 32;
                        hasSetTime = true;
                    }
                    smbDate = dataBuf.getShort();
                    smbTime = dataBuf.getShort();
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setModifyDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 8;
                        hasSetTime = true;
                    }
                    if ((fileSize = dataBuf.getInt()) != 0) {
                        finfo.setFileSize(fileSize);
                        ++setFlags;
                    }
                    if ((fileSize = dataBuf.getInt()) != 0) {
                        finfo.setAllocationSize(fileSize);
                        setFlags += 2;
                    }
                    attr = dataBuf.getInt();
                    int eaListLen = dataBuf.getInt();
                    if (!hasSetTime && eaListLen == 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setFileInformationFlags(setFlags);
                    disk.setFileInformation(this.m_sess, conn, path, finfo);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set Standard Info [" + treeId + "] name=" + path + ", attr=0x" + Integer.toHexString(attr) + ", setTime=" + hasSetTime + ", setFlags=0x" + Integer.toHexString(setFlags) + ", eaListLen=" + eaListLen);
                    break;
                }
                case 257: {
                    finfo = new FileInfo(path, 0L, -1);
                    long dateTime = NTTime.toJavaDate(dataBuf.getLong());
                    if (dateTime != 0L) {
                        finfo.setCreationDateTime(dateTime);
                        setFlags += 16;
                    }
                    if ((dateTime = NTTime.toJavaDate(dataBuf.getLong())) != 0L) {
                        finfo.setAccessDateTime(dateTime);
                        setFlags += 32;
                    }
                    if ((dateTime = NTTime.toJavaDate(dataBuf.getLong())) != 0L) {
                        finfo.setModifyDateTime(dateTime);
                        setFlags += 8;
                    }
                    if ((dateTime = NTTime.toJavaDate(dataBuf.getLong())) != 0L) {
                        finfo.setChangeDateTime(dateTime);
                        setFlags += 64;
                    }
                    if ((attr = dataBuf.getInt()) != 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setFileInformationFlags(setFlags);
                    disk.setFileInformation(this.m_sess, conn, path, finfo);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set Basic Info [" + treeId + "] name=" + path + ", attr=0x" + Integer.toHexString(attr) + ", setFlags=0x" + Integer.toHexString(setFlags));
                }
            }
            smbPkt.setParameterCount(10);
            byte[] buf = smbPkt.getBuffer();
            int prmPos = smbPkt.getByteOffset();
            prmPos = DataPacker.longwordAlign(prmPos);
            DataPacker.putIntelShort(0, buf, prmPos);
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, 0, prmPos + 4);
            smbPkt.setByteCount(prmPos - smbPkt.getByteOffset() + 4);
            this.m_sess.sendResponseSMB(smbPkt);
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            if (diskCtx.hasFileServerNotifications() && path != null) {
                NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
                if (finfo != null) {
                    int fileSts = disk.fileExists(this.m_sess, conn, path);
                    if (finfo.hasSetFlag(4)) {
                        changeHandler.notifyAttributesChanged(path, fileSts == 2);
                    }
                    if (finfo.hasSetFlag(8)) {
                        changeHandler.notifyLastWriteTimeChanged(path, fileSts == 2);
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
        }
        catch (DiskFullException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741697, 29, 3);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
    }

    protected final void procWriteAndX(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        if (!smbPkt.checkPacketIsValid(12, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int fid = smbPkt.getParameter(2);
        long offset = (long)smbPkt.getParameterLong(3) & 0xFFFFFFFFL;
        int dataPos = smbPkt.getParameter(11) + 4;
        int dataLen = smbPkt.getParameter(10);
        int dataLenHigh = 0;
        if (smbPkt.getReceivedLength() > 65535) {
            dataLenHigh = smbPkt.getParameter(9) & 1;
        }
        if (dataLenHigh > 0) {
            dataLen += dataLenHigh << 16;
        }
        if (smbPkt.getParameterCount() == 14) {
            long topOff = (long)smbPkt.getParameterLong(12) & 0xFFFFFFFFL;
            offset += topOff << 32;
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Write AndX [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset);
        }
        byte[] buf = smbPkt.getBuffer();
        int wrtlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, dataPos, dataLen, offset);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Write Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (LockConflictException ex) {
            if (this.m_sess.hasDebug(32768)) {
                this.m_sess.debugPrintln("Write Lock Error [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741740, 5, 1);
            return;
        }
        catch (DiskFullException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("Write Quota Error [" + netFile.getFileId() + "] Disk full : Size=" + dataLen + " ,Pos=" + offset);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741697, 29, 3);
            return;
        }
        catch (DiskOfflineException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("Filesystem Offline Error [" + netFile.getFileId() + "] Write File");
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Write Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 29, 3);
            return;
        }
        smbPkt.setParameterCount(6);
        smbPkt.setAndXCommand(255);
        smbPkt.setParameter(1, 0);
        smbPkt.setParameter(2, wrtlen);
        smbPkt.setParameter(3, 65535);
        if (dataLenHigh > 0) {
            smbPkt.setParameter(4, dataLen >> 16);
            smbPkt.setParameter(5, 0);
        } else {
            smbPkt.setParameterLong(4, 0);
        }
        smbPkt.setByteCount(0);
        smbPkt.setParameter(1, smbPkt.getLength());
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (netFile.getWriteCount() % 10 == 0 && diskCtx.hasFileServerNotifications() && netFile.getFullName() != null) {
            NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
            changeHandler.notifyFileSizeChanged(netFile.getFullName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procNTCreateAndX(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int fid;
        if (!smbPkt.checkPacketIsValid(24, 1)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        NTParameterPacker prms = new NTParameterPacker(smbPkt.getBuffer(), 42);
        int nameLen = prms.unpackWord();
        int flags = prms.unpackInt();
        int rootFID = prms.unpackInt();
        int accessMask = prms.unpackInt();
        long allocSize = prms.unpackLong();
        int attrib = prms.unpackInt();
        int shrAccess = prms.unpackInt();
        int createDisp = prms.unpackInt();
        int createOptn = prms.unpackInt();
        int impersonLev = prms.unpackInt();
        int secFlags = prms.unpackByte();
        String fileName = DataPacker.getUnicodeString(smbPkt.getBuffer(), DataPacker.wordAlign(smbPkt.getByteOffset()), nameLen / 2);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (fileName.indexOf(":") != -1) {
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            if (!streams) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 2, 1);
                return;
            }
        }
        FileOpenParams params = new FileOpenParams(fileName, createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags, smbPkt.getProcessIdFull());
        params.setNTCreateFlags(flags);
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("NT Create AndX [" + treeId + "] params=" + params);
        }
        if (!this.isValidPath(params.getPath())) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        NetworkFile netFile = null;
        int respAction = 0;
        OpLockDetails oplock = null;
        try {
            block62: {
                block60: {
                    int idx;
                    int fldrSts;
                    StringBuilder pathStr;
                    String[] paths;
                    block61: {
                        int fileSts;
                        block57: {
                            block58: {
                                block59: {
                                    fileSts = disk.fileExists(this.m_sess, conn, params.getFullPath());
                                    if (fileSts != 0) break block57;
                                    if (createDisp != 2 && createDisp != 3 && createDisp != 5 && createDisp != 0) break block58;
                                    if (!conn.hasWriteAccess()) {
                                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                                        return;
                                    }
                                    if ((createOptn & 1) != 0) break block59;
                                    netFile = disk.createFile(this.m_sess, conn, params);
                                    if (netFile != null && this.m_sess.hasDebug(0x4000000)) {
                                        netFile.setStatusFlag(8, true);
                                        netFile.setCreationDate(System.currentTimeMillis());
                                    }
                                    oplock = this.grantOpLock(this.m_sess, smbPkt, disk, conn, params, netFile);
                                    break block60;
                                }
                                paths = FileName.splitAllPaths(params.getPath());
                                pathStr = new StringBuilder(params.getPath().length());
                                fldrSts = -1;
                                idx = 0;
                                break block61;
                            }
                            if (fileSts == 2) {
                                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                                return;
                            }
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
                            return;
                        }
                        if (createDisp == 2) {
                            if (fileSts != 1 && fileSts != 2) {
                                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                                return;
                            }
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                            return;
                        }
                        if ((createOptn & 0x40) != 0 && fileSts == 2) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741638, 5, 1);
                            return;
                        }
                        this.checkOpLock(this.m_sess, smbPkt, disk, params, conn);
                        netFile = disk.openFile(this.m_sess, conn, params);
                        oplock = this.grantOpLock(this.m_sess, smbPkt, disk, conn, params, netFile);
                        if (createDisp == 0 || createDisp == 5) {
                            disk.truncateFile(this.m_sess, conn, netFile, 0L);
                            if (this.m_sess.hasDebug(512)) {
                                this.m_sess.debugPrintln("  [" + treeId + "] name=" + fileName + " truncated");
                            }
                            if (netFile != null && this.m_sess.hasDebug(0x4000000)) {
                                netFile.setStatusFlag(8, true);
                                netFile.setCreationDate(System.currentTimeMillis());
                            }
                        }
                        respAction = 1;
                        break block62;
                    }
                    while (idx < paths.length) {
                        pathStr.append("\\");
                        pathStr.append(paths[idx++]);
                        fldrSts = disk.fileExists(this.m_sess, conn, pathStr.toString());
                        if (fldrSts == 1) {
                            if (idx < paths.length) {
                                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                                return;
                            }
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 3, 1);
                            return;
                        }
                        if (fldrSts != 0) continue;
                        FileOpenParams fldrParams = new FileOpenParams(pathStr.toString(), createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags, smbPkt.getProcessIdFull());
                        disk.createDirectory(this.m_sess, conn, fldrParams);
                    }
                    netFile = disk.openFile(this.m_sess, conn, params);
                    if (netFile != null && this.m_sess.hasDebug(0x4000000)) {
                        netFile.setStatusFlag(8, true);
                        netFile.setCreationDate(System.currentTimeMillis());
                    }
                }
                if (netFile != null && (createOptn & 0x1000) != 0) {
                    netFile.setDeleteOnClose(true);
                }
                respAction = 2;
            }
            fid = conn.addFile(netFile, this.getSession());
            if (oplock != null && oplock.getLockType() != 0) {
                oplock.setOwnerFileId(fid);
            }
            if (this.m_sess.hasDebug(512)) {
                this.m_sess.debugPrintln("  [" + treeId + "] name=" + fileName + " fid=" + fid + ", fileId=" + netFile.getFileId() + ", opLock=" + oplock);
            }
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741537, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741757, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 21, 3);
            return;
        }
        catch (FileNameException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 11, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (DiskFullException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741697, 29, 3);
            return;
        }
        catch (DeferredPacketException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        boolean extendedResponse = params.requestExtendedResponse();
        smbPkt.setParameterCount(extendedResponse ? 42 : 34);
        smbPkt.setAndXCommand(255);
        smbPkt.setParameter(1, 0);
        prms.reset(smbPkt.getBuffer(), 41);
        if (oplock != null) {
            prms.packByte(oplock.getLockType());
        } else {
            prms.packByte(0);
        }
        prms.packWord(fid);
        prms.packInt(respAction);
        if (netFile.hasCreationDate()) {
            prms.packLong(NTTime.toNTTime(netFile.getCreationDate()));
        } else {
            prms.packLong(0L);
        }
        if (netFile.hasAccessDate()) {
            prms.packLong(NTTime.toNTTime(netFile.getAccessDate()));
        } else if (netFile.hasModifyDate()) {
            prms.packLong(NTTime.toNTTime(netFile.getModifyDate()));
        } else {
            prms.packLong(0L);
        }
        if (netFile.hasModifyDate()) {
            long modDate = NTTime.toNTTime(netFile.getModifyDate());
            prms.packLong(modDate);
            prms.packLong(modDate);
        } else {
            prms.packLong(0L);
            prms.packLong(0L);
        }
        prms.packInt(netFile.getFileAttributes());
        long fileSize = netFile.getFileSize();
        if (fileSize > 0L) {
            fileSize = fileSize + 512L & 0xFFFFFFFFFFFFFE00L;
        }
        prms.packLong(fileSize);
        prms.packLong(netFile.getFileSize());
        prms.packWord(0);
        prms.packWord(extendedResponse ? 7 : 0);
        prms.packByte(netFile.isDirectory() ? 1 : 0);
        prms.packWord(0);
        if (extendedResponse) {
            prms.packLong(0L);
            prms.packLong(0L);
            prms.packInt(0);
            prms.packWord(0);
            if (netFile.isDirectory() || netFile.getAllowedAccess() == 2) {
                prms.packInt(0x1F01FF);
            } else {
                prms.packInt(1179785);
            }
            prms.packInt(0);
            prms.packWord(0);
        }
        int endPos = prms.getPosition();
        smbPkt.setParameter(1, endPos - 4);
        smbPkt.setLongErrorCode(0);
        if (smbPkt.hasAndXCommand()) {
            endPos = this.procAndXCommands(smbPkt, netFile);
        }
        this.m_sess.sendResponseSMB(smbPkt, endPos - 4);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasFileServerNotifications()) return;
        if (respAction != 2) return;
        if (netFile.isDirectory()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(1, fileName);
            return;
        }
        diskCtx.getChangeHandler().notifyFileChanged(1, fileName);
    }

    protected final void procNTCancel(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        NotifyRequest req = this.m_sess.findNotifyRequest(smbPkt.getMultiplexId(), smbPkt.getTreeId(), smbPkt.getUserId(), smbPkt.getProcessId());
        if (req != null) {
            this.m_sess.removeNotifyRequest(req);
            smbPkt.setParameterCount(0);
            smbPkt.setByteCount(0);
            if (!smbPkt.isLongErrorCode()) {
                smbPkt.setFlags2(smbPkt.getFlags2() + 16384);
            }
            smbPkt.setLongErrorCode(-1073741536);
            if (!smbPkt.isUnicode()) {
                smbPkt.setFlags2(smbPkt.getFlags2() + 32768);
            }
            this.m_sess.sendResponseSMB(smbPkt);
            if (this.m_sess.hasDebug(0x100000)) {
                DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                this.m_sess.debugPrintln("NT Cancel notify mid=" + req.getMultiplexId() + ", dir=" + req.getWatchPath() + ", queue=" + diskCtx.getChangeHandler().getRequestQueueSize());
            }
        } else {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
    }

    protected final void procNTTransaction(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(19, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        NTTransPacket ntTrans = new NTTransPacket(smbPkt.getBuffer());
        int subCmd = ntTrans.getNTFunction();
        if (subCmd == 4) {
            this.procNTTransactNotifyChange(ntTrans, smbPkt);
            return;
        }
        SrvTransactBuffer transBuf = null;
        if (ntTrans.getTotalParameterCount() == ntTrans.getParameterBlockCount() && ntTrans.getTotalDataCount() == ntTrans.getDataBlockCount()) {
            transBuf = new SrvTransactBuffer(ntTrans);
        } else {
            transBuf = new SrvTransactBuffer(ntTrans.getSetupCount(), ntTrans.getTotalParameterCount(), ntTrans.getTotalDataCount());
            transBuf.setType(ntTrans.getCommand());
            transBuf.setFunction(subCmd);
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("NT Transaction [" + treeId + "] transbuf=" + transBuf);
            }
            byte[] buf = ntTrans.getBuffer();
            int cnt = ntTrans.getSetupCount();
            if (cnt > 0) {
                transBuf.appendSetup(buf, ntTrans.getSetupOffset(), cnt * 2);
            }
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("NT Transaction [" + treeId + "] pcnt=" + ntTrans.getNTParameter(4) + ", offset=" + ntTrans.getNTParameter(5));
            }
            if ((cnt = ntTrans.getParameterBlockCount()) > 0) {
                transBuf.appendParameter(buf, ntTrans.getParameterBlockOffset(), cnt);
            }
            if ((cnt = ntTrans.getDataBlockCount()) > 0) {
                transBuf.appendData(buf, ntTrans.getDataBlockOffset(), cnt);
            }
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT Transaction [" + treeId + "] cmd=0x" + Integer.toHexString(subCmd) + ", multiPkt=" + transBuf.isMultiPacket());
        }
        if (transBuf.isMultiPacket()) {
            vc.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB(smbPkt);
            return;
        }
        this.processNTTransactionBuffer(transBuf, ntTrans);
    }

    protected final void procNTTransactionSecondary(SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int dlen;
        if (!smbPkt.checkPacketIsValid(18, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = smbPkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        if (!vc.hasTransaction() || vc.getTransaction().isType() != 160) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 1, 2);
            return;
        }
        NTTransPacket ntTrans = new NTTransPacket(smbPkt.getBuffer());
        byte[] buf = ntTrans.getBuffer();
        SrvTransactBuffer transBuf = vc.getTransaction();
        int plen = ntTrans.getParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, ntTrans.getParameterBlockOffset(), plen);
        }
        if ((dlen = ntTrans.getDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, ntTrans.getDataBlockOffset(), dlen);
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT Transaction Secondary [" + treeId + "] paramLen=" + plen + ", dataLen=" + dlen);
        }
        int totParam = ntTrans.getTotalParameterCount();
        int totData = ntTrans.getTotalDataCount();
        int paramDisp = ntTrans.getParameterBlockDisplacement();
        int dataDisp = ntTrans.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("NT Transaction complete, processing ...");
            }
            vc.setTransaction(null);
            this.processNTTransactionBuffer(transBuf, ntTrans);
        }
    }

    private final void processNTTransactionBuffer(SrvTransactBuffer tbuf, NTTransPacket smbPkt) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procNTTransactCreate(tbuf, smbPkt);
                break;
            }
            case 2: {
                this.procNTTransactIOCtl(tbuf, smbPkt);
                break;
            }
            case 6: {
                this.procNTTransactQuerySecurityDesc(tbuf, smbPkt);
                break;
            }
            case 3: {
                this.procNTTransactSetSecurityDesc(tbuf, smbPkt);
                break;
            }
            case 5: {
                this.procNTTransactRename(tbuf, smbPkt);
                break;
            }
            case 7: {
                if (this.m_sess.hasDebug(2048)) {
                    this.m_sess.debugPrintln("NT GetUserQuota transaction");
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 65535, 2);
                break;
            }
            case 8: {
                if (this.m_sess.hasDebug(2048)) {
                    this.m_sess.debugPrintln("NT SetUserQuota transaction");
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 65535, 2);
                break;
            }
            default: {
                this.m_sess.debugPrintln("NT Error unknown NT transact command = 0x" + Integer.toHexString(tbuf.isType()));
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procNTTransactCreate(SrvTransactBuffer tbuf, NTTransPacket smbPkt) throws IOException, SMBSrvException {
        int fid;
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT TransactCreate");
        }
        if (tbuf.hasParameterBuffer() && tbuf.getParameterBuffer().getLength() < 52) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer tparams = tbuf.getParameterBuffer();
        int flags = tparams.getInt();
        int rootFID = tparams.getInt();
        int accessMask = tparams.getInt();
        long allocSize = tparams.getLong();
        int attrib = tparams.getInt();
        int shrAccess = tparams.getInt();
        int createDisp = tparams.getInt();
        int createOptn = tparams.getInt();
        int sdLen = tparams.getInt();
        int eaLen = tparams.getInt();
        int nameLen = tparams.getInt();
        int impersonLev = tparams.getInt();
        int secFlags = tparams.getByte();
        tparams.wordAlign();
        String fileName = tparams.getString(nameLen, true);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (fileName.indexOf(":") != -1) {
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            if (!streams) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
                return;
            }
        }
        FileOpenParams params = new FileOpenParams(fileName, createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags, smbPkt.getProcessIdFull());
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("NT TransactCreate [" + treeId + "] params=" + params);
            this.m_sess.debugPrintln("  secDescLen=" + sdLen + ", extAttribLen=" + eaLen);
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block40: {
                int fileSts = disk.fileExists(this.m_sess, conn, fileName);
                if (fileSts == 0) {
                    if (createDisp == 2 || createDisp == 3 || createDisp == 5 || createDisp == 0) {
                        if ((createOptn & 1) == 0) {
                            netFile = disk.createFile(this.m_sess, conn, params);
                        } else {
                            disk.createDirectory(this.m_sess, conn, params);
                            netFile = disk.openFile(this.m_sess, conn, params);
                        }
                        respAction = 2;
                        break block40;
                    } else {
                        if (fileSts == 2) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
                        return;
                    }
                }
                if (createDisp == 2) {
                    if (fileSts != 1 && fileSts != 2) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                        return;
                    }
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                    return;
                }
                netFile = disk.openFile(this.m_sess, conn, params);
                if (createDisp == 0 || createDisp == 5) {
                    disk.truncateFile(this.m_sess, conn, netFile, 0L);
                    if (this.m_sess.hasDebug(512)) {
                        this.m_sess.debugPrintln("  [" + treeId + "] name=" + fileName + " truncated");
                    }
                }
                respAction = 1;
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741537, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741757, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 21, 3);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        DataBuffer prms = new DataBuffer(128);
        if ((flags & 4) != 0) {
            prms.putByte(2);
        } else if ((flags & 2) != 0) {
            prms.putByte(1);
        } else {
            prms.putByte(0);
        }
        prms.putByte(0);
        prms.putShort(fid);
        prms.putInt(respAction);
        prms.putInt(0);
        if (netFile.hasCreationDate()) {
            prms.putLong(NTTime.toNTTime(netFile.getCreationDate()));
        } else {
            prms.putLong(0L);
        }
        if (netFile.hasModifyDate()) {
            long modDate = NTTime.toNTTime(netFile.getModifyDate());
            prms.putLong(modDate);
            prms.putLong(modDate);
            prms.putLong(modDate);
        } else {
            prms.putLong(0L);
            prms.putLong(0L);
            prms.putLong(0L);
        }
        prms.putInt(netFile.getFileAttributes());
        prms.putLong(netFile.getFileSize());
        prms.putLong(netFile.getFileSize());
        prms.putShort(0);
        prms.putShort(0);
        prms.putByte(netFile.isDirectory() ? 1 : 0);
        smbPkt.initTransactReply(prms.getBuffer(), prms.getLength(), null, 0);
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasFileServerNotifications()) return;
        if (respAction != 2) return;
        if (netFile.isDirectory()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(1, fileName);
            return;
        }
        diskCtx.getChangeHandler().notifyFileChanged(1, fileName);
    }

    protected final void procNTTransactIOCtl(SrvTransactBuffer tbuf, NTTransPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        int ctrlCode = setupBuf.getInt();
        int fid = setupBuf.getShort();
        boolean fsctrl = setupBuf.getByte() == 1;
        int filter = setupBuf.getByte();
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT IOCtl code=" + NTIOCtl.asString(ctrlCode) + ", fid=" + fid + ", fsctrl=" + fsctrl + ", filter=" + filter);
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 13, 1);
            return;
        }
        if (disk instanceof IOCtlInterface) {
            IOCtlInterface ioControl = (IOCtlInterface)((Object)disk);
            NTTransPacket respPkt = smbPkt;
            try {
                DataBuffer response = ioControl.processIOControl(this.m_sess, conn, ctrlCode, fid, tbuf.getDataBuffer(), fsctrl, filter);
                if (response != null) {
                    int respPktLen = NTTransPacket.calculateResponseLength(0, response.getLength(), 1);
                    if (smbPkt.getBufferLength() < respPktLen) {
                        SMBSrvPacket pkt = this.m_sess.getPacketPool().allocatePacket(respPktLen, smbPkt, smbPkt.getLength());
                        respPkt = new NTTransPacket(pkt.getBuffer());
                    }
                    respPkt.initTransactReply(null, 0, response.getBuffer(), response.getLength(), 1);
                    respPkt.setSetupParameter(0, response.getLength());
                } else {
                    respPkt.initTransactReply(null, 0, null, 0, 1);
                    respPkt.setSetupParameter(0, 0);
                }
            }
            catch (IOControlNotImplementedException ex) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 65, 2);
                return;
            }
            catch (SMBException ex) {
                this.m_sess.sendErrorResponseSMB(smbPkt, ex.getErrorCode(), 65, 2);
                return;
            }
            this.m_sess.sendResponseSMB(respPkt);
        } else {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 65535, 2);
        }
    }

    protected final void procNTTransactQuerySecurityDesc(SrvTransactBuffer tbuf, NTTransPacket smbPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int flags = paramBuf.getShort();
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT QuerySecurityDesc fid=" + fid + ", flags=" + flags);
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 13, 1);
            return;
        }
        if (disk instanceof SecurityDescriptorInterface) {
            SecurityDescriptorInterface secDescInterface = (SecurityDescriptorInterface)((Object)disk);
            if (tbuf.getReturnDataLimit() == 0) {
                int secDescLen = secDescInterface.getSecurityDescriptorLength(this.m_sess, conn, netFile);
                byte[] paramblk = new byte[4];
                DataPacker.putIntelInt(secDescLen, paramblk, 0);
                smbPkt.initTransactReply(paramblk, paramblk.length, null, 0);
                smbPkt.setLongErrorCode(-1073741789);
            } else {
                SecurityDescriptor secDesc = secDescInterface.loadSecurityDescriptor(this.m_sess, conn, netFile);
                byte[] secBuf = null;
                int secLen = 0;
                if (secDesc != null) {
                    secBuf = new byte[4096];
                    try {
                        secLen = secDesc.saveDescriptor(secBuf, 0);
                    }
                    catch (SaveException ex) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
                        return;
                    }
                }
                byte[] paramblk = new byte[4];
                DataPacker.putIntelInt(secLen, paramblk, 0);
                smbPkt.initTransactReply(paramblk, paramblk.length, secBuf, secLen);
            }
        } else if (tbuf.getReturnDataLimit() == 0) {
            byte[] paramblk = new byte[4];
            DataPacker.putIntelInt(_sdEveryOne.length, paramblk, 0);
            smbPkt.initTransactReply(paramblk, paramblk.length, null, 0);
            smbPkt.setLongErrorCode(-1073741789);
        } else {
            byte[] paramblk = new byte[4];
            DataPacker.putIntelInt(_sdEveryOne.length, paramblk, 0);
            smbPkt.initTransactReply(paramblk, paramblk.length, _sdEveryOne, _sdEveryOne.length);
        }
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected final void procNTTransactSetSecurityDesc(SrvTransactBuffer tbuf, NTTransPacket smbPkt) throws IOException, SMBSrvException {
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        int fid = paramBuf.getShort();
        paramBuf.skipBytes(2);
        int flags = paramBuf.getInt();
        DataBuffer dataBuf = tbuf.getDataBuffer();
        SecurityDescriptor secDesc = new SecurityDescriptor();
        try {
            secDesc.loadDescriptor(dataBuf.getBuffer(), dataBuf.getOffset());
        }
        catch (LoadException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT SetSecurityDesc fid=" + fid + ", flags=" + flags);
            this.m_sess.debugPrintln("   sd=" + secDesc);
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 13, 1);
            return;
        }
        if (disk instanceof SecurityDescriptorInterface) {
            SecurityDescriptorInterface secDescInterface = (SecurityDescriptorInterface)((Object)disk);
            NetworkFile netFile = conn.findFile(fid);
            if (netFile == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
                return;
            }
            secDescInterface.saveSecurityDescriptor(this.m_sess, conn, netFile, secDesc);
            smbPkt.initTransactReply(null, 0, null, 0);
            smbPkt.setError(0, 0);
            this.m_sess.sendResponseSMB(smbPkt);
        } else {
            this.m_sess.sendErrorResponseSMB(smbPkt, 1, 2);
        }
    }

    protected final void procNTTransactNotifyChange(NTTransPacket ntpkt, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        NotifyRequest req;
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = ntpkt.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getContext() == null || !(conn.getContext() instanceof DiskDeviceContext)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasChangeHandler()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 1, 2);
            return;
        }
        ntpkt.resetSetupPointer();
        int filter = ntpkt.unpackInt();
        int fid = ntpkt.unpackWord();
        boolean watchTree = ntpkt.unpackByte() == 1;
        int mid = ntpkt.getMultiplexId();
        NetworkFile dir = conn.findFile(fid);
        if (dir == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int maxQueue = 0;
        if (this.m_sess.hasDebug(0x100000)) {
            this.m_sess.debugPrintln("NT NotifyChange fid=" + fid + ", mid=" + mid + ", filter=0x" + Integer.toHexString(filter) + ", dir=" + dir.getFullName() + ", maxQueue=" + maxQueue);
        }
        if ((req = this.m_sess.findNotifyRequest(dir, filter, watchTree)) != null && req.isCompleted()) {
            req.setMultiplexId(mid);
            req.setCompleted(false);
            if (req.hasBufferedEvents() || req.hasNotifyEnum()) {
                NotifyChangeEventList bufList = req.getBufferedEventList();
                req.clearBufferedEvents();
                diskCtx.getChangeHandler().sendBufferedNotifications(req, bufList);
                if (this.m_sess.hasDebug(0x100000)) {
                    if (bufList == null) {
                        this.m_sess.debugPrintln("   Sent buffered notifications, req=" + req.toString() + ", Enum");
                    } else {
                        this.m_sess.debugPrintln("   Sent buffered notifications, req=" + req.toString() + ", count=" + bufList.numberOfEvents());
                    }
                }
            } else if (this.m_sess.hasDebug(0x100000)) {
                this.m_sess.debugPrintln("   Reset notify request, " + req.toString());
            }
        } else {
            req = new NotifyRequest(filter, watchTree, this.m_sess, dir, mid, ntpkt.getTreeId(), ntpkt.getProcessId(), ntpkt.getUserId(), maxQueue);
            this.m_sess.addNotifyRequest(req, diskCtx);
            if (this.m_sess.hasDebug(0x100000)) {
                this.m_sess.debugPrintln("   Added new request, " + req.toString());
                this.m_sess.debugPrintln("   Global notify mask = 0x" + Integer.toHexString(diskCtx.getChangeHandler().getGlobalNotifyMask()) + ", reqQueue=" + diskCtx.getChangeHandler().getRequestQueueSize());
            }
        }
    }

    protected final void procNTTransactRename(SrvTransactBuffer tbuf, NTTransPacket smbPkt) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT TransactRename");
        }
        this.m_sess.sendErrorResponseSMB(smbPkt, 1, 2);
    }

    private final void checkOpLock(SMBSrvSession sess, SMBSrvPacket pkt, DiskInterface disk, FileOpenParams params, TreeConnection tree) throws DeferredPacketException, AccessDeniedException {
        if (disk instanceof OpLockInterface) {
            OpLockInterface oplockIface = (OpLockInterface)((Object)disk);
            if (!oplockIface.isOpLocksEnabled(sess, tree)) {
                return;
            }
            OpLockManager oplockMgr = oplockIface.getOpLockManager(sess, tree);
            if (oplockMgr == null) {
                if (sess.hasDebug(0x8000000)) {
                    this.m_sess.debugPrintln("OpLock manager is null, tree=" + tree);
                }
                return;
            }
            OpLockDetails oplock = oplockMgr.getOpLockDetails(params.getFullPath());
            if (oplock != null) {
                SMBSrvSession opSess = oplock.getOwnerSession();
                if (!opSess.isShutdown()) {
                    if (opSess.getUniqueId() == sess.getUniqueId() && oplock.getOwnerPID() == pkt.getProcessId()) {
                        return;
                    }
                    if ((params.getAccessMode() & 0x100180) == 0) {
                        return;
                    }
                    if (oplock.hasOplockBreakFailed()) {
                        if (this.m_sess.hasDebug(0x8000000)) {
                            this.m_sess.debugPrintln("Oplock has failed break attempt, failing open request params=" + params);
                        }
                        throw new AccessDeniedException("Oplock has failed break");
                    }
                    SMBSrvPacket opBreakPkt = null;
                    boolean deferredPkt = false;
                    try {
                        if (this.m_sess.hasDebug(0x8000000)) {
                            this.m_sess.debugPrintln("Oplock break required, owner=" + oplock + ", open=" + sess.getUniqueId() + ", PID=" + pkt.getProcessId() + ", MID=" + pkt.getMultiplexId());
                        }
                        oplock.setDeferredSession(this.m_sess, pkt);
                        opBreakPkt = new SMBSrvPacket(128);
                        opBreakPkt.clearHeader();
                        opBreakPkt.setCommand(36);
                        opBreakPkt.setFlags(0);
                        opBreakPkt.setFlags2(0);
                        opBreakPkt.setTreeId(oplock.getOwnerTreeId());
                        opBreakPkt.setProcessId(65535);
                        opBreakPkt.setUserId(0);
                        opBreakPkt.setMultiplexId(65535);
                        opBreakPkt.setParameterCount(8);
                        opBreakPkt.setAndXCommand(255);
                        opBreakPkt.setParameter(1, 0);
                        opBreakPkt.setParameter(2, oplock.getOwnerFileId());
                        opBreakPkt.setParameter(3, 258);
                        opBreakPkt.setParameterLong(4, 0);
                        opBreakPkt.setParameter(6, 0);
                        opBreakPkt.setParameter(7, 0);
                        opBreakPkt.setByteCount(0);
                        boolean breakSent = opSess.sendAsynchResponseSMB(opBreakPkt, opBreakPkt.getLength());
                        if (this.m_sess.hasDebug(0x8000000)) {
                            this.m_sess.debugPrintln("Oplock break sent to " + opSess.getUniqueId() + " async=" + (breakSent ? "Sent" : "Queued"));
                        }
                        deferredPkt = true;
                        oplockMgr.informOpLockBreakInProgress(oplock.getPath(), oplock);
                    }
                    catch (IOException ex) {
                        Debug.println("Failed to send oplock break:", 1);
                        Debug.println(ex, 1);
                        throw new AccessDeniedException("Oplock break send failed");
                    }
                    if (deferredPkt) {
                        throw new DeferredPacketException("Waiting for oplock break");
                    }
                } else {
                    oplockMgr.releaseOpLock(oplock.getPath());
                    if (this.m_sess.hasDebug(0x8000000)) {
                        this.m_sess.debugPrintln("Oplock released, session invalid sess=" + opSess.getUniqueId());
                    }
                }
            }
        }
    }

    private final OpLockDetails grantOpLock(SMBSrvSession sess, SMBSrvPacket pkt, DiskInterface disk, TreeConnection tree, FileOpenParams params, NetworkFile netFile) {
        OpLockDetails oplock;
        block12: {
            if (netFile.isDirectory() || !params.requestBatchOpLock() && !params.requestExclusiveOpLock()) {
                return null;
            }
            oplock = null;
            if (disk instanceof OpLockInterface) {
                OpLockInterface oplockIface = (OpLockInterface)((Object)disk);
                if (!oplockIface.isOpLocksEnabled(sess, tree)) {
                    return null;
                }
                OpLockManager oplockMgr = oplockIface.getOpLockManager(sess, tree);
                if (oplockMgr != null) {
                    int oplockTyp = 0;
                    oplockTyp = params.requestBatchOpLock() ? 1 : 2;
                    oplock = new OpLockDetails(oplockTyp, params.getPath(), sess, pkt, netFile.isDirectory());
                    try {
                        if (oplockMgr.grantOpLock(params.getPath(), oplock)) {
                            netFile.setOpLock(oplock);
                            if (sess.hasDebug(0x8000000)) {
                                this.m_sess.debugPrintln("Granted oplock sess=" + sess.getUniqueId() + " oplock=" + oplock);
                            }
                            break block12;
                        }
                        if (sess.hasDebug(0x8000000)) {
                            this.m_sess.debugPrintln("Oplock not granted sess=" + sess.getUniqueId() + " oplock=" + oplock);
                        }
                        oplock = null;
                    }
                    catch (ExistingOpLockException ex) {
                        if (sess.hasDebug(0x8000000)) {
                            this.m_sess.debugPrintln("Failed to grant oplock sess=" + sess.getUniqueId() + ", file=" + params.getPath() + " (Oplock exists)");
                        }
                        oplock = null;
                    }
                } else if (sess.hasDebug(0x8000000)) {
                    this.m_sess.debugPrintln("OpLock manager is null, tree=" + tree);
                }
            }
        }
        return oplock;
    }

    private final void releaseOpLock(SMBSrvSession sess, SMBSrvPacket pkt, DiskInterface disk, TreeConnection tree, NetworkFile netFile) {
        OpLockDetails oplock;
        OpLockInterface oplockIface;
        OpLockManager oplockMgr;
        if (disk instanceof OpLockInterface && (oplockMgr = (oplockIface = (OpLockInterface)((Object)disk)).getOpLockManager(sess, tree)) != null && (oplock = netFile.getOpLock()) != null) {
            oplockMgr.releaseOpLock(oplock.getPath());
            netFile.setOpLock(null);
            if (sess.hasDebug(0x8000000)) {
                this.m_sess.debugPrintln("Released oplock sess=" + sess.getUniqueId() + " oplock=" + oplock);
            }
        }
    }
}

