/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TooManyConnectionsException;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.smb.server.SrvTransactBuffer;

public class VirtualCircuit {
    public static final int DefaultConnections = 4;
    public static final int MaxConnections = 16;
    private static final int TreeIdMask = 65535;
    private static final int DefaultSearches = 8;
    private static final int MaxSearches = 256;
    public static final int InvalidUID = -1;
    private int m_uid = -1;
    private int m_vcNum;
    private ClientInfo m_clientInfo;
    private Hashtable<Integer, TreeConnection> m_connections;
    private int m_treeId = 1;
    private SearchContext[] m_search;
    private int m_searchCount;
    private SrvTransactBuffer m_transact;
    private boolean m_loggedOn;

    public VirtualCircuit(int vcNum, ClientInfo cInfo) {
        this.m_vcNum = vcNum;
        this.m_clientInfo = cInfo;
        this.m_loggedOn = true;
    }

    public final int getUID() {
        return this.m_uid;
    }

    public final int getVCNumber() {
        return this.m_vcNum;
    }

    public final ClientInfo getClientInformation() {
        return this.m_clientInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addConnection(SharedDevice shrDev) throws TooManyConnectionsException {
        if (this.m_connections == null) {
            this.m_connections = new Hashtable(4);
        }
        int treeId = 0;
        Hashtable<Integer, TreeConnection> hashtable = this.m_connections;
        synchronized (hashtable) {
            if (this.m_connections.size() == 16) {
                throw new TooManyConnectionsException();
            }
            treeId = this.m_treeId++ & 0xFFFF;
            Integer key = new Integer(treeId);
            while (this.m_connections.contains(key)) {
                treeId = this.m_treeId++ & 0xFFFF;
                key = new Integer(treeId);
            }
            this.m_connections.put(key, new TreeConnection(shrDev));
        }
        return treeId;
    }

    public final TreeConnection findConnection(int treeId) {
        if (this.m_connections == null) {
            return null;
        }
        return this.m_connections.get(new Integer(treeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(int treeId, SrvSession sess) {
        if (this.m_connections == null) {
            return;
        }
        Hashtable<Integer, TreeConnection> hashtable = this.m_connections;
        synchronized (hashtable) {
            Integer key = new Integer(treeId);
            TreeConnection tree = this.m_connections.get(key);
            if (tree != null) {
                tree.closeConnection(sess);
                this.m_connections.remove(key);
            }
        }
    }

    public final int getConnectionCount() {
        return this.m_connections != null ? this.m_connections.size() : 0;
    }

    public final int allocateSearchSlot() {
        int idx;
        if (this.m_search == null) {
            this.m_search = new SearchContext[8];
        }
        for (idx = 0; idx < this.m_search.length && this.m_search[idx] != null; ++idx) {
        }
        if (idx == this.m_search.length) {
            if (this.m_search.length >= 256) {
                return -1;
            }
            SearchContext[] newSearch = new SearchContext[this.m_search.length * 2];
            System.arraycopy(this.m_search, 0, newSearch, 0, this.m_search.length);
            this.m_search = newSearch;
        }
        ++this.m_searchCount;
        return idx;
    }

    public final void deallocateSearchSlot(int ctxId) {
        if (this.m_search == null || ctxId >= this.m_search.length) {
            return;
        }
        if (this.m_search[ctxId] != null) {
            this.m_search[ctxId].closeSearch();
        }
        --this.m_searchCount;
        this.m_search[ctxId] = null;
    }

    public final SearchContext getSearchContext(int srchId) {
        if (this.m_search == null || srchId >= this.m_search.length) {
            return null;
        }
        return this.m_search[srchId];
    }

    public final void setSearchContext(int slot, SearchContext srch) {
        if (this.m_search == null || slot > this.m_search.length) {
            return;
        }
        this.m_search[slot] = srch;
    }

    public final int getSearchCount() {
        return this.m_searchCount;
    }

    public final boolean hasTransaction() {
        return this.m_transact != null;
    }

    public final SrvTransactBuffer getTransaction() {
        return this.m_transact;
    }

    public final void setTransaction(SrvTransactBuffer buf) {
        this.m_transact = buf;
    }

    public final void setUID(int uid) {
        this.m_uid = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeCircuit(SrvSession sess) {
        if (sess.hasDebug(2)) {
            sess.debugPrintln("Cleanup vc=" + this.getVCNumber() + ", UID=" + this.getUID() + ", searches=" + this.getSearchCount() + ", treeConns=" + this.getConnectionCount());
        }
        if (this.m_search != null) {
            for (int idx = 0; idx < this.m_search.length; ++idx) {
                if (this.m_search[idx] == null) continue;
                this.deallocateSearchSlot(idx);
            }
            this.m_search = null;
            this.m_searchCount = 0;
        }
        if (this.m_connections != null) {
            Hashtable<Integer, TreeConnection> hashtable = this.m_connections;
            synchronized (hashtable) {
                Enumeration<TreeConnection> enm = this.m_connections.elements();
                while (enm.hasMoreElements()) {
                    TreeConnection tree = enm.nextElement();
                    DeviceInterface devIface = tree.getInterface();
                    if (tree.openFileCount() > 0) {
                        for (int i = 0; i < tree.getFileTableLength(); ++i) {
                            NetworkFile curFile = tree.findFile(i);
                            if (curFile == null || !(devIface instanceof DiskInterface)) continue;
                            DiskInterface diskIface = (DiskInterface)devIface;
                            try {
                                tree.removeFile(i, sess);
                                diskIface.closeFile(sess, tree, curFile);
                                continue;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    if (devIface == null) continue;
                    devIface.treeClosed(sess, tree);
                }
                this.m_connections.clear();
            }
        }
    }

    public final boolean isLoggedOn() {
        return this.m_loggedOn;
    }

    public final void setLoggedOn(boolean loggedOn) {
        this.m_loggedOn = loggedOn;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getVCNumber());
        str.append(":");
        str.append(this.getUID());
        str.append(",");
        str.append(this.getClientInformation());
        str.append(",Tree=");
        str.append(this.getConnectionCount());
        str.append(",Searches=");
        str.append(this.getSearchCount());
        str.append("]");
        return str.toString();
    }
}

