/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.smb.server.VirtualCircuit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualCircuitList {
    public static final int DefaultCircuits = 4;
    public static final int MaxCircuits = 16;
    private static final int UIDMask = 65535;
    private Hashtable<Integer, VirtualCircuit> m_vcircuits;
    private int m_UID = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCircuit(VirtualCircuit vcircuit) {
        if (this.m_vcircuits == null) {
            this.m_vcircuits = new Hashtable(4);
        }
        int uid = 0;
        Hashtable<Integer, VirtualCircuit> hashtable = this.m_vcircuits;
        synchronized (hashtable) {
            if (this.m_vcircuits.size() == 16) {
                return -1;
            }
            uid = this.m_UID++ & 0xFFFF;
            Integer key = new Integer(uid);
            while (this.m_vcircuits.contains(key)) {
                uid = this.m_UID++ & 0xFFFF;
                key = new Integer(uid);
            }
            vcircuit.setUID(uid);
            this.m_vcircuits.put(key, vcircuit);
        }
        return uid;
    }

    public final VirtualCircuit findCircuit(int uid) {
        if (this.m_vcircuits == null) {
            return null;
        }
        return this.m_vcircuits.get(new Integer(uid));
    }

    public final VirtualCircuit findCircuit(Integer uid) {
        if (this.m_vcircuits == null) {
            return null;
        }
        return this.m_vcircuits.get(uid);
    }

    public final Enumeration<Integer> enumerateUIDs() {
        return this.m_vcircuits.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCircuit(int uid, SrvSession sess) {
        if (this.m_vcircuits == null) {
            return;
        }
        Hashtable<Integer, VirtualCircuit> hashtable = this.m_vcircuits;
        synchronized (hashtable) {
            Integer key = new Integer(uid);
            VirtualCircuit vc = this.m_vcircuits.get(key);
            if (vc != null) {
                vc.closeCircuit(sess);
                this.m_vcircuits.remove(key);
            }
        }
    }

    public final int getCircuitCount() {
        return this.m_vcircuits != null ? this.m_vcircuits.size() : 0;
    }

    public final void clearCircuitList() {
        this.m_vcircuits.clear();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[VCs=");
        str.append(this.getCircuitCount());
        str.append("]");
        return str.toString();
    }
}

