/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.win32;

import java.util.BitSet;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.win32.NetBIOSSocket;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.netbios.win32.WinsockNetBIOSException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.mailslot.win32.Win32NetBIOSHostAnnouncer;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.win32.LanaListener;
import org.alfresco.jlan.smb.server.win32.Win32NetBIOSSessionSocketHandler;

public class Win32NetBIOSLanaMonitor
extends Thread {
    private static final int LanaListenerArraySize = 16;
    private static Win32NetBIOSLanaMonitor _lanaMonitor;
    private BitSet m_lanas;
    private BitSet m_lanaSts;
    private LanaListener[] m_listeners;
    private SMBServer m_server;
    private boolean m_shutdown;
    private boolean m_debug;

    public Win32NetBIOSLanaMonitor(SMBServer server, int[] lanas, long wakeup, boolean debug) {
        int[] curLanas;
        this.m_server = server;
        this.m_debug = debug;
        this.m_lanas = new BitSet();
        this.m_lanaSts = new BitSet();
        if (lanas != null) {
            for (int i = 0; i < lanas.length; ++i) {
                this.m_lanas.set(lanas[i]);
            }
        }
        if ((curLanas = Win32NetBIOS.LanaEnumerate()) != null) {
            for (int i = 0; i < curLanas.length; ++i) {
                this.m_lanaSts.set(curLanas[i], true);
            }
        }
        if (_lanaMonitor == null) {
            _lanaMonitor = this;
        }
        this.setDaemon(true);
        this.start();
    }

    public static Win32NetBIOSLanaMonitor getLanaMonitor() {
        return _lanaMonitor;
    }

    public final synchronized void addLanaListener(int lana, LanaListener l) {
        if (lana < 0 || lana > 255) {
            return;
        }
        if (this.m_listeners == null) {
            int len = 16;
            if (lana > len) {
                len = lana + 3 & 0xFC;
            }
            this.m_listeners = new LanaListener[len];
        } else if (lana >= this.m_listeners.length) {
            LanaListener[] newArray = new LanaListener[lana + 3 & 0xFC];
            System.arraycopy(this.m_listeners, 0, newArray, 0, this.m_listeners.length);
            this.m_listeners = newArray;
        }
        this.m_listeners[lana] = l;
        if (this.hasDebug()) {
            Debug.println("[SMB] Win32 NetBIOS register listener for LANA " + lana);
        }
    }

    public final synchronized void removeLanaListener(int lana) {
        if (this.m_listeners == null || lana < 0 || lana >= this.m_listeners.length) {
            return;
        }
        this.m_listeners[lana] = null;
    }

    public void run() {
        this.m_shutdown = false;
        ServerConfiguration config = this.m_server.getConfiguration();
        CIFSConfigSection cifsConfig = (CIFSConfigSection)config.getConfigSection("CIFS");
        if (!cifsConfig.useWinsockNetBIOS()) {
            try {
                NetBIOSSocket.initializeSockets();
            }
            catch (WinsockNetBIOSException ex) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Win32 NetBIOS initialization error");
                    Debug.println(ex);
                }
                this.m_shutdown = true;
            }
        }
        BitSet curLanas = new BitSet();
        while (!this.m_shutdown) {
            Win32NetBIOS.waitForNetworkAddressChange();
            if (this.m_shutdown) continue;
            curLanas.clear();
            int[] lanas = Win32NetBIOS.LanaEnumerate();
            if (lanas != null) {
                int i;
                Win32NetBIOSSessionSocketHandler sessHandler = null;
                for (i = 0; i < lanas.length; ++i) {
                    int lana = lanas[i];
                    curLanas.set(lana, true);
                    if (!this.m_lanas.get(lana)) {
                        if (this.hasDebug()) {
                            Debug.println("[SMB] Win32 NetBIOS found new LANA, " + lana);
                        }
                        sessHandler = new Win32NetBIOSSessionSocketHandler(this.m_server, lana, this.hasDebug());
                        try {
                            sessHandler.initializeSessionHandler(this.m_server);
                        }
                        catch (Exception ex) {
                            if (this.hasDebug()) {
                                Debug.println("[SMB] Win32 NetBIOS failed to create session handler for LANA " + lana);
                                Debug.println(ex);
                            }
                            sessHandler = null;
                        }
                        if (sessHandler == null) continue;
                        Thread nbThread = new Thread(sessHandler);
                        nbThread.setName("Win32NB_Handler_" + lana);
                        nbThread.start();
                        if (this.hasDebug()) {
                            Debug.println("[SMB] Win32 NetBIOS created session handler on LANA " + lana);
                        }
                        if (cifsConfig.hasWin32EnableAnnouncer()) {
                            Win32NetBIOSHostAnnouncer hostAnnouncer = new Win32NetBIOSHostAnnouncer(sessHandler, cifsConfig.getDomainName(), cifsConfig.getWin32HostAnnounceInterval());
                            hostAnnouncer.start();
                            if (this.hasDebug()) {
                                Debug.println("[SMB] Win32 NetBIOS host announcer enabled on LANA " + lana);
                            }
                        }
                        this.m_lanas.set(lana);
                        this.m_lanaSts.set(lana, true);
                        continue;
                    }
                    if (this.m_lanaSts.get(lana)) continue;
                    this.m_lanaSts.set(lana, true);
                    if (this.m_listeners != null && lana < this.m_listeners.length && this.m_listeners[lana] != null) {
                        this.m_listeners[lana].lanaStatusChange(lana, true);
                    }
                    if (!this.hasDebug()) continue;
                    Debug.println("[SMB] Win32 NetBIOS LANA online - " + lana);
                }
                for (i = 0; i < this.m_lanaSts.length(); ++i) {
                    if (curLanas.get(i) || !this.m_lanaSts.get(i)) continue;
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Win32 NetBIOS LANA offline - " + i);
                    }
                    this.m_lanaSts.set(i, false);
                    if (this.m_listeners == null || this.m_listeners[i] == null) continue;
                    this.m_listeners[i].lanaStatusChange(i, false);
                }
                continue;
            }
            if (this.m_lanaSts.length() != 0) continue;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void shutdownRequest() {
        this.m_shutdown = true;
        if (this.m_server.getCIFSConfiguration().useWinsockNetBIOS()) {
            NetBIOSSocket.shutdownSockets();
        }
        this.interrupt();
        if (this == _lanaMonitor) {
            _lanaMonitor = null;
        }
    }
}

