/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.DigitalSignatureTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.MemoryTTFDataStream;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.RAFDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class TTFParser {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("usage: java org.pdfbox.ttf.TTFParser <ttf-file>");
            System.exit(-1);
        }
        TTFParser parser = new TTFParser();
        TrueTypeFont font = parser.parseTTF(args[0]);
        System.out.println("Font:" + font);
    }

    public TrueTypeFont parseTTF(String ttfFile) throws IOException {
        RAFDataStream raf = new RAFDataStream(ttfFile, "r");
        return this.parseTTF(raf);
    }

    public TrueTypeFont parseTTF(File ttfFile) throws IOException {
        RAFDataStream raf = new RAFDataStream(ttfFile, "r");
        return this.parseTTF(raf);
    }

    public TrueTypeFont parseTTF(InputStream ttfData) throws IOException {
        return this.parseTTF(new MemoryTTFDataStream(ttfData));
    }

    public TrueTypeFont parseTTF(TTFDataStream raf) throws IOException {
        TrueTypeFont font = new TrueTypeFont(raf);
        font.setVersion(raf.read32Fixed());
        int numberOfTables = raf.readUnsignedShort();
        int searchRange = raf.readUnsignedShort();
        int entrySelector = raf.readUnsignedShort();
        int rangeShift = raf.readUnsignedShort();
        for (int i = 0; i < numberOfTables; ++i) {
            TTFTable table = this.readTableDirectory(raf);
            font.addTable(table);
        }
        ArrayList<TTFTable> initialized = new ArrayList<TTFTable>();
        HeaderTable head = font.getHeader();
        if (head == null) {
            throw new IOException("head is mandatory");
        }
        raf.seek(head.getOffset());
        head.initData(font, raf);
        initialized.add(head);
        HorizontalHeaderTable hh = font.getHorizontalHeader();
        if (hh == null) {
            throw new IOException("hhead is mandatory");
        }
        raf.seek(hh.getOffset());
        hh.initData(font, raf);
        initialized.add(hh);
        MaximumProfileTable maxp = font.getMaximumProfile();
        if (maxp == null) {
            throw new IOException("maxp is mandatory");
        }
        raf.seek(maxp.getOffset());
        maxp.initData(font, raf);
        initialized.add(maxp);
        PostScriptTable post = font.getPostScript();
        if (post == null) {
            throw new IOException("post is mandatory");
        }
        raf.seek(post.getOffset());
        post.initData(font, raf);
        initialized.add(post);
        IndexToLocationTable loc = font.getIndexToLocation();
        if (loc == null) {
            throw new IOException("loca is mandatory");
        }
        raf.seek(loc.getOffset());
        loc.initData(font, raf);
        initialized.add(loc);
        for (TTFTable table : font.getTables()) {
            if (initialized.contains(table)) continue;
            raf.seek(table.getOffset());
            table.initData(font, raf);
        }
        return font;
    }

    private TTFTable readTableDirectory(TTFDataStream raf) throws IOException {
        TTFTable retval = null;
        String tag = raf.readString(4);
        retval = tag.equals("cmap") ? new CMAPTable() : (tag.equals("glyf") ? new GlyphTable() : (tag.equals("head") ? new HeaderTable() : (tag.equals("hhea") ? new HorizontalHeaderTable() : (tag.equals("hmtx") ? new HorizontalMetricsTable() : (tag.equals("loca") ? new IndexToLocationTable() : (tag.equals("maxp") ? new MaximumProfileTable() : (tag.equals("name") ? new NamingTable() : (tag.equals("OS/2") ? new OS2WindowsMetricsTable() : (tag.equals("post") ? new PostScriptTable() : (tag.equals("DSIG") ? new DigitalSignatureTable() : new TTFTable()))))))))));
        retval.setTag(tag);
        retval.setCheckSum(raf.readUnsignedInt());
        retval.setOffset(raf.readUnsignedInt());
        retval.setLength(raf.readUnsignedInt());
        return retval;
    }
}

