/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.dictionary.constraint.ConstraintRegistry;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConstraint
implements Constraint {
    public static final String ERR_PROP_NOT_SET = "d_dictionary.constraint.err.property_not_set";
    public static final String ERR_EVALUATE_EXCEPTION = "d_dictionary.constraint.err.evaluate_exception";
    private String shortName;
    private String title;
    private ConstraintRegistry registry;

    public void set_shortName(String shortName) {
        this.setShortName(shortName);
    }

    public void setShortName(String name) {
        this.shortName = name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public void setRegistry(ConstraintRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Map<String, Object> getParameters() {
        return new HashMap<String, Object>(3);
    }

    @Override
    public void initialize() {
        if (this.registry != null) {
            this.registry.register(this.shortName, this);
        }
    }

    protected void checkPropertyNotNull(String name, Object value) {
        if (value == null) {
            throw new DictionaryException(ERR_PROP_NOT_SET, name, this.getShortName());
        }
    }

    @Override
    public final void evaluate(Object value) {
        if (value == null) {
            return;
        }
        try {
            if (DefaultTypeConverter.INSTANCE.isMultiValued(value)) {
                Collection<Object> collection = DefaultTypeConverter.INSTANCE.getCollection(Object.class, value);
                this.evaluateCollection(collection);
            } else {
                this.evaluateSingleValue(value);
            }
        }
        catch (ConstraintException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DictionaryException(ERR_EVALUATE_EXCEPTION, this, e.getMessage());
        }
    }

    protected void evaluateCollection(Collection<Object> collection) {
        for (Object value : collection) {
            if (value == null) continue;
            this.evaluateSingleValue(value);
        }
    }

    protected abstract void evaluateSingleValue(Object var1);
}

