/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import junit.framework.TestCase;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;

public class DynamicNameSpaceResolverTest
extends TestCase {
    public void testOne() {
        DynamicNamespacePrefixResolver dnpr = new DynamicNamespacePrefixResolver(null);
        dnpr.registerNamespace("one", "http:/namespace/one");
        dnpr.registerNamespace("two", "http:/namespace/two");
        dnpr.registerNamespace("three", "http:/namespace/three");
        dnpr.registerNamespace("oneagain", "http:/namespace/one");
        dnpr.registerNamespace("four", "http:/namespace/one");
        dnpr.registerNamespace("four", "http:/namespace/four");
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/one", (String)dnpr.getNamespaceURI("one"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/two", (String)dnpr.getNamespaceURI("two"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/three", (String)dnpr.getNamespaceURI("three"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/one", (String)dnpr.getNamespaceURI("oneagain"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/four", (String)dnpr.getNamespaceURI("four"));
        DynamicNameSpaceResolverTest.assertEquals(null, (String)dnpr.getNamespaceURI("five"));
        dnpr.unregisterNamespace("four");
        DynamicNameSpaceResolverTest.assertEquals(null, (String)dnpr.getNamespaceURI("four"));
        DynamicNameSpaceResolverTest.assertEquals((int)0, (int)dnpr.getPrefixes("http:/namespace/four").size());
        DynamicNameSpaceResolverTest.assertEquals((int)1, (int)dnpr.getPrefixes("http:/namespace/two").size());
        DynamicNameSpaceResolverTest.assertEquals((int)2, (int)dnpr.getPrefixes("http:/namespace/one").size());
    }

    public void testTwo() {
        DynamicNamespacePrefixResolver dnpr1 = new DynamicNamespacePrefixResolver(null);
        dnpr1.registerNamespace("one", "http:/namespace/one");
        dnpr1.registerNamespace("two", "http:/namespace/two");
        dnpr1.registerNamespace("three", "http:/namespace/three");
        dnpr1.registerNamespace("oneagain", "http:/namespace/one");
        dnpr1.registerNamespace("four", "http:/namespace/one");
        dnpr1.registerNamespace("four", "http:/namespace/four");
        dnpr1.registerNamespace("five", "http:/namespace/five");
        dnpr1.registerNamespace("six", "http:/namespace/six");
        DynamicNamespacePrefixResolver dnpr2 = new DynamicNamespacePrefixResolver(dnpr1);
        dnpr2.registerNamespace("a", "http:/namespace/one");
        dnpr2.registerNamespace("b", "http:/namespace/two");
        dnpr2.registerNamespace("c", "http:/namespace/three");
        dnpr2.registerNamespace("d", "http:/namespace/one");
        dnpr2.registerNamespace("e", "http:/namespace/one");
        dnpr2.registerNamespace("f", "http:/namespace/four");
        dnpr2.registerNamespace("five", "http:/namespace/one");
        dnpr2.registerNamespace("six", "http:/namespace/seven");
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/one", (String)dnpr2.getNamespaceURI("one"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/two", (String)dnpr2.getNamespaceURI("two"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/three", (String)dnpr2.getNamespaceURI("three"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/one", (String)dnpr2.getNamespaceURI("oneagain"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/four", (String)dnpr2.getNamespaceURI("four"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/one", (String)dnpr2.getNamespaceURI("five"));
        dnpr2.unregisterNamespace("five");
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/five", (String)dnpr2.getNamespaceURI("five"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/one", (String)dnpr2.getNamespaceURI("a"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/two", (String)dnpr2.getNamespaceURI("b"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/three", (String)dnpr2.getNamespaceURI("c"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/one", (String)dnpr2.getNamespaceURI("d"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/one", (String)dnpr2.getNamespaceURI("e"));
        DynamicNameSpaceResolverTest.assertEquals((String)"http:/namespace/four", (String)dnpr2.getNamespaceURI("f"));
        DynamicNameSpaceResolverTest.assertEquals((int)5, (int)dnpr2.getPrefixes("http:/namespace/one").size());
        DynamicNameSpaceResolverTest.assertEquals((int)2, (int)dnpr2.getPrefixes("http:/namespace/two").size());
        DynamicNameSpaceResolverTest.assertEquals((int)2, (int)dnpr2.getPrefixes("http:/namespace/three").size());
        DynamicNameSpaceResolverTest.assertEquals((int)2, (int)dnpr2.getPrefixes("http:/namespace/four").size());
        DynamicNameSpaceResolverTest.assertEquals((int)1, (int)dnpr2.getPrefixes("http:/namespace/five").size());
        DynamicNameSpaceResolverTest.assertEquals((int)0, (int)dnpr2.getPrefixes("http:/namespace/six").size());
        DynamicNameSpaceResolverTest.assertEquals((int)1, (int)dnpr2.getPrefixes("http:/namespace/seven").size());
    }
}

