/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;
import org.springframework.web.context.ServletContextAware;

public class WebClientAuthenticatorFactory
implements ServletAuthenticatorFactory,
ServletContextAware {
    private static final Log logger = LogFactory.getLog(WebClientAuthenticator.class);
    private ServletContext context;

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        return new WebClientAuthenticator(req, res);
    }

    public class WebClientAuthenticator
    implements Authenticator {
        private WebScriptServletRequest servletReq;
        private WebScriptServletResponse servletRes;
        private String ticket;

        public WebClientAuthenticator(WebScriptServletRequest req, WebScriptServletResponse res) {
            this.servletReq = req;
            this.servletRes = res;
            this.ticket = req.getParameter("ticket");
        }

        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            AuthenticationStatus status = null;
            try {
                HttpServletRequest req = this.servletReq.getHttpServletRequest();
                HttpServletResponse res = this.servletRes.getHttpServletResponse();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Alfresco ticket provided: " + (this.ticket != null && this.ticket.length() > 0)));
                }
                if (!this.emptyCredentials()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Authenticating ticket " + this.ticket));
                    }
                    status = AuthenticationHelper.authenticate(WebClientAuthenticatorFactory.this.context, req, res, this.ticket);
                } else if (isGuest && Description.RequiredAuthentication.guest == required) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Authenticating as Guest");
                    }
                    status = AuthenticationHelper.authenticate(WebClientAuthenticatorFactory.this.context, req, res, true);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Authenticating session");
                    }
                    status = AuthenticationHelper.authenticate(WebClientAuthenticatorFactory.this.context, req, res, false, false);
                }
                if (status == null || status == AuthenticationStatus.Failure) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Redirecting to Alfresco Login");
                    }
                    BaseServlet.redirectToLoginPage(req, res, WebClientAuthenticatorFactory.this.context);
                }
            }
            catch (IOException e) {
                throw new WebScriptException("Failed to authenticate", (Throwable)e);
            }
            return status != null && status != AuthenticationStatus.Failure;
        }

        public boolean emptyCredentials() {
            return this.ticket == null || this.ticket.length() == 0;
        }
    }
}

