/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.action.evaluator;

import java.util.List;
import javax.faces.context.FacesContext;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.action.evaluator.BaseActionEvaluator;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;

public class RegenerateRenditionsEvaluator
extends BaseActionEvaluator {
    private static final long serialVersionUID = -3479861093052578775L;

    public boolean evaluate(Node node) {
        boolean isUserAllowed = false;
        FacesContext fc = FacesContext.getCurrentInstance();
        ServiceRegistry services = Repository.getServiceRegistry(fc);
        PermissionService permissionService = services.getPermissionService();
        WebProjectService webProjectService = services.getWebProjectService();
        NavigationBean navigator = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
        if (!webProjectService.hasWebProjectsRoot()) {
            return false;
        }
        List wpInfos = webProjectService.listWebProjects();
        for (WebProjectInfo wpInfo : wpInfos) {
            if (permissionService.hasPermission(wpInfo.getNodeRef(), "ContentManager") != AccessStatus.ALLOWED) continue;
            isUserAllowed = true;
            break;
        }
        Path path = navigator.getCurrentNode().getNodePath();
        boolean isWebFormsPath = false;
        for (Path.Element element : path) {
            String pathElement = element.getPrefixedString((NamespacePrefixResolver)services.getNamespaceService());
            if (!Application.getWebContentFormsFolderName(fc).equals(pathElement)) continue;
            isWebFormsPath = true;
            break;
        }
        return (node.hasAspect(WCMAppModel.ASPECT_RENDERING_ENGINE_TEMPLATE) || isWebFormsPath) && isUserAllowed;
    }
}

