/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugPhaseListener
implements PhaseListener {
    private static final Log logger = LogFactory.getLog(DebugPhaseListener.class);
    public int indent = 0;
    public static final String INDENT = "   ";

    public void afterPhase(PhaseEvent event) {
        if (logger.isDebugEnabled()) {
            if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                this.printComponentTree((UIComponent)FacesContext.getCurrentInstance().getViewRoot());
            }
            logger.debug((Object)("********** Exiting phase: " + event.getPhaseId().toString()));
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("********** Entering phase: " + event.getPhaseId().toString()));
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void printComponentTree(UIComponent comp) {
        this.printComponentInfo(comp);
        List complist = comp.getChildren();
        if (complist.size() > 0) {
            ++this.indent;
        }
        for (int i = 0; i < complist.size(); ++i) {
            UIComponent uicom = (UIComponent)complist.get(i);
            this.printComponentTree(uicom);
            if (i + 1 != complist.size()) continue;
            --this.indent;
        }
    }

    public void printComponentInfo(UIComponent comp) {
        if (comp.getId() == null) {
            logger.debug((Object)("UIViewRoot (" + comp.getClass().getName() + ")"));
        } else {
            logger.debug((Object)(this.getIndent() + "|"));
            logger.debug((Object)(this.getIndent() + comp.getId() + " " + "(" + comp.getClass().getName() + ")"));
        }
    }

    public String getIndent() {
        String indent = "";
        for (int i = 0; i < this.indent; ++i) {
            indent = indent + INDENT;
        }
        return indent;
    }
}

