/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import junit.framework.TestCase;
import org.alfresco.web.app.ResourceBundleBootstrap;
import org.alfresco.web.app.ResourceBundleWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleWrapperTest
extends TestCase {
    private static final String BUNDLE_NAME = "org.alfresco.web.app.resourceBundleWrapperTest";
    private static final String KEY_1 = "test_key_one";
    private static final String KEY_2 = "test_key_two";
    private static final String MSG_1 = "Test Key One";
    private static final String MSG_2 = "Test Key Two";

    public void testAddingBundles() {
        ResourceBundle before = ResourceBundleWrapper.getResourceBundle("alfresco.messages.webclient", Locale.US);
        Enumeration<String> keys = before.getKeys();
        ResourceBundleWrapperTest.assertFalse((boolean)this.containsValue(keys, KEY_1));
        ResourceBundleWrapperTest.assertFalse((boolean)this.containsValue(keys, KEY_2));
        try {
            before.getString(KEY_1);
            ResourceBundleWrapperTest.fail((String)"Not expecting the key to be there");
        }
        catch (Throwable exception) {
            // empty catch block
        }
        try {
            before.getString(KEY_2);
            ResourceBundleWrapperTest.fail((String)"Not expecting the key to be there");
        }
        catch (Throwable exception) {
            // empty catch block
        }
        ResourceBundleWrapper.addResourceBundle(BUNDLE_NAME);
        ResourceBundle after = ResourceBundleWrapper.getResourceBundle("alfresco.messages.webclient", Locale.US);
        Enumeration<String> keys2 = after.getKeys();
        ResourceBundleWrapperTest.assertTrue((boolean)this.containsValue(keys2, KEY_1));
        ResourceBundleWrapperTest.assertEquals((String)after.getString(KEY_1), (String)MSG_1);
        ResourceBundleWrapperTest.assertEquals((String)after.getString(KEY_2), (String)MSG_2);
    }

    public void testBootstrap() {
        ArrayList<String> bundles = new ArrayList<String>(1);
        bundles.add(BUNDLE_NAME);
        ResourceBundleBootstrap bootstrap = new ResourceBundleBootstrap();
        bootstrap.setResourceBundles(bundles);
        ResourceBundle after = ResourceBundleWrapper.getResourceBundle("alfresco.messages.webclient", Locale.US);
        Enumeration<String> keys2 = after.getKeys();
        ResourceBundleWrapperTest.assertTrue((boolean)this.containsValue(keys2, KEY_1));
        ResourceBundleWrapperTest.assertTrue((boolean)this.containsValue(keys2, KEY_2));
        ResourceBundleWrapperTest.assertEquals((String)after.getString(KEY_1), (String)MSG_1);
        ResourceBundleWrapperTest.assertEquals((String)after.getString(KEY_2), (String)MSG_2);
    }

    private boolean containsValue(Enumeration<String> values, String value) {
        boolean result = false;
        while (values.hasMoreElements()) {
            if (!values.nextElement().equals(value)) continue;
            result = true;
            break;
        }
        return result;
    }
}

