/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadRawContentServlet
extends BaseServlet {
    private static final long serialVersionUID = 2973080032044411358L;
    private static Log logger = LogFactory.getLog(DownloadRawContentServlet.class);
    private static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final String ARG_CONTENT_URL = "contentUrl";
    private static final String ARG_INFO_ONLY = "infoOnly";

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        AuthenticationStatus status;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticating downloadDirect request: " + req.getRequestURI()));
        }
        if ((status = this.servletAuthenticate(req, res)) == AuthenticationStatus.Failure) {
            return;
        }
        DownloadRawContentServlet.setNoCacheHeaders(res);
        this.processRequest(req, res);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block12: {
            String uri = req.getRequestURI();
            String contentUrl = req.getParameter(ARG_CONTENT_URL);
            if (contentUrl == null || contentUrl.length() == 0) {
                throw new IllegalArgumentException("Download URL did not contain parameter 'contentUrl':" + uri);
            }
            String infoOnlyStr = req.getParameter(ARG_INFO_ONLY);
            boolean infoOnly = infoOnlyStr == null ? false : Boolean.parseBoolean(infoOnlyStr);
            ServiceRegistry serviceRegistry = DownloadRawContentServlet.getServiceRegistry(this.getServletContext());
            ContentService contentService = serviceRegistry.getContentService();
            ContentReader reader = null;
            try {
                reader = contentService.getRawReader(contentUrl);
                if (!reader.exists()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Returning 204 Not Found error...");
                    }
                    res.sendError(204);
                    return;
                }
            }
            catch (AccessDeniedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Returning 403 Forbidden error after exception: ", (Throwable)e);
                }
                res.sendError(403);
                return;
            }
            long readerSize = reader.getSize();
            Date readerLastModified = new Date(reader.getLastModified());
            String readerMimetype = reader.getMimetype();
            String readerEncoding = reader.getEncoding();
            Locale readerLocale = reader.getLocale();
            res.setHeader("alfresco.dr.size", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)readerSize));
            res.setHeader("alfresco.dr.lastModified", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)readerLastModified));
            res.setHeader("alfresco.dr.mimetype", readerMimetype);
            res.setHeader("alfresco.dr.encoding", readerEncoding);
            res.setHeader("alfresco.dr.locale", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)readerLocale));
            if (infoOnly) {
                res.setContentType(DEFAULT_MIMETYPE);
                res.setCharacterEncoding(DEFAULT_ENCODING);
            } else {
                res.setContentType(readerMimetype);
                res.setCharacterEncoding(readerEncoding);
                try {
                    ServletOutputStream clientOs = res.getOutputStream();
                    reader.getContent((OutputStream)clientOs);
                }
                catch (SocketException e1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Client aborted stream read:\n   Content URL: " + contentUrl));
                    }
                }
                catch (ContentIOException e2) {
                    if (!logger.isDebugEnabled()) break block12;
                    logger.debug((Object)("Client aborted stream read:\n   Content URL: " + contentUrl));
                }
            }
        }
    }
}

